/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel;

import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.StyleEntry;

public class StyleBuilder {
    public static final String C_PATTERN = "(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)";
    public static final Pattern colorp = Pattern.compile("(rgb\\()(\\d+)\\,(\\s?\\d+)\\,(\\s?\\d+)\\)", 2);
    private static Logger logger = Logger.getLogger(StyleBuilder.class.getName());

    public static StyleEntry createStyleEntry(IStyle style) {
        StyleEntry entry = new StyleEntry();
        entry.setProperty(6, StyleBuilder.convertColor(style.getBackgroundColor()));
        float width = Float.parseFloat(style.getBorderBottomWidth());
        if (width > 0.0f) {
            entry.setProperty(10, StyleBuilder.convertColor(style.getBorderBottomColor()));
            entry.setProperty(11, StyleBuilder.convertBorderStyle(style.getBorderBottomStyle()));
            entry.setProperty(12, StyleBuilder.convertBorderWeight(style.getBorderBottomWidth()));
        }
        if ((width = Float.parseFloat(style.getBorderTopWidth())) > 0.0f) {
            entry.setProperty(13, StyleBuilder.convertColor(style.getBorderTopColor()));
            entry.setProperty(14, StyleBuilder.convertBorderStyle(style.getBorderTopStyle()));
            entry.setProperty(15, StyleBuilder.convertBorderWeight(style.getBorderTopWidth()));
        }
        if ((width = Float.parseFloat(style.getBorderLeftWidth())) > 0.0f) {
            entry.setProperty(16, StyleBuilder.convertColor(style.getBorderLeftColor()));
            entry.setProperty(17, StyleBuilder.convertBorderStyle(style.getBorderLeftStyle()));
            entry.setProperty(18, StyleBuilder.convertBorderWeight(style.getBorderLeftWidth()));
        }
        if ((width = Float.parseFloat(style.getBorderRightWidth())) > 0.0f) {
            entry.setProperty(19, StyleBuilder.convertColor(style.getBorderRightColor()));
            entry.setProperty(20, StyleBuilder.convertBorderStyle(style.getBorderRightStyle()));
            entry.setProperty(21, StyleBuilder.convertBorderWeight(style.getBorderRightWidth()));
        }
        entry.setProperty(7, StyleBuilder.convertColor(style.getColor()));
        entry.setProperty(0, ExcelUtil.getValue(style.getFontFamily()));
        entry.setProperty(1, StyleBuilder.convertFontSize(style.getFontSize()));
        entry.setProperty(2, ExcelUtil.expression(style.getFontStyle(), "italic", new String[]{"0", "1"}, false));
        entry.setProperty(3, ExcelUtil.expression(style.getFontWeight(), "bold", new String[]{"0", "1"}, false));
        entry.setProperty(4, ExcelUtil.expression(style.getTextLineThrough(), "line-through", new String[]{"0", "1"}, false));
        entry.setProperty(5, ExcelUtil.expression(style.getTextUnderline(), "underline", new String[]{"0", "1"}, false));
        entry.setProperty(8, StyleBuilder.convertHAlign(style.getTextAlign(), style.getDirection()));
        entry.setProperty(9, StyleBuilder.convertVAlign(style.getVerticalAlign()));
        entry.setProperty(22, style.getDateFormat());
        entry.setProperty(23, style.getNumberFormat());
        entry.setProperty(24, style.getStringFormat());
        entry.setProperty(26, style.getTextTransform());
        entry.setProperty(27, style.getDirection());
        entry.setProperty(28, style.getWhiteSpace());
        return entry;
    }

    public static StyleEntry createEmptyStyleEntry() {
        StyleEntry entry = new StyleEntry();
        int i = 0;
        while (i < 29) {
            entry.setProperty(i, "NULL");
            ++i;
        }
        return entry;
    }

    public static String convertColor(String value) {
        if (value == null || "transparent".equalsIgnoreCase(value)) {
            return "NULL";
        }
        Matcher m = colorp.matcher(value = ExcelUtil.getValue(value));
        if (m.matches()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("#");
            int i = 2;
            while (i <= 4) {
                String hex = Integer.toHexString(Integer.parseInt(ExcelUtil.getValue(m.group(i)).trim()));
                if (hex.length() < 2) {
                    buffer.append(0);
                }
                buffer.append(hex);
                ++i;
            }
            return buffer.toString();
        }
        return "NULL";
    }

    public static String convertFontSize(String size) {
        String fsize = "NULL";
        try {
            fsize = Float.toString(Math.round(Float.parseFloat(size) / 1000.0f));
        }
        catch (NumberFormatException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return fsize;
    }

    public static String convertBorderWeight(String linestyle) {
        String w = "NULL";
        if (linestyle != null && !"0".equalsIgnoreCase(linestyle)) {
            int weight = (int)Double.parseDouble(linestyle = ExcelUtil.getValue(linestyle));
            w = weight >= 749 && weight < 1499 ? "1" : (weight >= 1499 && weight < 2249 ? "2" : (weight >= 2249 ? "3" : "2"));
        }
        return w;
    }

    public static String convertBorderStyle(String style) {
        String bs = ExcelUtil.getValue(style);
        if (!StyleEntry.isNull(bs)) {
            bs = "dotted".equalsIgnoreCase(bs) ? "Dot" : ("dashed".equalsIgnoreCase(bs) ? "DashDot" : ("double".equalsIgnoreCase(bs) ? "Double" : "Continuous"));
        }
        return bs;
    }

    public static String convertHAlign(String align, String direction) {
        String ha = null;
        ha = "left".equalsIgnoreCase(align = ExcelUtil.getValue(align)) ? "Left" : ("right".equalsIgnoreCase(align) ? "Right" : ("center".equalsIgnoreCase(align) ? "Center" : ("rtl".equalsIgnoreCase(direction) ? "Right" : "Left")));
        return ha;
    }

    public static String convertVAlign(String align) {
        String va = "Top";
        if ("bottom".equalsIgnoreCase(align = ExcelUtil.getValue(align))) {
            va = "Bottom";
        } else if ("middle".equalsIgnoreCase(align)) {
            va = "Center";
        }
        return va;
    }

    public static boolean isHeritable(int id) {
        return id < 10 || id > 21;
    }

    public static void mergeInheritableProp(StyleEntry cEntry, StyleEntry entry) {
        int i = 0;
        while (i < 29) {
            if (StyleBuilder.isHeritable(i) && StyleEntry.isNull(entry.getProperty(i))) {
                entry.setProperty(i, cEntry.getProperty(i));
            }
            ++i;
        }
    }

    public static void applyRightBorder(StyleEntry cEntry, StyleEntry entry) {
        StyleBuilder.overwriteProp(cEntry, entry, 19);
        StyleBuilder.overwriteProp(cEntry, entry, 20);
        StyleBuilder.overwriteProp(cEntry, entry, 21);
    }

    public static void applyLeftBorder(StyleEntry cEntry, StyleEntry entry) {
        StyleBuilder.overwriteProp(cEntry, entry, 16);
        StyleBuilder.overwriteProp(cEntry, entry, 17);
        StyleBuilder.overwriteProp(cEntry, entry, 18);
    }

    public static void applyTopBorder(StyleEntry cEntry, StyleEntry entry) {
        StyleBuilder.overwriteProp(cEntry, entry, 13);
        StyleBuilder.overwriteProp(cEntry, entry, 14);
        StyleBuilder.overwriteProp(cEntry, entry, 15);
    }

    public static void applyBottomBorder(StyleEntry cEntry, StyleEntry entry) {
        StyleBuilder.overwriteProp(cEntry, entry, 10);
        StyleBuilder.overwriteProp(cEntry, entry, 11);
        StyleBuilder.overwriteProp(cEntry, entry, 12);
    }

    private static void overwriteProp(StyleEntry cEntry, StyleEntry entry, int id) {
        if (StyleEntry.isNull(entry.getProperty(id))) {
            entry.setProperty(id, cEntry.getProperty(id));
        }
    }
}

