/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.excel.layout;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.emitter.excel.ExcelUtil;
import org.eclipse.birt.report.engine.emitter.excel.layout.DefaultTableInfo;
import org.eclipse.birt.report.engine.emitter.excel.layout.TableInfo;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class LayoutUtil {
    public static TableInfo createTable(int col, int width) {
        return new DefaultTableInfo(col, width);
    }

    public static TableInfo createTable(IListContent list, int width) {
        width = LayoutUtil.getElementWidth((IContent)list, width);
        int[] column = new int[]{width};
        return new DefaultTableInfo(column);
    }

    private static int getElementWidth(IContent content, int width) {
        DimensionType value = content.getWidth();
        if (value != null) {
            try {
                width = Math.min(ExcelUtil.covertDimensionType(value, width), width);
            }
            catch (Exception exception) {}
        }
        return width;
    }

    public static TableInfo createTable(ITableContent table, int width) {
        int tableWidth = LayoutUtil.getElementWidth((IContent)table, width);
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return null;
        }
        int[] columns = new int[columnCount];
        int unassignedCount = 0;
        int totalAssigned = 0;
        int i = 0;
        while (i < columnCount) {
            DimensionType value = table.getColumn(i).getWidth();
            if (value == null) {
                columns[i] = -1;
                ++unassignedCount;
            } else {
                columns[i] = ExcelUtil.covertDimensionType(value, tableWidth);
                totalAssigned += columns[i];
            }
            ++i;
        }
        int leftWidth = tableWidth - totalAssigned;
        if (leftWidth != 0 && unassignedCount == 0) {
            int i2 = 0;
            while (i2 < columnCount) {
                columns[i2] = LayoutUtil.resize(columns[i2], totalAssigned, leftWidth);
                ++i2;
            }
        } else if (leftWidth < 0 && unassignedCount > 0) {
            int i3 = 0;
            while (i3 < columnCount) {
                if (columns[i3] == -1) {
                    columns[1] = 0;
                } else {
                    columns[i3] = LayoutUtil.resize(columns[i3], totalAssigned, leftWidth);
                }
                ++i3;
            }
        } else if (leftWidth >= 0 && unassignedCount > 0) {
            int per = leftWidth / unassignedCount;
            int index = 0;
            int i4 = 0;
            while (i4 < columns.length) {
                if (columns[i4] == -1) {
                    columns[i4] = per;
                    index = i4;
                }
                ++i4;
            }
            columns[index] = leftWidth - per * (unassignedCount - 1);
        }
        return new DefaultTableInfo(columns);
    }

    private static int resize(int width, int total, int left) {
        return (int)((float)width + (float)width / (float)total * (float)left);
    }
}

