/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.MemberIterator;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.ValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.PropertyNameException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.command.ComplexPropertyCommand;
import org.eclipse.birt.report.model.core.MemberRef;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StructureContext;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class StructureHandle
extends ValueHandle {
    protected StructureContext structContext;

    public StructureHandle(DesignElementHandle element, StructureContext context) {
        super(element);
        this.structContext = context;
        this.checkValidation();
    }

    public StructureHandle(DesignElementHandle element, MemberRef ref) {
        super(element);
        if (ref == null) {
            throw new IllegalArgumentException("The member reference can not be null when creating the structure handle.");
        }
        this.structContext = ref.getContext();
        this.checkValidation();
    }

    public StructureHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle.getElementHandle());
        StructureContext context = valueHandle.getContext();
        assert (context.isListRef());
        assert (context.getPropDefn().getTypeCode() == 16);
        Object value = context.getValue(valueHandle.getModule());
        if (value instanceof Structure) {
            assert (index == 0);
            this.structContext = ((Structure)value).getContext();
        } else if (value instanceof List) {
            List valueList = (List)value;
            assert (index >= 0 && index < valueList.size());
            Object item = valueList.get(index);
            assert (item instanceof Structure);
            this.structContext = ((Structure)item).getContext();
        } else assert (false);
        this.checkValidation();
    }

    private void checkValidation() {
        if (this.structContext == null) {
            throw new IllegalArgumentException("The context can not be null when creating a structure handle!");
        }
        assert (this.structContext.getStructure() != null);
    }

    public IElementPropertyDefn getPropertyDefn() {
        return this.structContext.getElementProp();
    }

    public IStructure getStructure() {
        Structure struct = this.structContext.getStructure();
        if (struct.getContext() == null) {
            return null;
        }
        return struct;
    }

    public Object getProperty(String memberName) {
        MemberHandle handle = this.getMember(memberName);
        if (handle == null) {
            return null;
        }
        return handle.getValue();
    }

    protected String getStringProperty(String memberName) {
        MemberHandle handle = this.getMember(memberName);
        if (handle == null) {
            return null;
        }
        return handle.getStringValue();
    }

    public void setProperty(String memberName, Object value) throws SemanticException {
        MemberHandle memberHandle = this.getMember(memberName);
        if (memberHandle == null) {
            throw new PropertyNameException(this.getElement(), this.getStructure(), memberName);
        }
        memberHandle.setValue(value);
    }

    protected final void setPropertySilently(String memberName, Object value) {
        block2: {
            try {
                this.setProperty(memberName, value);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public IStructureDefn getDefn() {
        return this.structContext.getStructDefn();
    }

    public MemberHandle getMember(String memberName) {
        StructPropertyDefn memberDefn = (StructPropertyDefn)this.getDefn().getMember(memberName);
        if (memberDefn == null) {
            return null;
        }
        return new MemberHandle(this, memberDefn);
    }

    public Iterator iterator() {
        return new MemberIterator(this);
    }

    public StructureContext getContext() {
        return this.structContext;
    }

    public void drop() throws PropertyValueException {
        Structure struct = (Structure)this.getStructure();
        ComplexPropertyCommand cmd = new ComplexPropertyCommand(this.getModule(), this.getElement());
        cmd.removeItem(struct.getContext(), struct);
    }

    public String getExternalizedValue(String textIDProp, String textProp) {
        return ModelUtil.getExternalizedStructValue(this.getElement().getRoot(), this.getStructure(), textIDProp, textProp, ThreadResources.getLocale());
    }

    public boolean isDesignTime() {
        return this.getStructure().isDesignTime();
    }

    public void setDesignTime(boolean isDesignTime) throws SemanticException {
        MemberHandle memberHandle = this.getMember("isDesignTime");
        if (memberHandle != null) {
            memberHandle.setValue(isDesignTime);
        }
    }

    public void setExpressionProperty(String memberName, Expression value) throws SemanticException {
        this.setProperty(memberName, value);
    }

    public ExpressionHandle getExpressionProperty(String memberName) {
        PropertyDefn defn = (PropertyDefn)this.getDefn().getMember(memberName);
        if (defn == null) {
            return null;
        }
        if (defn.allowExpression() && !defn.isListType()) {
            return new ExpressionHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
        }
        return null;
    }
}

