/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroupBand;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;

public class LayoutUtil {
    protected static int getRowCount(LayoutTable table) {
        int rowCount = 0;
        LayoutSlot slot = table.getHeader();
        rowCount += slot.getRowCount();
        slot = table.getDetail();
        rowCount += slot.getRowCount();
        slot = table.getFooter();
        rowCount += slot.getRowCount();
        LayoutGroupBand groupSlot = table.getGroupHeaders();
        int i = 0;
        while (i < groupSlot.getGroupCount()) {
            slot = groupSlot.getLayoutSlot(i);
            rowCount += slot.getRowCount();
            ++i;
        }
        groupSlot = table.getGroupFooters();
        i = 0;
        while (i < groupSlot.getGroupCount()) {
            slot = groupSlot.getLayoutSlot(i);
            rowCount += slot.getRowCount();
            ++i;
        }
        return rowCount;
    }

    protected static List getFlattenedLayoutSlots(LayoutTable table) {
        ArrayList<LayoutSlot> list = new ArrayList<LayoutSlot>();
        list.add(table.getHeader());
        LayoutGroupBand band = table.getGroupHeaders();
        int i = 0;
        while (i < band.getGroupCount()) {
            list.add(band.getLayoutSlot(i));
            ++i;
        }
        list.add(table.getDetail());
        band = table.getGroupFooters();
        i = 0;
        while (i < band.getGroupCount()) {
            list.add(band.getLayoutSlot(i));
            ++i;
        }
        list.add(table.getFooter());
        return list;
    }

    private static LayoutSlot getLayoutSlotOfCell(CellHandle cell) {
        ReportItem compoundElement = LayoutUtil.getCompoundContainer(cell.getElement());
        if (!(compoundElement instanceof TableItem)) {
            return null;
        }
        TableItem table = (TableItem)compoundElement;
        LayoutTable layoutTable = table.getLayoutModel(cell.getModule());
        LayoutSlot layoutSlot = null;
        DesignElementHandle grandPa = cell.getContainer().getContainer();
        int groupLevel = 0;
        int slotId = cell.getContainer().getContainerSlotHandle().getSlotID();
        if (grandPa instanceof TableHandle) {
            layoutSlot = layoutTable.getLayoutSlot(slotId);
        } else {
            groupLevel = ((TableGroup)grandPa.getElement()).getGroupLevel();
            layoutSlot = layoutTable.getLayoutSlot(groupLevel, slotId);
        }
        return layoutSlot;
    }

    public static int getEffectiveColumnSpan(CellHandle cell) {
        LayoutSlot layoutSlot = LayoutUtil.getLayoutSlotOfCell(cell);
        if (layoutSlot == null) {
            return cell.getColumnSpan();
        }
        int rowId = cell.getContainer().getContainerSlotHandle().findPosn(cell.getContainer());
        LayoutRow layoutRow = layoutSlot.getLayoutRow(rowId);
        int columnPosn = layoutRow.findCellColumnPos((Cell)cell.getElement());
        if (columnPosn <= 0) {
            return 0;
        }
        int effectiveColumnSpan = 0;
        int i = columnPosn - 1;
        while (i < layoutRow.getColumnCount()) {
            LayoutCell layoutCell = layoutRow.getLayoutCell(i);
            if (layoutCell.getContent() != cell.getElement()) break;
            ++effectiveColumnSpan;
            ++i;
        }
        return effectiveColumnSpan;
    }

    public static int getEffectiveRowSpan(CellHandle cell) {
        LayoutSlot layoutSlot = LayoutUtil.getLayoutSlotOfCell(cell);
        if (layoutSlot == null) {
            return cell.getColumnSpan();
        }
        int rowId = cell.getContainer().getContainerSlotHandle().findPosn(cell.getContainer());
        int effectiveRowSpan = 0;
        int i = rowId;
        while (i < layoutSlot.getRowCount()) {
            LayoutRow layoutRow = layoutSlot.getLayoutRow(i);
            LayoutCell layoutCell = layoutRow.getLayoutCell(cell);
            if (layoutCell == null) break;
            if (layoutCell.isEffectualDrop()) {
                assert (layoutCell.isCellStartPosition());
                return layoutCell.getRowSpanForDrop();
            }
            ++effectiveRowSpan;
            ++i;
        }
        return effectiveRowSpan;
    }

    public static ReportItem getCompoundContainer(IDesignElement element) {
        DesignElement tmpElement = (DesignElement)element;
        int maxLevel = 3;
        int i = 0;
        while (i < maxLevel) {
            if (tmpElement == null || tmpElement instanceof TableItem || tmpElement instanceof GridItem) {
                return (ReportItem)tmpElement;
            }
            tmpElement = tmpElement.getContainer();
            ++i;
        }
        return null;
    }

    private static boolean checkColumnRepeat(Module module, DesignElement element) {
        assert (element instanceof TableItem || element instanceof GridItem);
        ContainerSlot slot = null;
        if (element instanceof TableItem) {
            slot = ((TableItem)element).getSlot(4);
        } else if (element instanceof GridItem) {
            slot = ((GridItem)element).getSlot(0);
        }
        for (TableColumn tableColumn : slot.getContents()) {
            int repeat = tableColumn.getIntProperty(module, "repeat");
            if (repeat <= 1) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidLayout(GridItem grid, Module module) {
        int columnCount = grid.getColumnCount(module);
        if (columnCount == 0) {
            return false;
        }
        return LayoutUtil.checkColumnRepeat(module, grid);
    }

    public static boolean isValidLayout(TableItem table, Module module) {
        LayoutTable layout = table.getLayoutModel(module);
        assert (layout != null);
        int columnCount = layout.getColumnCount();
        if (columnCount == 0) {
            return false;
        }
        if (!LayoutUtil.checkColumnRepeat(module, table)) {
            return false;
        }
        List slots = LayoutUtil.getFlattenedLayoutSlots(layout);
        int i = 0;
        while (i < slots.size()) {
            LayoutSlot slot = (LayoutSlot)slots.get(i);
            int j = 0;
            while (j < slot.getRowCount()) {
                LayoutRow row = slot.getLayoutRow(j);
                if (row != null && row.getOccupiedColumnCount() != columnCount) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

