/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThemeStyleNameValidator
extends AbstractElementValidator {
    private static ThemeStyleNameValidator instance = new ThemeStyleNameValidator();

    public static ThemeStyleNameValidator getInstance() {
        return instance;
    }

    private List<StyleHandle> getSameNameStyles(ThemeHandle themeHandle, String styleName) {
        SlotHandle slot = themeHandle.getSlot(0);
        Iterator iterator = slot.iterator();
        ArrayList<StyleHandle> sameNameList = new ArrayList<StyleHandle>();
        while (iterator.hasNext()) {
            StyleHandle style = (StyleHandle)iterator.next();
            if (!style.getName().equalsIgnoreCase(styleName)) continue;
            sameNameList.add(style);
        }
        return sameNameList;
    }

    public List<SemanticException> validateForAddingStyle(ThemeHandle theme, String styleName) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        if (this.getSameNameStyles(theme, styleName).size() > 1) {
            list.add(new NameException(theme.getElement(), styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }

    public List<SemanticException> validateForRenamingStyle(ThemeHandle theme, StyleHandle style, String styleName) {
        StyleHandle tempStyle;
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        List<StyleHandle> sameNameStyles = this.getSameNameStyles(theme, styleName);
        if (sameNameStyles.size() > 1) {
            list.add(new NameException(theme.getElement(), styleName, "Error.NameException.DUPLICATE"));
        } else if (sameNameStyles.size() == 1 && (tempStyle = sameNameStyles.get(0)) != style) {
            list.add(new NameException(theme.getElement(), styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof Theme)) {
            return Collections.emptyList();
        }
        Theme theme = (Theme)element;
        ContainerSlot slot = theme.getSlot(0);
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        HashSet<String> set = new HashSet<String>();
        Iterator<DesignElement> iter = slot.iterator();
        while (iter.hasNext()) {
            StyleElement style = (StyleElement)iter.next();
            String styleName = style.getFullName();
            if (!set.contains(styleName)) {
                set.add(style.getFullName());
                continue;
            }
            list.add(new NameException((DesignElement)theme, styleName, "Error.NameException.DUPLICATE"));
        }
        return list;
    }
}

