/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.TextualPropertyType;
import org.eclipse.birt.report.model.util.StyleUtil;

public class StringPropertyType
extends TextualPropertyType {
    private static final String DISPLAY_NAME_KEY = "Property.string";

    public StringPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        String stringValue = this.trimString(value.toString(), defn.getTrimOption());
        if ("fontFamily".equals(defn.getName())) {
            return StyleUtil.handleFontFamily(defn, stringValue);
        }
        return stringValue;
    }

    public int getTypeCode() {
        return 0;
    }

    public String getName() {
        return "string";
    }

    public double toDouble(Module module, Object value) {
        return 0.0;
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        try {
            return Integer.decode((String)value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

