/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.util.HTMLEmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public abstract class HTMLEmitter {
    protected HTMLReportEmitter reportEmitter;
    protected HTMLWriter writer;
    protected String layoutPreference;
    protected boolean enableInlineStyle = false;
    protected int browserVersion = -1;
    protected Stack containerDisplayStack = new Stack();

    public HTMLEmitter(HTMLReportEmitter reportEmitter, HTMLWriter writer, String layoutPreference, boolean enableInlineStyle, int browserVersion) {
        this.reportEmitter = reportEmitter;
        this.writer = writer;
        this.layoutPreference = layoutPreference;
        this.enableInlineStyle = enableInlineStyle;
        this.browserVersion = browserVersion;
    }

    public abstract void buildDefaultStyle(StringBuffer var1, IStyle var2);

    public abstract void buildStyle(StringBuffer var1, IStyle var2);

    public abstract void buildPageBandStyle(StringBuffer var1, IStyle var2);

    public abstract void buildTableStyle(ITableContent var1, StringBuffer var2);

    public abstract void buildColumnStyle(IColumn var1, StringBuffer var2);

    public abstract void handleColumnAlign(IColumn var1);

    public abstract void buildRowStyle(IRowContent var1, StringBuffer var2);

    public abstract void handleRowAlign(IRowContent var1);

    public abstract void buildCellStyle(ICellContent var1, StringBuffer var2, boolean var3);

    public abstract void handleCellAlign(ICellContent var1);

    public abstract void buildContainerStyle(IContainerContent var1, StringBuffer var2);

    public abstract void handleContainerAlign(IContainerContent var1);

    public abstract void buildTextStyle(ITextContent var1, StringBuffer var2, int var3);

    public abstract void buildForeignStyle(IForeignContent var1, StringBuffer var2, int var3);

    public abstract void buildImageStyle(IImageContent var1, StringBuffer var2, int var3);

    public void buildPageStyle(IPageContent page, StringBuffer styleBuffer, boolean needOutputBackgroundSize) {
        IStyle style = page.getStyle();
        if (!needOutputBackgroundSize) {
            AttributeBuilder.buildBackground(styleBuffer, style, this.reportEmitter);
        } else {
            AttributeBuilder.buildBackgroundColor(styleBuffer, style, this.reportEmitter);
        }
        AttributeBuilder.buildBorders(styleBuffer, style);
    }

    public void buildSize(StringBuffer content, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                content.append(" height: auto !important; height: ");
                content.append(value.toString());
                content.append("; min-height: ");
                content.append(value.toString());
                content.append(';');
            } else {
                content.append(' ');
                content.append(name);
                content.append(": ");
                content.append(value.toString());
                content.append(';');
            }
        }
    }

    protected IStyle getElementStyle(IContent content) {
        IStyle style = null;
        style = this.enableInlineStyle ? content.getStyle() : content.getInlineStyle();
        if (style == null || style.isEmpty()) {
            return null;
        }
        return style;
    }

    public CSSValue getElementDisplay(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        CSSValue display = null;
        if (style != null) {
            display = style.getProperty(51);
        }
        if (IStyle.NONE_VALUE == display) {
            return IStyle.NONE_VALUE;
        }
        if (x != null || y != null) {
            return IStyle.BLOCK_VALUE;
        }
        if (IStyle.INLINE_VALUE == display) {
            if (width != null || height != null) {
                return IStyle.INLINE_BLOCK_VALUE;
            }
            return IStyle.INLINE_VALUE;
        }
        return IStyle.BLOCK_VALUE;
    }

    public int getElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null || height != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    public int getTextElementType(DimensionType x, DimensionType y, DimensionType width, DimensionType height, IStyle style) {
        int type = 0;
        String display = null;
        if (style != null) {
            display = style.getDisplay();
        }
        if ("none".equalsIgnoreCase(display)) {
            type |= 8;
        }
        if (x != null || y != null) {
            return type | 1;
        }
        if ("inline".equalsIgnoreCase(display)) {
            type |= 2;
            if (width != null) {
                type |= 4;
            }
            return type;
        }
        return type | 1;
    }

    protected void addDefaultTableStyles(StringBuffer styleBuffer) {
        styleBuffer.append("border-collapse: collapse; empty-cells: show;");
    }

    protected boolean handleShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink;
        boolean bl = canShrink = style != null && "true".equalsIgnoreCase(style.getCanShrink());
        if ((type & 1) > 0) {
            this.buildSize(styleBuffer, "width", width);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            this.buildSize(styleBuffer, "height", height);
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-width", width);
            }
        } else assert (false);
        return canShrink;
    }

    protected boolean handleTextShrink(int type, IStyle style, DimensionType height, DimensionType width, StringBuffer styleBuffer) {
        boolean canShrink;
        boolean bl = canShrink = style != null && "true".equalsIgnoreCase(style.getCanShrink());
        if ((type & 1) > 0) {
            if (width != null) {
                this.buildSize(styleBuffer, "width", width);
                styleBuffer.append(" overflow: hidden;");
            }
            if (!canShrink) {
                this.buildSize(styleBuffer, "min-height", height);
            }
        } else if ((type & 2) > 0) {
            if ((type & 4) > 0) {
                this.buildSize(styleBuffer, "height", height);
            }
            if (!canShrink && width != null) {
                this.buildSize(styleBuffer, "width", width);
                styleBuffer.append(" overflow: hidden;");
            }
        } else assert (false);
        return canShrink;
    }

    public void openContainerTag(IContainerContent container) {
        DimensionType x = container.getX();
        DimensionType y = container.getY();
        DimensionType width = container.getWidth();
        DimensionType height = container.getHeight();
        int display = this.getElementType(x, y, width, height, container.getStyle());
        this.containerDisplayStack.push(new Integer(display));
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.openInlineBoxTag();
        }
        this.writer.openTag("div");
    }

    public void closeContainerTag() {
        this.writer.closeTag("div");
        int display = (Integer)this.containerDisplayStack.pop();
        if ((display & 2) > 0 || (display & 4) > 0) {
            this.closeInlineBoxTag();
        }
    }

    protected void openInlineBoxTag() {
        this.writer.openTag("div");
        if (this.browserVersion == HTMLEmitterUtil.BROWSER_IE7) {
            this.writer.attribute("style", " display:-moz-inline-box !important; display:inline;");
        } else {
            this.writer.attribute("style", " display:-moz-inline-box !important; display:inline-block !important; display:inline;");
        }
        this.writer.openTag("table");
        this.writer.attribute("style", " display:table !important; display:inline;");
        this.writer.openTag("tr");
        this.writer.openTag("td");
    }

    protected void closeInlineBoxTag() {
        this.writer.closeTag("td");
        this.writer.closeTag("tr");
        this.writer.closeTag("table");
        this.writer.closeTag("div");
    }

    protected void setDisplayProperty(int display, int mask, StringBuffer styleBuffer) {
        int flag = display & mask;
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if (flag > 0) {
            if ((flag & 1) > 0) {
                styleBuffer.append("display: block;");
            } else if ((flag & 4) > 0) {
                styleBuffer.append("display: inline-block;");
            } else if ((flag & 2) > 0) {
                styleBuffer.append("display: inline;");
            }
        }
    }

    public void handleVerticalAlignBegin(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(49);
        CSSValue canShrink = style.getProperty(17);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null && canShrink != IStyle.TRUE_VALUE) {
            this.writer.openTag("table");
            StringBuffer nestingTableStyleBuffer = new StringBuffer();
            nestingTableStyleBuffer.append(" width:100%; height:");
            nestingTableStyleBuffer.append(height.toString());
            this.writer.attribute("style", nestingTableStyleBuffer.toString());
            this.writer.openTag("tr");
            this.writer.openTag("td");
            StringBuffer textStyleBuffer = new StringBuffer();
            textStyleBuffer.append(" vertical-align:");
            textStyleBuffer.append(vAlign.getCssText());
            textStyleBuffer.append(";");
            this.writer.attribute("style", textStyleBuffer.toString());
        }
    }

    public void handleVerticalAlignEnd(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(49);
        CSSValue canShrink = style.getProperty(17);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null && canShrink != IStyle.TRUE_VALUE) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }
}

