/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.DBConfig;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class Statement
implements IQuery {
    protected PreparedStatement preStat;
    protected Connection conn;
    protected int maxrows;
    protected boolean maxRowsUpToDate = false;
    private static final String ERRMSG_SET_PARAMETER = "Error setting value for SQL parameter #";
    private static Logger logger = Logger.getLogger(Statement.class.getName());
    private IResultSetMetaData cachedResultMetaData;
    private IResultSet cachedResultSet;
    private static DBConfig config = new DBConfig();

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.StatementCannotNull", 117);
        }
    }

    public Statement(Connection connection) throws OdaException {
        if (connection == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
        this.preStat = null;
        this.conn = connection;
        this.maxrows = -1;
    }

    public void prepare(String command) throws OdaException {
        logger.logp(Level.FINE, Statement.class.getName(), "prepare", "Statement.prepare( \"" + command + "\" )");
        try {
            if (command == null) {
                logger.logp(Level.FINE, Statement.class.getName(), "prepare", "Query text can not be null.");
                throw new OdaException("Query text can not be null.");
            }
            this.cachedResultMetaData = null;
            this.cachedResultSet = null;
            this.preStat = this.conn.prepareStatement(command);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.StatementCannotPrepared", e);
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void setProperty(String name, String value) throws OdaException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.equals("queryTimeOut")) {
            if (value != null && value.length() > 0) {
                try {
                    double secs = Double.parseDouble(value);
                    this.preStat.setQueryTimeout((int)secs);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, "Statement.setQueryTimeout failed", e);
                }
            }
        } else if (!(name.equals("OdaConnProfileName") || name.equals("OdaConnProfileStore") || name.equals("OdaConnProfileStorePath"))) {
            OdaException e = new OdaException("Unsupported query property: " + name);
            this.addLog("setProperty", (Exception)((Object)e));
            throw e;
        }
    }

    public void close() throws OdaException {
        logger.logp(Level.FINE, Statement.class.getName(), "close", "Statement.close( )");
        try {
            if (this.preStat != null) {
                this.preStat.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotClosePreparedStatement", e);
        }
        this.cachedResultMetaData = null;
        this.cachedResultSet = null;
    }

    public void setMaxRows(int max) {
        logger.logp(Level.FINE, Statement.class.getName(), "setMaxRows", "Statement.setMaxRows( " + max + " )");
        if (max != this.maxrows && max >= 0) {
            this.maxrows = max;
            this.maxRowsUpToDate = false;
        }
    }

    public int getMaxRows() {
        logger.logp(Level.FINE, Statement.class.getName(), "getMaxRows", "Statement.getMaxRows( )");
        return this.maxrows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        logger.logp(Level.FINE, Statement.class.getName(), "getMetaData", "Statement.getMetaData( )");
        this.assertNotNull(this.preStat);
        if (this.cachedResultMetaData != null) {
            return this.cachedResultMetaData;
        }
        int policy = -1;
        try {
            policy = config.getPolicy(this.preStat.getConnection().getMetaData().getDriverName());
        }
        catch (SQLException sQLException) {}
        switch (policy) {
            case 0: {
                this.getMetaUsingPolicy0();
                break;
            }
            case 1: {
                this.getMetaUsingPolicy1();
                break;
            }
            case 2: {
                this.getMetaUsingPolicy2();
            }
        }
        if (this.cachedResultMetaData == null) {
            this.getMetaUsingDefaultPolicy();
        }
        return this.cachedResultMetaData;
    }

    private void getMetaUsingDefaultPolicy() throws OdaException {
        java.sql.ResultSetMetaData resultmd;
        try {
            resultmd = this.preStat.getMetaData();
        }
        catch (Throwable throwable) {
            resultmd = null;
        }
        if (resultmd != null) {
            try {
                resultmd.getColumnCount();
                if (resultmd.getColumnCount() <= 0) {
                    resultmd = null;
                }
            }
            catch (SQLException sQLException) {
                resultmd = null;
            }
            if (resultmd != null) {
                this.cachedResultMetaData = new ResultSetMetaData(resultmd);
            }
        }
        if (this.cachedResultMetaData == null) {
            this.cachedResultSet = this.executeQuery();
            if (this.cachedResultSet != null) {
                this.cachedResultMetaData = this.cachedResultSet.getMetaData();
            }
        }
    }

    private void getMetaUsingPolicy0() {
        try {
            java.sql.ResultSetMetaData resultmd = this.preStat.getMetaData();
            if (resultmd != null && resultmd.getColumnCount() > 0) {
                this.cachedResultMetaData = new ResultSetMetaData(resultmd);
            }
        }
        catch (Throwable throwable) {}
    }

    private void getMetaUsingPolicy1() throws OdaException {
        this.cachedResultSet = this.executeQuery();
        if (this.cachedResultSet != null) {
            this.cachedResultMetaData = this.cachedResultSet.getMetaData();
        }
    }

    private void getMetaUsingPolicy2() {
        try {
            int max = this.preStat.getMaxRows();
            this.preStat.setMaxRows(1);
            this.preStat.execute();
            this.getMetaUsingPolicy0();
            this.preStat.setMaxRows(max);
        }
        catch (SQLException sQLException) {}
    }

    public IResultSet executeQuery() throws OdaException {
        logger.logp(Level.FINE, Statement.class.getName(), "executeQuery", "Statement.executeQuery( )");
        this.assertNotNull(this.preStat);
        if (this.cachedResultSet != null) {
            IResultSet ret = this.cachedResultSet;
            this.cachedResultSet = null;
            return ret;
        }
        try {
            if (this.maxrows >= 0 && !this.maxRowsUpToDate) {
                try {
                    this.preStat.setMaxRows(this.maxrows);
                }
                catch (SQLException sQLException) {}
                this.maxRowsUpToDate = true;
            }
            return new ResultSet(this.preStat.executeQuery());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotReturn", e);
        }
    }

    public boolean execute() throws OdaException {
        logger.logp(Level.FINE, Statement.class.getName(), "execute", "Statement.execute( )");
        this.assertNotNull(this.preStat);
        try {
            if (this.maxrows >= 0 && !this.maxRowsUpToDate) {
                this.preStat.setMaxRows(this.maxrows);
                this.maxRowsUpToDate = true;
            }
            return this.preStat.execute();
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    public void cancel() throws OdaException {
        try {
            if (this.preStat != null) {
                this.preStat.cancel();
            }
        }
        catch (SQLException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public void setInt(String parameterName, int value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setInt", e);
        throw e;
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setInt(parameterId, value);
            this.addLog("setInt", parameterId, String.valueOf(value));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setDouble", e);
        throw e;
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setDouble(parameterId, value);
            this.addLog("setDouble", parameterId, String.valueOf(value));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setBigDecimal", e);
        throw e;
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setBigDecimal(parameterId, value);
            this.addLog("setBigDecimal", parameterId, String.valueOf(value));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setString(String parameterName, String value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setString", e);
        throw e;
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setString(parameterId, value);
            this.addLog("setString", parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setDate", e);
        throw e;
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setDate(parameterId, value);
            this.addLog("setDate", parameterId, value.toString());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setBoolean", e);
        throw e;
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setBoolean(parameterId, value);
            this.addLog("setBoolean", parameterId, String.valueOf(value));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setTime", e);
        throw e;
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setTime(parameterId, value);
            this.addLog("setTime", parameterId, value.toString());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setTimestamp", e);
        throw e;
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.setTimestamp(parameterId, value);
            this.addLog("setTimestamp", parameterId, String.valueOf(value));
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            Statement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setObject", e);
        throw e;
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("setNull", e);
        throw e;
    }

    public void setNull(int parameterId) throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            java.sql.ParameterMetaData pm = this.preStat.getParameterMetaData();
            if (pm == null) {
                this.preStat.setNull(parameterId, 1111);
                this.addLog("setNull", parameterId, "null");
            } else {
                this.preStat.setNull(parameterId, pm.getParameterType(parameterId));
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetNullValue", e);
        }
    }

    public int findInParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        this.addLog("findInParameter", e);
        throw e;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            return new ParameterMetaData(this.preStat.getParameterMetaData());
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetParameterMetadata", e);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        this.addLog("setSortSpec", e);
        throw e;
    }

    public SortSpec getSortSpec() throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        logger.logp(Level.FINE, Statement.class.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSpecification is not supported.");
        this.addLog("setSpecification", e);
        throw e;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        return null;
    }

    public void clearInParameters() throws OdaException {
        this.assertNotNull(this.preStat);
        try {
            this.preStat.clearParameters();
        }
        catch (SQLException ex) {
            throw new JDBCException("odajdbc.ClearParametersError", ex);
        }
    }

    private static void rethrowRunTimeException(RuntimeException e, String msg) throws OdaException {
        OdaException odaException = new OdaException(msg);
        odaException.initCause((Throwable)e);
        logger.logp(Level.FINE, Statement.class.getName(), "rethrowRunTimeException", msg, odaException);
        throw odaException;
    }

    private void addLog(String methodName, int parameterId, String value) {
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, Statement.class.getName(), methodName, "parameter " + parameterId + " = " + value);
        }
    }

    private void addLog(String methodName, Exception e) {
        logger.logp(Level.FINE, Statement.class.getName(), methodName, "No named Parameter supported.", e);
    }
}

