/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml;

import java.awt.Toolkit;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.ir.DimensionType;

public class WordUtil {
    private static final String LINESTYLE_SOLID = "solid";
    private static final String LINESTYLE_DASH = "dash";
    private static final String LINESTYLE_DOT = "dot";
    private static final String LINESTYLE_SINGLE = "single";
    private static Logger logger = Logger.getLogger(WordUtil.class.getName());
    private static HashSet<Character> splitChar = new HashSet();
    private static double Temp_PX;
    public static final double INCH_PX;
    public static final double INCH_PT = 72.0;
    public static final double PT_TWIPS = 20.0;
    public static final double INCH_TWIPS = 1440.0;
    public static final double PX_TWIPS;
    public static final double PX_PT;

    static {
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\r'));
        splitChar.add(new Character('\n'));
        try {
            Temp_PX = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception exception) {
            Temp_PX = 96.0;
        }
        INCH_PX = Temp_PX;
        PX_TWIPS = 1440.0 / INCH_PX;
        PX_PT = 72.0 / INCH_PX;
    }

    public static String validBookmarkName(String name) {
        String bookmark = name.replaceAll(" ", "_");
        bookmark = bookmark.replaceAll("\"", "_");
        return bookmark;
    }

    public static int convertTo(DimensionType value, int prefValue) {
        if (value == null) {
            return prefValue;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return (int)((double)prefValue * value.getMeasure() / 100.0);
        }
        return (int)WordUtil.convertTo(value);
    }

    public static double convertTo(DimensionType value) {
        if (value == null || "%".equalsIgnoreCase(value.getUnits())) {
            return -1.0;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_TWIPS;
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * 12.0 * 20.0;
        }
        double val = value.convertTo("in");
        return val * 1440.0;
    }

    public static double convertImageSize(DimensionType value, int ref) {
        if (value == null) {
            return (double)ref * PX_PT;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * PX_PT;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / 100.0 * (double)ref * PX_PT;
        }
        return value.convertTo("in") * 72.0;
    }

    public static double twipToPt(double t) {
        return t / 20.0;
    }

    public static int parseSpacing(float floatValue) {
        return (int)((double)Math.round(floatValue / 1000.0f) * 20.0);
    }

    public static int parseFontSize(float value) {
        return Math.round(value / 500.0f);
    }

    public static String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = new Character(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    public static String parseColor(String color) {
        if ("transparent".equalsIgnoreCase(color) || color == null || color.length() == 0) {
            return null;
        }
        if (color.startsWith("#")) {
            return color.substring(1, Math.min(color.length(), 7));
        }
        if (color.equalsIgnoreCase("Black")) {
            return "000000";
        }
        if (color.equalsIgnoreCase("Gray")) {
            return "121212";
        }
        if (color.equalsIgnoreCase("White")) {
            return "ffffff";
        }
        if (color.equalsIgnoreCase("Red")) {
            return "ff0000";
        }
        if (color.equalsIgnoreCase("Green")) {
            return "00ff00";
        }
        if (color.equalsIgnoreCase("Yellow")) {
            return "ffff00";
        }
        if (color.equalsIgnoreCase("Blue")) {
            return "0000ff";
        }
        if (color.equalsIgnoreCase("Teal")) {
            return "008080";
        }
        if (color.equalsIgnoreCase("Aqua")) {
            return "00FFFF";
        }
        if (color.equalsIgnoreCase("Silver")) {
            return "C0C0C0";
        }
        if (color.equalsIgnoreCase("Navy")) {
            return "000080";
        }
        if (color.equalsIgnoreCase("Lime")) {
            return "00FF00";
        }
        if (color.equalsIgnoreCase("Olive")) {
            return "808000";
        }
        if (color.equalsIgnoreCase("Purple")) {
            return "800080";
        }
        if (color.equalsIgnoreCase("Fuchsia")) {
            return "FF00FF";
        }
        if (color.equalsIgnoreCase("Maroon")) {
            return "800000";
        }
        String[] values = color.substring(color.indexOf("(") + 1, color.length() - 1).split(",");
        String value = "";
        int i = 0;
        while (i < values.length) {
            try {
                String s = Integer.toHexString(Integer.parseInt(values[i].trim()));
                if (s.length() == 1) {
                    s = "0" + s;
                }
                value = String.valueOf(value) + s;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                value = null;
            }
            ++i;
        }
        return value;
    }

    public static String parseBorderStyle(String style) {
        if (LINESTYLE_SOLID.equalsIgnoreCase(style)) {
            return LINESTYLE_SINGLE;
        }
        return style;
    }

    public static String parseImageBorderStyle(String style) {
        if ("dotted".equalsIgnoreCase(style)) {
            return LINESTYLE_DOT;
        }
        if ("dashed".equalsIgnoreCase(style)) {
            return LINESTYLE_DASH;
        }
        if (LINESTYLE_SOLID.equalsIgnoreCase(style)) {
            return LINESTYLE_SINGLE;
        }
        return style;
    }

    public static String parseVerticalAlign(String align) {
        if ("middle".equals(align)) {
            return "center";
        }
        return align;
    }

    public static String removeQuote(String val) {
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int parseBorderSize(float size) {
        int w = Math.round(size);
        return 8 * w / 750;
    }

    public static String parseLineStyle(String style) {
        if ("dotted".equalsIgnoreCase(style)) {
            return LINESTYLE_DOT;
        }
        if ("dashed".equalsIgnoreCase(style)) {
            return LINESTYLE_DASH;
        }
        if ("double".equalsIgnoreCase(style)) {
            return LINESTYLE_SOLID;
        }
        return style;
    }

    public static String[] parseBackgroundSize(String height, String width, int imageWidth, int imageHeight, double pageWidth, double pageHeight) {
        String actualHeight = height;
        String actualWidth = width;
        if (height == null || "auto".equalsIgnoreCase(height)) {
            actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
        }
        if (width == null || "auto".equalsIgnoreCase(width)) {
            actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
        }
        actualHeight = actualHeight.trim();
        if ("contain".equalsIgnoreCase(actualWidth = actualWidth.trim()) || "contain".equalsIgnoreCase(actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
                actualWidth = String.valueOf(String.valueOf((double)imageWidth * pageHeight / (double)imageHeight)) + "pt";
            } else {
                actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
                actualHeight = String.valueOf(String.valueOf((double)imageHeight * pageWidth / (double)imageWidth)) + "pt";
            }
        } else if ("cover".equals(actualWidth) || "cover".equals(actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualWidth = String.valueOf(String.valueOf(pageWidth)) + "pt";
                actualHeight = String.valueOf(String.valueOf((double)imageHeight * pageWidth / (double)imageWidth)) + "pt";
            } else {
                actualHeight = String.valueOf(String.valueOf(pageHeight)) + "pt";
                actualWidth = String.valueOf(String.valueOf((double)imageWidth * pageHeight / (double)imageHeight)) + "pt";
            }
        }
        if (height != null && height.endsWith("%")) {
            actualHeight = String.valueOf(WordUtil.getPercentValue(height, pageHeight)) + "pt";
        }
        if (width != null && width.endsWith("%")) {
            actualWidth = String.valueOf(WordUtil.getPercentValue(width, pageWidth)) + "pt";
        }
        return new String[]{actualHeight, actualWidth};
    }

    private static String getPercentValue(String height, double pageHeight) {
        String value = null;
        try {
            String percent = height.substring(0, height.length() - 1);
            int percentValue = Integer.valueOf(percent);
            value = String.valueOf(pageHeight * (double)percentValue / 100.0);
        }
        catch (NumberFormatException numberFormatException) {
            value = height;
        }
        return value;
    }

    public static boolean isField(int autoTextType) {
        return autoTextType == 1 || autoTextType == 0;
    }

    public static boolean isField(IContent content) {
        if (content.getContentType() == 12) {
            IAutoTextContent autoText = (IAutoTextContent)content;
            int type = autoText.getType();
            return WordUtil.isField(type);
        }
        return false;
    }
}

