/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.wpml.writer;

import java.io.OutputStream;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.XMLWriter;
import org.eclipse.birt.report.engine.emitter.wpml.AbstractEmitterImpl;
import org.eclipse.birt.report.engine.emitter.wpml.HyperlinkInfo;
import org.eclipse.birt.report.engine.emitter.wpml.IWordWriter;
import org.eclipse.birt.report.engine.emitter.wpml.SpanInfo;
import org.eclipse.birt.report.engine.emitter.wpml.WordUtil;
import org.eclipse.birt.report.engine.emitter.wpml.writer.AbstractWordXmlWriter;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.w3c.dom.css.CSSValue;

public class DocWriter
extends AbstractWordXmlWriter
implements IWordWriter {
    public DocWriter(OutputStream out) {
        this(out, "UTF-8");
    }

    public DocWriter(OutputStream out, String encoding) {
        this.writer = new XMLWriter();
        this.writer.open(out, encoding);
    }

    public void start(boolean rtl, String creator, String title, String description) {
        this.rtl = rtl;
        this.writer.startWriter();
        this.writer.literal("\n");
        this.writer.literal("<?mso-application progid=\"Word.Document\"?>");
        this.writer.literal("\n");
        this.writer.openTag("w:wordDocument");
        this.writer.attribute("xmlns:w", "http://schemas.microsoft.com/office/word/2003/wordml");
        this.writer.attribute("xmlns:v", "urn:schemas-microsoft-com:vml");
        this.writer.attribute("xmlns:w10", "urn:schemas-microsoft-com:office:word");
        this.writer.attribute("xmlns:o", "urn:schemas-microsoft-com:office:office");
        this.writer.attribute("xmlns:dt", "uuid:C2F41010-65B3-11d1-A29F-00AA00C14882");
        this.writer.attribute("xmlns:wx", "http://schemas.microsoft.com/office/word/2003/auxHint");
        this.writer.attribute("xmlns:aml", "http://schemas.microsoft.com/aml/2001/core");
        this.writer.attribute("xml:space", "preserve");
        this.writeCoreProperties(creator, title, description);
        this.writer.openTag("w:styles");
        this.writer.openTag("w:style");
        this.writer.attribute("w:type", "paragraph");
        this.writer.attribute(" w:styleId", 4);
        this.writer.openTag("w:name");
        this.writer.attribute("w:val", "toc 4");
        this.writer.closeTag("w:name");
        this.writer.openTag("wx:uiName");
        this.writer.attribute("wx:val", "catalog 4");
        this.writer.closeTag("wx:uiName");
        this.writer.openTag("w:autoRedefine");
        this.writer.closeTag("w:autoRedefine");
        this.writer.openTag("w:semiHidden");
        this.writer.closeTag("w:semiHidden");
        this.writer.openTag("w:rsid");
        this.writer.attribute("w:val", "009B3C8F");
        this.writer.closeTag("w:rsid");
        this.writer.openTag("w:pPr");
        this.writer.openTag("w:pStyle");
        this.writer.attribute("w:val", 4);
        this.writer.closeTag("w:pStyle");
        this.writeBidi(rtl);
        this.writer.closeTag("w:pPr");
        this.writer.openTag("w:rPr");
        this.writer.openTag("wx:font");
        this.writer.attribute("wx:val", "Times New Roman");
        this.writer.closeTag("wx:font");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:style");
        this.writer.openTag("w:style");
        this.writer.attribute("w:type", "character");
        this.writer.attribute("w:styleId", "Hyperlink");
        this.writeAttrTag("w:name", "Hyperlink");
        this.writer.openTag("w:rPr");
        this.writeAttrTag("w:u", "single");
        this.writeAttrTag("w:color", "0000ff");
        this.writer.closeTag("w:rPr");
        this.writer.closeTag("w:style");
        this.writer.openTag("w:style");
        this.writer.attribute("w:type", "table");
        this.writer.attribute("w:default", "on");
        this.writer.attribute("styleId", "TableNormal");
        this.writeAttrTag("w:name", "Normal Table");
        this.writer.openTag("wx:uiName");
        this.writer.attribute("wx:val", "Table Normal");
        this.writer.closeTag("wx:uiName");
        this.writer.openTag("w:rPr");
        this.writer.openTag("wx:font");
        this.writer.attribute("wx:val", "Calibri");
        this.writer.closeTag("wx:font");
        this.writer.openTag("w:lang");
        this.writer.attribute("w:val", "EN-US");
        this.writer.attribute("w:fareast", "ZH-CN");
        this.writer.attribute("w:bidi", "AR-SA");
        this.writer.closeTag("w:lang");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("w:tblPr");
        this.writer.openTag("w:tblInd");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:tblInd");
        this.writer.openTag("w:tblCellMar");
        this.writer.openTag("w:top");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:top");
        this.writer.openTag("w:left");
        this.writer.attribute("w:w", 108);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:left");
        this.writer.openTag("w:bottom");
        this.writer.attribute("w:w", 0);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:bottom");
        this.writer.openTag("w:right");
        this.writer.attribute("w:w", 108);
        this.writer.attribute("w:type", "dxa");
        this.writer.closeTag("w:right");
        this.writer.closeTag("w:tblCellMar");
        this.writer.closeTag("w:tblPr");
        this.writer.closeTag("w:style");
        this.writer.closeTag("w:styles");
        this.writer.openTag("w:displayBackgroundShape");
        this.writer.closeTag("w:displayBackgroundShape");
        this.writer.openTag("w:docPr");
        this.writer.openTag("w:view");
        this.writer.attribute("w:val", "print");
        this.writer.closeTag("w:view");
        this.writer.openTag("w:zoom");
        this.writer.attribute("w:percent", "100");
        this.writer.closeTag("w:zoom");
        this.writer.closeTag("w:docPr");
        this.writer.openTag("w:body");
    }

    private void writeCoreProperties(String creator, String title, String description) {
        this.writer.openTag("o:DocumentProperties");
        this.writer.openTag("o:Author");
        this.writer.text(creator);
        this.writer.closeTag("o:Author");
        this.writer.openTag("o:Title");
        this.writer.text(title);
        this.writer.closeTag("o:Title");
        this.writer.openTag("o:Description");
        this.writer.text(description);
        this.writer.closeTag("o:Description");
        this.writer.closeTag("o:DocumentProperties");
    }

    public void drawImage(byte[] data, double height, double width, HyperlinkInfo hyper, IStyle style, AbstractEmitterImpl.InlineFlag inlineFlag, String altText, String imageUrl) {
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK || inlineFlag == AbstractEmitterImpl.InlineFlag.FIRST_INLINE) {
            this.writer.openTag("w:p");
        }
        int imageId = this.getImageID();
        this.openHyperlink(hyper);
        this.writer.openTag("w:r");
        this.writer.openTag("w:pict");
        this.drawImageShapeType(imageId);
        this.drawImageData(data, imageId);
        this.drawImageShape(height, width, style, altText, imageId);
        this.writer.closeTag("w:pict");
        this.writer.closeTag("w:r");
        this.closeHyperlink(hyper);
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK) {
            this.writer.closeTag("w:p");
        }
    }

    private void drawImageData(byte[] data, int imageId) {
        String pic2Text = null;
        if (data != null && data.length != 0) {
            Base64 base = new Base64();
            pic2Text = new String(base.encode(data));
        }
        if (pic2Text != null) {
            this.writer.openTag("w:binData");
            this.writer.attribute("w:name", "wordml://" + imageId + ".png");
            this.writer.text(pic2Text);
            this.writer.closeTag("w:binData");
        }
    }

    private void drawImageShape(double height, double width, IStyle style, String altText, int imageId) {
        this.writer.openTag("v:shape");
        this.writer.attribute("id", "_x0000_i10" + imageId);
        this.writer.attribute("type", "#_x0000_t" + imageId);
        this.writer.attribute("alt", altText);
        this.writer.attribute("style", "width:" + width + "pt;height:" + height + "pt");
        this.drawImageBordersColor(style);
        this.writer.openTag("v:imagedata");
        this.writer.attribute("src", "wordml://" + imageId + ".png");
        this.writer.attribute("otitle", "");
        this.writer.closeTag("v:imagedata");
        this.drawImageBordersStyle(style);
        this.writer.closeTag("v:shape");
    }

    public void writeContent(int type, String txt, IStyle style, IStyle inlineStyle, String fontFamily, HyperlinkInfo info, AbstractEmitterImpl.InlineFlag inlineFlag, AbstractEmitterImpl.TextFlag flag) {
        if (inlineFlag == AbstractEmitterImpl.InlineFlag.BLOCK) {
            this.writeText(type, txt, style, fontFamily, info, flag);
        } else {
            boolean isInline = true;
            if (inlineFlag == AbstractEmitterImpl.InlineFlag.FIRST_INLINE && flag == AbstractEmitterImpl.TextFlag.START) {
                this.startParagraph(style, isInline);
            }
            if (inlineStyle != null) {
                this.writeTextInRun(type, txt, inlineStyle, fontFamily, info, isInline);
            } else {
                this.writeTextInRun(type, txt, style, fontFamily, info, isInline);
            }
        }
    }

    protected void openHyperlink(HyperlinkInfo info) {
        if (info == null) {
            return;
        }
        this.writer.openTag("w:hlink");
        if (info.getType() == 0) {
            this.writer.attribute("w:bookmark", info.getUrl());
        } else if (1 == info.getType()) {
            this.writer.attribute("w:dest", info.getUrl());
            if (info.getBookmark() != null) {
                this.writer.attribute("w:bookmark", info.getBookmark());
            }
        }
        if (info.getTooltip() != null) {
            this.writer.attribute("w:screenTip", info.getTooltip());
        }
    }

    protected void closeHyperlink(HyperlinkInfo info) {
        if (info == null || info.getType() == 2) {
            return;
        }
        this.writer.closeTag("w:hlink");
    }

    public void writeBookmark(String bm) {
        bm = WordUtil.validBookmarkName(bm);
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.bookmarkId);
        this.writer.attribute("w:type", "Word.Bookmark.Start");
        this.writer.attribute("w:name", bm);
        this.writer.closeTag("aml:annotation");
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.bookmarkId);
        this.writer.attribute("w:type", "Word.Bookmark.End");
        this.writer.closeTag("aml:annotation");
        ++this.bookmarkId;
    }

    public void close() {
        this.writer.close();
    }

    protected void writeTableLayout() {
        this.writer.openTag("w:tblLayout");
        this.writer.attribute("w:type", "Fixed");
        this.writer.closeTag("w:tblLayout");
    }

    protected void writeFontSize(IStyle style) {
        CSSValue fontSize = style.getProperty(42);
        int size = WordUtil.parseFontSize(((FloatValue)fontSize).getFloatValue());
        this.writeAttrTag("w:sz", size);
        this.writeAttrTag("w:sz-cs", size);
    }

    protected void writeFont(String fontFamily) {
        this.writer.openTag("w:rFonts");
        this.writer.attribute("w:ascii", fontFamily);
        this.writer.attribute("w:fareast", fontFamily);
        this.writer.attribute("w:h-ansi", fontFamily);
        this.writer.attribute("w:cs", fontFamily);
        this.writer.closeTag("w:rFonts");
    }

    protected void writeFontStyle(IStyle style) {
        String val = WordUtil.removeQuote(style.getFontStyle());
        if (!"normal".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:i", "on");
            this.writeAttrTag("w:i-cs", "on");
        }
    }

    protected void writeFontWeight(IStyle style) {
        String val = WordUtil.removeQuote(style.getFontWeight());
        if (!"normal".equalsIgnoreCase(val)) {
            this.writeAttrTag("w:b", "on");
            this.writeAttrTag("w:b-cs", "on");
        }
    }

    public void drawDocumentBackground(String bgcolor, String backgroundImageUrl, String backgroundHeight, String backgroundWidth) {
        this.writer.openTag("w:bgPict");
        if (backgroundImageUrl != null && backgroundHeight == null && backgroundWidth == null) {
            byte[] backgroundImageData = EmitterUtil.getImageData((String)backgroundImageUrl);
            this.drawDocumentBackgroundImage(backgroundImageData);
        } else {
            this.drawDocumentBackgroundColor(bgcolor);
        }
        this.writer.closeTag("w:bgPict");
    }

    public void drawDocumentBackgroundImage(String backgroundImageUrl, String height, String width, double topMargin, double leftMargin, double pageHeight, double pageWidth) {
        if (backgroundImageUrl != null) {
            Image imageInfo = EmitterUtil.parseImage(null, (int)3, (String)backgroundImageUrl, null, null);
            int imageWidth = imageInfo.getWidth();
            int imageHeight = imageInfo.getHeight();
            String[] realSize = WordUtil.parseBackgroundSize(height, width, imageWidth, imageHeight, pageWidth, pageHeight);
            byte[] backgroundImageData = EmitterUtil.getImageData((String)backgroundImageUrl);
            int imageId = this.getImageID();
            this.writer.openTag("w:p");
            this.writeHiddenProperty();
            this.writer.openTag("w:r");
            this.writer.openTag("w:pict");
            this.drawImageShapeType(imageId);
            this.drawImageData(backgroundImageData, imageId);
            this.drawBackgroundImageShape(realSize, topMargin, leftMargin, imageId);
            this.writer.closeTag("w:pict");
            this.writer.closeTag("w:r");
            this.writer.closeTag("w:p");
        }
    }

    private void drawBackgroundImageShape(String[] size, double topMargin, double leftMargin, int imageId) {
        this.writer.openTag("v:shape");
        this.writer.attribute("id", "_x0000_i10" + imageId);
        this.writer.attribute("type", "#_x0000_t" + imageId);
        this.writer.attribute("style", "position:absolute;left:0;text-align:left;margin-left:-" + leftMargin + "pt" + ";margin-top:-" + topMargin + "pt" + ";width:" + size[1] + ";height:" + size[0] + ";z-index:-1");
        this.writer.openTag("v:imagedata");
        this.writer.attribute("src", "wordml://" + imageId + ".png");
        this.writer.attribute("otitle", "");
        this.writer.closeTag("v:imagedata");
        this.writer.closeTag("v:shape");
    }

    private void drawDocumentBackgroundImage(byte[] data) {
        int imgId = this.getImageID();
        this.drawImageData(data, imgId);
        this.writer.openTag("w:background");
        this.writer.attribute("w:bgcolor", "white");
        this.writer.attribute("w:background", "wordml://" + imgId + ".png");
        this.writer.closeTag("w:background");
    }

    private void drawDocumentBackgroundColor(String data) {
        String color = WordUtil.parseColor(data);
        if (color != null) {
            this.writer.openTag("w:background");
            this.writer.attribute("w:bgcolor", color);
            this.writer.closeTag("w:background");
        }
    }

    public void startTableRow(double height) {
        this.startTableRow(height, false, false);
    }

    public void startPage() {
        this.writer.openTag("wx:sect");
    }

    public void endPage() {
        this.writer.closeTag("wx:sect");
    }

    public void end() {
        this.writer.closeTag("w:body");
        this.writer.closeTag("w:wordDocument");
        this.writer.close();
    }

    public void startHeader(boolean showHeaderOnFirst, int headerHeight, int headerWidth) {
        this.writer.openTag("w:hdr");
        if (showHeaderOnFirst) {
            this.writer.attribute("w:type", "first");
            this.writer.openTag("w:p");
            this.writer.openTag("w:r");
            this.writer.closeTag("w:r");
            this.writer.closeTag("w:p");
        } else {
            this.writer.attribute("w:type", "odd");
        }
        this.startHeaderFooterContainer(headerHeight, headerWidth);
    }

    public void endHeader() {
        this.endHeaderFooterContainer();
        this.writer.closeTag("w:hdr");
    }

    public void startFooter(int footerHeight, int footerWidth) {
        this.writer.openTag("w:ftr");
        this.writer.attribute("w:type", "odd");
        this.startHeaderFooterContainer(footerHeight, footerWidth);
    }

    public void endFooter() {
        this.endHeaderFooterContainer();
        this.writer.closeTag("w:ftr");
    }

    public void writeTOC(String tocText, int level) {
        this.writer.openTag("w:p");
        this.writer.openTag("w:rPr");
        this.writer.openTag("w:vanish");
        this.writer.closeTag("w:vanish");
        this.writer.closeTag("w:rPr");
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.bookmarkId);
        this.writer.attribute("w:type", "Word.Bookmark.Start");
        this.writer.attribute("w:name", "_Toc" + tocText);
        this.writer.closeTag("aml:annotation");
        this.writer.openTag("aml:annotation");
        this.writer.attribute("aml:id", this.bookmarkId++);
        this.writer.attribute("w:type", "Word.Bookmark.End");
        this.writer.closeTag("aml:annotation");
        this.writeField(true);
        this.writeTocText(tocText, level);
        this.writeField(false);
        this.writer.closeTag("w:p");
    }

    protected void writeVmerge(SpanInfo spanInfo) {
        if (spanInfo.isStart()) {
            this.writeAttrTag("w:vmerge", "restart");
        } else {
            this.writer.openTag("w:vmerge");
            this.writer.closeTag("w:vmerge");
        }
    }

    public void writeForeign(IForeignContent foreignContent) {
    }

    public void writePageBorders(IStyle style, int topMargin, int bottomMargin, int leftMargin, int rightMargin) {
        this.writer.openTag("w:pgBorders");
        this.writer.attribute("w:offset-from", "page");
        this.writeBorders(style, topMargin, bottomMargin, leftMargin, rightMargin);
        this.writer.closeTag("w:pgBorders");
    }
}

