/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.report.model.adapter.oda.IODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.ODADesignFactory;
import org.eclipse.birt.report.model.adapter.oda.impl.CompareUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.DataSetParameterAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.DesignObjectSerializer;
import org.eclipse.birt.report.model.adapter.oda.impl.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetParameterHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataElementUIHints;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterAttributes;
import org.eclipse.datatools.connectivity.oda.design.InputParameterUIHints;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

class AbstractReportParameterAdapter {
    protected static final String ALLOW_NULL_PROP_NAME = "allowNull";
    protected static final String ALLOW_BLANK_PROP_NAME = "allowBlank";
    protected final IODADesignFactory designFactory = ODADesignFactory.getFactory();

    AbstractReportParameterAdapter() {
    }

    static Boolean getROMNullability(ElementNullability nullability) {
        if (nullability == null) {
            return null;
        }
        switch (nullability.getValue()) {
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    protected void updateLinkedReportParameterFromROMParameter(AbstractScalarParameterHandle reportParam, OdaDataSetParameterHandle dataSetParam) throws SemanticException {
        assert (reportParam != null);
        if (dataSetParam == null) {
            return;
        }
        String defaultValue = dataSetParam.getDefaultValue();
        String paramName = dataSetParam.getParamName();
        if (!StringUtil.isBlank((String)defaultValue) && StringUtil.isBlank((String)paramName)) {
            this.setROMDefaultValue(reportParam, defaultValue);
        }
        if (StringUtil.isBlank((String)paramName)) {
            dataSetParam.setParamName(reportParam.getName());
        }
    }

    private void setROMDefaultValue(AbstractScalarParameterHandle setParam, String value) throws SemanticException {
        String literalValue = this.getROMDefaultValueLiteral(setParam, value);
        if (literalValue != null) {
            ArrayList<Expression> newValues = new ArrayList<Expression>();
            newValues.add(new Expression((Object)literalValue, "constant"));
            setParam.setDefaultValueList(newValues);
        }
    }

    protected String getROMDefaultValueLiteral(AbstractScalarParameterHandle setParam, String value) {
        boolean match;
        String literalValue = value;
        if (literalValue != null && (match = ExpressionUtil.isScalarParamReference((String)literalValue))) {
            return null;
        }
        if ("JS_EXPR".equalsIgnoreCase(literalValue)) {
            return null;
        }
        return literalValue;
    }

    void updateLinkedReportParameter(AbstractScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, OdaDataSetHandle setHandle) throws SemanticException {
        if (paramDefn == null) {
            return;
        }
        CommandStack cmdStack = reportParam.getModuleHandle().getCommandStack();
        try {
            cmdStack.startTrans(null);
            this.updateAbstractScalarParameter(reportParam, paramDefn, cachedParamDefn, setHandle);
        }
        catch (SemanticException e) {
            cmdStack.rollback();
            throw e;
        }
        cmdStack.commit();
    }

    protected void updateAbstractScalarParameter(AbstractScalarParameterHandle reportParam, ParameterDefinition paramDefn, ParameterDefinition cachedParamDefn, OdaDataSetHandle setHandle) throws SemanticException {
        this.updateDataElementAttrsToReportParam(paramDefn.getAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getAttributes(), reportParam);
        this.updateInputParameterAttrsToReportParam(paramDefn.getInputAttributes(), cachedParamDefn == null ? null : cachedParamDefn.getInputAttributes(), reportParam, setHandle);
    }

    protected static ParameterDefinition getValidParameterDefinition(OdaDataSetParameterHandle param, DataSetParameters odaParams) {
        if (param == null || odaParams == null) {
            return null;
        }
        if (odaParams.getParameterDefinitions().isEmpty()) {
            return null;
        }
        ParameterDefinition matchedParam = DataSetParameterAdapter.findParameterDefinition(odaParams, param.getNativeName(), param.getPosition());
        return matchedParam;
    }

    private void updateDataElementAttrsToReportParam(DataElementAttributes dataAttrs, DataElementAttributes cachedDataAttrs, AbstractScalarParameterHandle reportParam) throws SemanticException {
        DataElementUIHints cachedDataUiHints;
        if (dataAttrs == null) {
            return;
        }
        boolean allowsNull = dataAttrs.allowsNull();
        if (cachedDataAttrs == null || cachedDataAttrs.allowsNull() != allowsNull) {
            this.setReportParamIsRequired(reportParam, ALLOW_NULL_PROP_NAME, dataAttrs.allowsNull());
        }
        DataElementUIHints dataUiHints = dataAttrs.getUiHints();
        DataElementUIHints dataElementUIHints = cachedDataUiHints = cachedDataAttrs == null ? null : cachedDataAttrs.getUiHints();
        if (dataUiHints != null) {
            String cachedDescription;
            String cachedDisplayName;
            String displayName = dataUiHints.getDisplayName();
            String string = cachedDisplayName = cachedDataUiHints == null ? null : cachedDataUiHints.getDisplayName();
            if (cachedDisplayName == null || !cachedDisplayName.equals(displayName)) {
                reportParam.setPromptText(displayName);
            }
            String description = dataUiHints.getDescription();
            String string2 = cachedDescription = cachedDataUiHints == null ? null : cachedDataUiHints.getDescription();
            if (cachedDescription == null || !cachedDescription.equals(description)) {
                reportParam.setHelpText(description);
            }
        }
    }

    private void updateInputParameterAttrsToReportParam(InputParameterAttributes inputParamAttrs, InputParameterAttributes cachedInputParamAttrs, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        if (inputParamAttrs == null) {
            return;
        }
        InputParameterUIHints paramUiHints = inputParamAttrs.getUiHints();
        if (paramUiHints != null && reportParam.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle paramGroup = (ParameterGroupHandle)reportParam.getContainer();
            InputParameterUIHints cachedParamUiHints = cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getUiHints();
            String cachedGroupPromptDisplayName = cachedParamUiHints == null ? null : cachedParamUiHints.getGroupPromptDisplayName();
            String groupPromptDisplayName = paramUiHints.getGroupPromptDisplayName();
            if (cachedGroupPromptDisplayName == null || !cachedGroupPromptDisplayName.equals(groupPromptDisplayName)) {
                paramGroup.setDisplayName(paramUiHints.getGroupPromptDisplayName());
            }
        }
        this.updateInputElementAttrsToReportParam(inputParamAttrs.getElementAttributes(), cachedInputParamAttrs == null ? null : cachedInputParamAttrs.getElementAttributes(), reportParam, setHandle);
    }

    protected void updateInputElementAttrsToReportParam(InputElementAttributes elementAttrs, InputElementAttributes cachedElementAttrs, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        boolean cachedIsEnabled;
        DynamicValuesQuery cachedValueQuery;
        Boolean cachedIsOptional;
        StaticValues cachedDefaultValues;
        if (elementAttrs == null) {
            return;
        }
        StaticValues defaultValues = elementAttrs.getDefaultValues();
        StaticValues staticValues = cachedDefaultValues = cachedElementAttrs == null ? null : cachedElementAttrs.getDefaultValues();
        if (!new EcoreUtil.EqualityHelper().equals((EObject)cachedDefaultValues, (EObject)defaultValues)) {
            ArrayList<String> newValues = null;
            if (defaultValues != null) {
                newValues = new ArrayList<String>();
                EList tmpValues = defaultValues.getValues();
                int i = 0;
                while (i < tmpValues.size()) {
                    String tmpValue = (String)tmpValues.get(i);
                    if (!"JS_EXPR".equals(tmpValue)) {
                        newValues.add(tmpValue);
                    }
                    ++i;
                }
            }
            reportParam.setDefaultValueList(newValues);
        }
        Boolean isOptional = elementAttrs.isOptional();
        Boolean bl = cachedIsOptional = cachedElementAttrs == null ? null : Boolean.valueOf(cachedElementAttrs.isOptional());
        if (!CompareUtil.isEquals(cachedIsOptional, isOptional)) {
            this.setReportParamIsRequired(reportParam, ALLOW_BLANK_PROP_NAME, isOptional);
        }
        this.updateROMSelectionList(elementAttrs.getStaticValueChoices(), cachedElementAttrs == null ? null : cachedElementAttrs.getStaticValueChoices(), reportParam);
        DynamicValuesQuery valueQuery = elementAttrs.getDynamicValueChoices();
        this.updateROMDyanmicList(valueQuery, cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices(), reportParam, setHandle);
        DynamicValuesQuery dynamicValuesQuery = cachedValueQuery = cachedElementAttrs == null ? null : cachedElementAttrs.getDynamicValueChoices();
        if (valueQuery == null && cachedValueQuery == null) {
            return;
        }
        if (valueQuery == null) {
            valueQuery = this.designFactory.createDynamicValuesQuery();
        }
        boolean isEnabled = valueQuery.isEnabled();
        boolean bl2 = cachedIsEnabled = cachedValueQuery == null ? false : cachedValueQuery.isEnabled();
        if ((cachedValueQuery == null || cachedIsEnabled != isEnabled) && isEnabled) {
            reportParam.setValueType("dynamic");
        } else if (!(cachedValueQuery != null && cachedIsEnabled == isEnabled || isEnabled)) {
            reportParam.setValueType("static");
        }
    }

    protected static String newROMControlType(int promptStyle) {
        switch (promptStyle) {
            case 3: {
                return "check-box";
            }
            case 1: 
            case 2: {
                return "list-box";
            }
            case 4: {
                return "radio-button";
            }
            case 0: {
                return "text-box";
            }
        }
        return null;
    }

    private void updateROMSelectionList(ScalarValueChoices staticChoices, ScalarValueChoices cachedStaticChoices, AbstractScalarParameterHandle paramHandle) throws SemanticException {
        if (staticChoices == null) {
            return;
        }
        String newChoiceStr = DesignObjectSerializer.toExternalForm((EObject)staticChoices);
        String latestChoiceStr = DesignObjectSerializer.toExternalForm((EObject)cachedStaticChoices);
        if (latestChoiceStr != null && latestChoiceStr.equals(newChoiceStr)) {
            return;
        }
        ArrayList<SelectionChoice> retList = new ArrayList<SelectionChoice>();
        EList choiceList = staticChoices.getScalarValues();
        int i = 0;
        while (i < choiceList.size()) {
            ScalarValueDefinition valueDefn = (ScalarValueDefinition)choiceList.get(i);
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            choice.setValue(valueDefn.getValue());
            choice.setLabel(valueDefn.getDisplayName());
            retList.add(choice);
            ++i;
        }
        PropertyHandle propHandle = paramHandle.getPropertyHandle("selectionList");
        propHandle.clearValue();
        int i2 = 0;
        while (i2 < retList.size()) {
            propHandle.addItem(retList.get(i2));
            ++i2;
        }
    }

    private void updateROMDyanmicList(DynamicValuesQuery valueQuery, DynamicValuesQuery cachedValueQuery, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        String cachedValue;
        if (valueQuery == null) {
            return;
        }
        String value = valueQuery.getDataSetDesign().getName();
        String string = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getDataSetDesign().getName();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setDataSetName(value);
            ModuleHandle module = setHandle.getModuleHandle();
            DataSetHandle target = module.findDataSet(value);
            if (target instanceof OdaDataSetHandle && target != setHandle) {
                new ModelOdaAdapter().updateDataSetHandle(valueQuery.getDataSetDesign(), (OdaDataSetHandle)target, false);
            }
            if (target == null) {
                OdaDataSetHandle nestedDataSet = new ModelOdaAdapter().createDataSetHandle(valueQuery.getDataSetDesign(), module);
                module.getDataSets().add((DesignElementHandle)nestedDataSet);
            }
        }
        value = valueQuery.getValueColumn();
        String string2 = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getValueColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setValueExpr(value);
        }
        value = valueQuery.getDisplayNameColumn();
        String string3 = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getDisplayNameColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setLabelExpr(value);
        }
    }

    ParameterDefinition updateParameterDefinitionFromReportParam(ParameterDefinition paramDefn, AbstractScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        assert (paramHandle != null);
        if (paramDefn == null) {
            return null;
        }
        paramDefn.setAttributes(this.updateDataElementAttrs(paramDefn.getAttributes(), paramHandle));
        paramDefn.setInputAttributes(this.updateInputElementAttrs(paramDefn.getInputAttributes(), paramHandle, dataSetDesign));
        return paramDefn;
    }

    private DataElementAttributes updateDataElementAttrs(DataElementAttributes dataAttrs, AbstractScalarParameterHandle paramHandle) {
        DataElementAttributes retDataAttrs = dataAttrs;
        if (retDataAttrs == null) {
            retDataAttrs = this.designFactory.createDataElementAttributes();
        }
        retDataAttrs.setNullability(DataSetParameterAdapter.newElementNullability(this.getReportParamAllowMumble(paramHandle, ALLOW_NULL_PROP_NAME)));
        DataElementUIHints uiHints = this.designFactory.createDataElementUIHints();
        uiHints.setDisplayName(paramHandle.getPromptText());
        uiHints.setDescription(paramHandle.getHelpText());
        retDataAttrs.setUiHints(uiHints);
        return retDataAttrs;
    }

    protected InputParameterAttributes updateInputElementAttrs(InputParameterAttributes inputParamAttrs, AbstractScalarParameterHandle paramHandle, DataSetDesign dataSetDesign) {
        InputElementAttributes inputAttrs;
        InputParameterAttributes retInputParamAttrs = inputParamAttrs;
        if (inputParamAttrs == null) {
            retInputParamAttrs = this.designFactory.createInputParameterAttributes();
        }
        if ((inputAttrs = retInputParamAttrs.getElementAttributes()) == null) {
            inputAttrs = this.designFactory.createInputElementAttributes();
        }
        StaticValues newValues = null;
        List tmpValues = paramHandle.getDefaultValueList();
        if (tmpValues != null) {
            int i = 0;
            while (i < tmpValues.size()) {
                if (newValues == null) {
                    newValues = this.designFactory.createStaticValues();
                }
                newValues.add((Object)((Expression)tmpValues.get(i)).getStringExpression());
                ++i;
            }
        }
        inputAttrs.setDefaultValues(newValues);
        inputAttrs.setOptional(this.getReportParamAllowMumble(paramHandle, ALLOW_BLANK_PROP_NAME));
        ScalarValueChoices staticChoices = null;
        Iterator selectionList = paramHandle.choiceIterator();
        while (selectionList.hasNext()) {
            if (staticChoices == null) {
                staticChoices = this.designFactory.createScalarValueChoices();
            }
            SelectionChoiceHandle choice = (SelectionChoiceHandle)selectionList.next();
            ScalarValueDefinition valueDefn = this.designFactory.createScalarValueDefinition();
            valueDefn.setValue(choice.getValue());
            valueDefn.setDisplayName(choice.getLabel());
            staticChoices.getScalarValues().add((Object)valueDefn);
        }
        inputAttrs.setStaticValueChoices(staticChoices);
        DataSetHandle setHandle = paramHandle.getDataSet();
        String valueExpr = paramHandle.getValueExpr();
        String labelExpr = paramHandle.getLabelExpr();
        if (setHandle instanceof OdaDataSetHandle && valueExpr != null) {
            DataSetDesign targetDataSetDesign;
            DynamicValuesQuery valueQuery = this.designFactory.createDynamicValuesQuery();
            if (dataSetDesign != null) {
                targetDataSetDesign = (DataSetDesign)EcoreUtil.copy((EObject)dataSetDesign);
                if (!setHandle.getName().equals(dataSetDesign.getName())) {
                    targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                }
                valueQuery.setDataSetDesign(targetDataSetDesign);
            } else {
                targetDataSetDesign = new ModelOdaAdapter().createDataSetDesign((OdaDataSetHandle)setHandle);
                valueQuery.setDataSetDesign(targetDataSetDesign);
            }
            valueQuery.setDisplayNameColumn(labelExpr);
            valueQuery.setValueColumn(valueExpr);
            boolean isEnabled = "dynamic".equalsIgnoreCase(paramHandle.getValueType());
            valueQuery.setEnabled(isEnabled);
            inputAttrs.setDynamicValueChoices(valueQuery);
        }
        if (paramHandle.getContainer() instanceof ParameterGroupHandle) {
            ParameterGroupHandle groupHandle = (ParameterGroupHandle)paramHandle.getContainer();
            InputParameterUIHints paramUiHints = this.designFactory.createInputParameterUIHints();
            paramUiHints.setGroupPromptDisplayName(groupHandle.getDisplayName());
            retInputParamAttrs.setUiHints(paramUiHints);
        }
        retInputParamAttrs.setElementAttributes(inputAttrs);
        return retInputParamAttrs;
    }

    protected static InputPromptControlStyle newPromptStyle(String romType, boolean mustMatch) {
        if (romType == null) {
            return null;
        }
        int type = -1;
        if ("check-box".equalsIgnoreCase(romType)) {
            type = 3;
        } else if ("list-box".equalsIgnoreCase(romType)) {
            type = mustMatch ? 1 : 2;
        } else if ("radio-button".equalsIgnoreCase(romType)) {
            type = 4;
        } else if ("text-box".equalsIgnoreCase(romType)) {
            type = 0;
        }
        return InputPromptControlStyle.get((int)type);
    }

    protected boolean getReportParamAllowMumble(AbstractScalarParameterHandle param, String propName) {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(propName) || ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(propName)) {
            return !param.isRequired();
        }
        assert (false);
        return false;
    }

    protected void setReportParamIsRequired(AbstractScalarParameterHandle param, String obsoletePropName, boolean value) throws SemanticException {
        if (ALLOW_NULL_PROP_NAME.equalsIgnoreCase(obsoletePropName) || ALLOW_BLANK_PROP_NAME.equalsIgnoreCase(obsoletePropName)) {
            param.setIsRequired(!value);
        } else assert (false);
    }
}

