/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.birt.report.model.adapter.oda.impl.AbstractReportParameterAdapter;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DynamicFilterParameterHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.CompositeFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.CustomFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DynamicFilterExpression;
import org.eclipse.datatools.connectivity.oda.design.ExpressionArguments;
import org.eclipse.datatools.connectivity.oda.design.ExpressionParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ExpressionVariable;
import org.eclipse.datatools.connectivity.oda.design.FilterExpression;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ResultSetCriteria;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterAdapter {
    private final OdaDataSetHandle setHandle;
    private final DataSetDesign setDesign;
    private final AbstractReportParameterAdapter paramAdapter = new AbstractReportParameterAdapter();
    private final String SEPERATOR = ":";
    private final String CUSTOM_PREFIX = "#";
    private final String DYNAMIC_PREFIX = "!";

    public FilterAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        this.setHandle = setHandle;
        this.setDesign = setDesign;
    }

    public void updateROMFilterCondition() throws SemanticException {
        ResultSetCriteria criteria;
        FilterExpression filterExpression = null;
        ResultSetDefinition resultSet = this.setDesign.getPrimaryResultSet();
        if (resultSet != null && (criteria = resultSet.getCriteria()) != null) {
            filterExpression = criteria.getFilterSpecification();
        }
        Map<String, FilterExpression> filterExprMap = this.buildFilterExpressionMap(filterExpression);
        this.cleanUpROMFilterCondition(filterExprMap);
        this.updateExistingROMFilterConditions(filterExprMap);
        this.createROMFilterConditions(filterExprMap);
        filterExprMap.clear();
        filterExprMap = null;
    }

    private Map<String, FilterExpression> buildFilterExpressionMap(FilterExpression filterExpr) {
        LinkedHashMap<String, FilterExpression> filterExpressions = new LinkedHashMap<String, FilterExpression>();
        if (filterExpr != null) {
            if (filterExpr instanceof CompositeFilterExpression) {
                CompositeFilterExpression compositeFilterExp = (CompositeFilterExpression)filterExpr;
                for (FilterExpression child : compositeFilterExp.getChildren()) {
                    filterExpressions.putAll(this.buildFilterExpressionMap(child));
                }
            } else {
                String key = this.getMapKey(filterExpr);
                if (key != null) {
                    DynamicFilterExpression dynamicFilterExp;
                    ExpressionArguments arguments;
                    if (filterExpr instanceof CustomFilterExpression) {
                        filterExpressions.put(key, filterExpr);
                    } else if (filterExpr instanceof DynamicFilterExpression && (arguments = (dynamicFilterExp = (DynamicFilterExpression)filterExpr).getContextArguments()) != null && arguments.getExpressionParameterDefinitions() != null && !arguments.getExpressionParameterDefinitions().isEmpty()) {
                        filterExpressions.put(key, (FilterExpression)dynamicFilterExp);
                    }
                }
            }
        }
        return filterExpressions;
    }

    private String getMapKey(FilterExpression filterExpr) {
        String key = null;
        String columnExpr = this.getColumnExpr(filterExpr);
        if (!StringUtil.isBlank((String)columnExpr)) {
            if (filterExpr instanceof CustomFilterExpression) {
                key = "#" + filterExpr.toString();
            } else if (filterExpr instanceof DynamicFilterExpression) {
                key = "!" + this.setHandle.getName() + ":" + columnExpr;
            } else assert (false);
        }
        return key;
    }

    private String getColumnExpr(FilterExpression filterExpr) {
        ExpressionVariable variable = null;
        if (filterExpr instanceof CustomFilterExpression) {
            variable = ((CustomFilterExpression)filterExpr).getContextVariable();
        } else if (filterExpr instanceof DynamicFilterExpression) {
            variable = ((DynamicFilterExpression)filterExpr).getContextVariable();
        }
        if (variable != null) {
            return variable.getIdentifier();
        }
        return null;
    }

    private String getMapKey(FilterConditionHandle filterConditionHandle) {
        ParameterHandle parameterHandle;
        String key = null;
        if (!StringUtil.isBlank((String)filterConditionHandle.getDynamicFilterParameter()) && (parameterHandle = this.setHandle.getModuleHandle().findParameter(filterConditionHandle.getDynamicFilterParameter())) instanceof DynamicFilterParameterHandle) {
            DynamicFilterParameterHandle dynamicFilterParamHandle = (DynamicFilterParameterHandle)parameterHandle;
            key = "!" + dynamicFilterParamHandle.getDataSetName() + ":" + dynamicFilterParamHandle.getColumn();
        }
        return key;
    }

    private void updateExistingROMFilterConditions(Map<String, FilterExpression> filterExpMap) throws SemanticException {
        Iterator iter = this.setHandle.filtersIterator();
        while (iter.hasNext()) {
            FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
            String key = this.getMapKey(filterConditionHandle);
            if (key != null && filterExpMap.containsKey(key)) {
                DynamicFilterParameterHandle dynamicFilterParamHandle = (DynamicFilterParameterHandle)this.setHandle.getModuleHandle().findParameter(filterConditionHandle.getDynamicFilterParameter());
                this.updateDynamicFilterCondition(filterConditionHandle, (DynamicFilterExpression)filterExpMap.get(key), dynamicFilterParamHandle);
                filterExpMap.remove(key);
                continue;
            }
            assert (false);
        }
    }

    private void createROMFilterConditions(Map<String, FilterExpression> filterExpMap) throws SemanticException {
        for (FilterExpression filterExpr : filterExpMap.values()) {
            FilterCondition filterCondition = StructureFactory.createFilterCond();
            filterCondition.setExpr(this.getColumnExpr(filterExpr));
            FilterConditionHandle filterConditionHandle = (FilterConditionHandle)this.setHandle.getPropertyHandle("filter").addItem((IStructure)filterCondition);
            if (filterExpr instanceof CustomFilterExpression) {
                CustomFilterExpression customFilterExp = (CustomFilterExpression)filterExpr;
                this.updateCustomFilterCondition(filterConditionHandle, customFilterExp);
                continue;
            }
            if (!(filterExpr instanceof DynamicFilterExpression)) continue;
            DynamicFilterExpression dynamicFilterExp = (DynamicFilterExpression)filterExpr;
            DynamicFilterParameterHandle dynamicFilterParamHandle = this.setHandle.getModuleHandle().getElementFactory().newDynamicFilterParameter(null);
            dynamicFilterParamHandle.setDataSetName(this.setHandle.getName());
            dynamicFilterParamHandle.setColumn(dynamicFilterExp.getContextVariable().getIdentifier());
            this.setHandle.getModuleHandle().getParameters().add((DesignElementHandle)dynamicFilterParamHandle);
            filterConditionHandle.setDynamicFilterParameter(dynamicFilterParamHandle.getName());
            this.updateDynamicFilterCondition(filterConditionHandle, dynamicFilterExp, dynamicFilterParamHandle);
        }
    }

    private void updateCustomFilterCondition(FilterConditionHandle filterConditionHandle, CustomFilterExpression customFilterExpr) throws SemanticException {
        filterConditionHandle.setExtensionName(customFilterExpr.getDeclaringExtensionId());
        filterConditionHandle.setExtensionExprId(customFilterExpr.getId());
        filterConditionHandle.setPushDown(true);
        filterConditionHandle.setOptional(customFilterExpr.isOptional());
    }

    private void updateDynamicFilterCondition(FilterConditionHandle filterConditionHandle, DynamicFilterExpression dynamicFilterExpr, DynamicFilterParameterHandle dynamicFilterParamHandle) throws SemanticException {
        ExpressionVariable variable = dynamicFilterExpr.getContextVariable();
        ExpressionArguments arguments = dynamicFilterExpr.getContextArguments();
        ExpressionParameterDefinition paramDefn = (ExpressionParameterDefinition)arguments.getExpressionParameterDefinitions().get(0);
        if (paramDefn != null) {
            filterConditionHandle.setOptional(dynamicFilterExpr.isOptional());
            filterConditionHandle.setExpr(variable.getIdentifier());
            this.updateDynamicFilterParameter(dynamicFilterParamHandle, paramDefn);
        }
    }

    private void updateDynamicFilterParameter(DynamicFilterParameterHandle dynamicFilterParamHandle, ExpressionParameterDefinition expParamDefn) throws SemanticException {
        ParameterDefinition paramDefn = expParamDefn.getDynamicInputParameter();
        if (paramDefn == null) {
            return;
        }
        this.paramAdapter.updateAbstractScalarParameter((AbstractScalarParameterHandle)dynamicFilterParamHandle, paramDefn, null, this.setHandle);
    }

    private void cleanUpROMFilterCondition(Map<String, FilterExpression> filterExpMap) throws SemanticException {
        ArrayList<FilterCondition> dropList = new ArrayList<FilterCondition>();
        Iterator iter = this.setHandle.filtersIterator();
        while (iter.hasNext()) {
            FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
            String dynamicParameterName = filterHandle.getDynamicFilterParameter();
            String key = this.getMapKey(filterHandle);
            if (key == null || filterExpMap.containsKey(key)) continue;
            if (!StringUtil.isBlank((String)dynamicParameterName)) {
                ParameterHandle parameterHandle = this.setHandle.getModuleHandle().findParameter(dynamicParameterName);
                parameterHandle.drop();
            }
            dropList.add((FilterCondition)filterHandle.getStructure());
        }
        for (FilterCondition fc : dropList) {
            this.setHandle.removeFilter(fc);
        }
    }

    public void updateOdaFilterExpression() {
        ResultSetDefinition resultSet = this.setDesign.getPrimaryResultSet();
        if (resultSet == null) {
            return;
        }
        ResultSetCriteria criteria = resultSet.getCriteria();
        if (criteria == null) {
            return;
        }
        int count = 0;
        FilterExpression filterExpr = null;
        Iterator iter = this.setHandle.filtersIterator();
        while (iter.hasNext()) {
            FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
            FilterExpression filter = this.createOdaFilterExpression(filterHandle);
            if (filter == null) continue;
            switch (++count) {
                case 1: {
                    filterExpr = filter;
                    break;
                }
                case 2: {
                    CompositeFilterExpression compositeFilterExp = DesignFactory.eINSTANCE.createCompositeFilterExpression();
                    compositeFilterExp.add(filterExpr);
                    filterExpr = compositeFilterExp;
                }
                default: {
                    ((CompositeFilterExpression)filterExpr).add(filter);
                }
            }
        }
        criteria.setFilterSpecification(filterExpr);
    }

    private FilterExpression createOdaFilterExpression(FilterConditionHandle filterHandle) {
        ParameterHandle paramHandle;
        CustomFilterExpression filterExpr = null;
        ExpressionVariable variable = DesignFactory.eINSTANCE.createExpressionVariable();
        variable.setIdentifier(filterHandle.getExpr());
        if (!StringUtil.isBlank((String)filterHandle.getExtensionName())) {
            CustomFilterExpression customFilterExpr = DesignFactory.eINSTANCE.createCustomFilterExpression();
            customFilterExpr.setContextVariable(variable);
            customFilterExpr.setDeclaringExtensionId(filterHandle.getExtensionName());
            customFilterExpr.setId(filterHandle.getExtensionExprId());
            customFilterExpr.setIsOptional(filterHandle.isOptional());
            filterExpr = customFilterExpr;
        } else if (!StringUtil.isBlank((String)filterHandle.getDynamicFilterParameter()) && (paramHandle = this.setHandle.getModuleHandle().findParameter(filterHandle.getDynamicFilterParameter())) instanceof DynamicFilterParameterHandle) {
            DynamicFilterParameterHandle dynamicParamHandle = (DynamicFilterParameterHandle)paramHandle;
            DynamicFilterExpression dynamicFilterExpr = DesignFactory.eINSTANCE.createDynamicFilterExpression();
            dynamicFilterExpr.setIsOptional(filterHandle.isOptional());
            dynamicFilterExpr.setContextVariable(variable);
            ExpressionArguments arguments = DesignFactory.eINSTANCE.createExpressionArguments();
            ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
            this.paramAdapter.updateParameterDefinitionFromReportParam(paramDefn, (AbstractScalarParameterHandle)dynamicParamHandle, this.setDesign);
            arguments.addDynamicParameter(paramDefn);
            dynamicFilterExpr.setContextArguments(arguments);
            filterExpr = dynamicFilterExpr;
        }
        return filterExpr;
    }
}

