/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.core.security.PropertySecurity;
import org.eclipse.birt.data.engine.core.security.ThreadSecurity;
import org.eclipse.birt.data.engine.executor.CandidateQuery;
import org.eclipse.birt.data.engine.executor.dscache.DataSourceQuery;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odaconsumer.Connection;
import org.eclipse.birt.data.engine.odaconsumer.ConnectionManager;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odi.ICandidateQuery;
import org.eclipse.birt.data.engine.odi.IDataSource;
import org.eclipse.birt.data.engine.odi.IDataSourceQuery;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataSource
implements IDataSource {
    private String driverName;
    private Map appContext;
    private Properties connectionProps = PropertySecurity.createProperties();
    private static Map<DataEngineSession, Map<ConnectionProp, Set<CacheConnection>>> dataEngineLevelConnectionPool = PropertySecurity.createHashMap();
    private HashMap statementMap = new HashMap();
    private static String className = DataSource.class.getName();
    private static Logger logger = Logger.getLogger(className);
    private DataEngineSession session;

    public DataSource(String driverName, Map connProperties, DataEngineSession session) {
        this.driverName = driverName;
        if (connProperties != null) {
            this.connectionProps.putAll((Map<?, ?>)connProperties);
        }
        this.session = session;
        this.session.getEngine().addShutdownListener(new ShutdownListener(session));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<CacheConnection> getOdaConnections(boolean populateToCache) {
        Map<DataEngineSession, Map<ConnectionProp, Set<CacheConnection>>> map = dataEngineLevelConnectionPool;
        synchronized (map) {
            ConnectionProp connProp;
            Map<ConnectionProp, Set<CacheConnection>> odaConnectionsMap;
            if (dataEngineLevelConnectionPool.get(this.session) == null) {
                if (populateToCache) {
                    dataEngineLevelConnectionPool.put(this.session, new HashMap());
                } else {
                    return new HashSet<CacheConnection>();
                }
            }
            if ((odaConnectionsMap = dataEngineLevelConnectionPool.get(this.session)).get(connProp = new ConnectionProp(this.driverName, this.connectionProps, this.appContext)) == null) {
                odaConnectionsMap.put(connProp, new HashSet());
            }
            return odaConnectionsMap.get(connProp);
        }
    }

    String getDriverName() {
        return this.driverName;
    }

    @Override
    public void addProperty(String name, String value) throws DataException {
        if (this.isOpen()) {
            throw new DataException("data.engine.DataSourceIsOpen");
        }
        this.connectionProps.put(name, value);
    }

    @Override
    public void setAppContext(Map context) throws DataException {
        this.appContext = context;
    }

    public boolean isOpen() {
        return this.getOdaConnections(false).size() > 0;
    }

    @Override
    public void open() throws DataException {
        if (this.isOpen()) {
            return;
        }
        if (this.driverName == null || this.driverName.length() == 0) {
            return;
        }
        this.newConnection();
    }

    private CacheConnection newConnection() throws DataException {
        CacheConnection conn = new CacheConnection();
        conn.odaConn = ConnectionManager.getInstance().openConnection(this.driverName, this.connectionProps, this.appContext);
        int max = conn.odaConn.getMaxQueries();
        if (max != 0) {
            conn.maxStatements = max;
        }
        this.getOdaConnections(true).add(conn);
        return conn;
    }

    private CacheConnection getAvailableConnection() throws DataException {
        for (CacheConnection c : this.getOdaConnections(true)) {
            if (c.currentStatements >= c.maxStatements) continue;
            return c;
        }
        return this.newConnection();
    }

    @Override
    public IDataSourceQuery newQuery(String queryType, String queryText, boolean fromCache) throws DataException {
        if (fromCache) {
            return new DataSourceQuery(this.session);
        }
        return new org.eclipse.birt.data.engine.executor.DataSourceQuery(this, queryType, queryText, this.session);
    }

    @Override
    public ICandidateQuery newCandidateQuery(boolean fromCache) throws DataException {
        if (fromCache) {
            return new org.eclipse.birt.data.engine.executor.dscache.CandidateQuery(this.session);
        }
        return new CandidateQuery(this.session);
    }

    synchronized PreparedStatement prepareStatement(String queryText, String dataSetType, QuerySpecification querySpec) throws DataException {
        assert (this.isOpen());
        CacheConnection conn = this.getAvailableConnection();
        assert (conn.currentStatements < conn.maxStatements);
        ++conn.currentStatements;
        PreparedStatement stmt = conn.odaConn.prepareStatement(queryText, dataSetType, querySpec);
        this.statementMap.put(stmt, conn);
        return stmt;
    }

    synchronized void closeStatement(PreparedStatement stmt) {
        assert (stmt != null);
        CacheConnection conn = (CacheConnection)this.statementMap.remove(stmt);
        if (conn == null) {
            logger.logp(Level.WARNING, className, "closeStatement", "statement not found");
        } else {
            --conn.currentStatements;
            if (conn.currentStatements < 0) {
                logger.warning(String.valueOf(DataSource.class.getName()) + ".closeStatement: negative statement count for connection.");
            }
        }
        try {
            stmt.close();
        }
        catch (DataException e) {
            logger.logp(Level.FINE, className, "closeStatement", "Exception at PreparedStatement.close()", (Throwable)((Object)e));
        }
    }

    @Override
    public boolean canClose() {
        return this.statementMap.size() == 0;
    }

    @Override
    public void close() {
        Thread thread = ThreadSecurity.createThread(new DataSourceReleaser(this));
        thread.start();
    }

    public void finalize() {
        if (this.isOpen()) {
            this.close();
        }
    }

    private static final class CacheConnection {
        Connection odaConn;
        int maxStatements = Integer.MAX_VALUE;
        int currentStatements = 0;

        private CacheConnection() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConnectionProp {
        private String driverName;
        private Properties props;
        private Map appContext;

        public ConnectionProp(String driverName, Properties connectionProps, Map appContext) {
            this.driverName = driverName;
            this.props = connectionProps;
            this.appContext = appContext;
        }

        private boolean twoMapEquals(Map<?, ?> m1, Map<?, ?> m2) {
            if (m1.size() != m2.size()) {
                return false;
            }
            for (Object key : m1.keySet()) {
                Object o2;
                Object o1 = m1.get(key);
                if (o1 == (o2 = m2.get(key))) continue;
                if (o1 == null || o2 == null) {
                    return false;
                }
                if (o1.equals(o2)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.driverName == null ? 0 : this.driverName.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ConnectionProp other = (ConnectionProp)obj;
            if (this.appContext == null ? other.appContext != null : !this.twoMapEquals(this.appContext, other.appContext)) {
                return false;
            }
            if (this.driverName == null ? other.driverName != null : !this.driverName.equals(other.driverName)) {
                return false;
            }
            return !(this.props == null ? other.props != null : !this.twoMapEquals(this.props, other.props));
        }
    }

    private static final class ConnectionReleaser
    implements Runnable {
        private DataEngineSession session = null;

        public ConnectionReleaser(DataEngineSession st) {
            this.session = st;
        }

        public synchronized void run() {
            try {
                Map odaConnectionsMap = (Map)dataEngineLevelConnectionPool.remove(this.session);
                if (odaConnectionsMap == null) {
                    return;
                }
                for (Set set : odaConnectionsMap.values()) {
                    for (CacheConnection conn : set) {
                        try {
                            conn.odaConn.close();
                        }
                        catch (DataException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class DataSourceReleaser
    implements Runnable {
        private DataSource source = null;

        public DataSourceReleaser(DataSource st) {
            this.source = st;
        }

        public void run() {
            try {
                Set it;
                if (this.source.statementMap.size() > 0) {
                    for (PreparedStatement stmt : this.source.statementMap.keySet()) {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {
                            logger.logp(Level.FINE, className, "close", "Exception at PreparedStatement.close()", e);
                        }
                    }
                    this.source.statementMap.clear();
                }
                if ((it = this.source.getOdaConnections(false)).size() > 1) {
                    CacheConnection conn = (CacheConnection)it.iterator().next();
                    conn.currentStatements = 0;
                    it.remove(conn);
                    for (CacheConnection connections : it) {
                        try {
                            connections.odaConn.close();
                        }
                        catch (Exception e) {
                            logger.logp(Level.FINE, className, "close", "Exception at Connection.close()", e);
                        }
                    }
                    it.clear();
                    it.add(conn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ShutdownListener
    implements IShutdownListener {
        private DataEngineSession session;

        public ShutdownListener(DataEngineSession session) {
            this.session = session;
        }

        public void dataEngineShutdown() {
            Thread thread = ThreadSecurity.createThread(new ConnectionReleaser(this.session));
            thread.start();
        }
    }
}

