/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.olap.OLAPException;
import javax.olap.cursor.Blob;
import javax.olap.cursor.Date;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import javax.olap.cursor.RowDataMetaData;
import javax.olap.cursor.Time;
import javax.olap.cursor.Timestamp;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.cursor.Accessor;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.driver.IResultSet;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CalculatedMember;
import org.eclipse.birt.data.engine.olap.query.view.Relationship;

public class AggregationAccessor
implements Accessor {
    private BirtCubeView view;
    private IResultSet resultSet;
    private Map relationMap;
    private int[] currentPosition;

    public AggregationAccessor(BirtCubeView view, IResultSet result, Map relationMap) {
        this.resultSet = result;
        this.view = view;
        this.relationMap = relationMap;
        if (result == null || result.getMeasureResult() == null) {
            return;
        }
        this.currentPosition = new int[this.resultSet.getMeasureResult().length];
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                if (this.resultSet.getMeasureResult()[i].getQueryResultSet().length() > 0) {
                    this.resultSet.getMeasureResult()[i].getQueryResultSet().seek(0);
                    this.currentPosition[i] = 0;
                } else {
                    this.currentPosition[i] = -1;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    private boolean populateRelation(int aggrIndex, String aggrName) throws OLAPException, IOException, DataException {
        Object value;
        DimensionCursor cursor;
        DimLevel level;
        IAggregationResultSet rs = this.resultSet.getMeasureResult()[aggrIndex].getQueryResultSet();
        if (rs == null || rs.length() <= 0) {
            return false;
        }
        EdgeCursor rowEdgeCursor = null;
        EdgeCursor columnEdgeCursor = null;
        EdgeCursor pageEdgeCursor = null;
        List columnDimList = null;
        List rowDimList = null;
        List pageDimList = null;
        if (this.view.getRowEdgeView() != null && (rowEdgeCursor = this.view.getRowEdgeView().getEdgeCursor()) != null) {
            rowDimList = rowEdgeCursor.getDimensionCursor();
        }
        if (this.view.getColumnEdgeView() != null && (columnEdgeCursor = this.view.getColumnEdgeView().getEdgeCursor()) != null) {
            columnDimList = columnEdgeCursor.getDimensionCursor();
        }
        if (this.view.getPageEdgeView() != null && (pageEdgeCursor = this.view.getPageEdgeView().getEdgeCursor()) != null) {
            pageDimList = pageEdgeCursor.getDimensionCursor();
        }
        CalculatedMember member = this.view.getMeasureNameManger().getCalculatedMember(aggrName);
        List memberList = member.getCubeAggrDefn().getAggrLevelsInAggregationResult();
        Relationship relation = (Relationship)this.relationMap.get(aggrName);
        List pageLevelList = relation.getLevelListOnPage();
        List columnLevelList = relation.getLevelListOnColumn();
        List rowLevelList = relation.getLevelListOnRow();
        HashMap<DimLevel, Object> valueMap = new HashMap<DimLevel, Object>();
        int index = 0;
        while (index < pageLevelList.size()) {
            level = (DimLevel)pageLevelList.get(index);
            cursor = (DimensionCursor)pageDimList.get(index);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++index;
        }
        int i = 0;
        while (i < columnLevelList.size()) {
            level = (DimLevel)columnLevelList.get(i);
            cursor = (DimensionCursor)columnDimList.get(i);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        i = 0;
        while (i < rowLevelList.size()) {
            level = (DimLevel)rowLevelList.get(i);
            cursor = (DimensionCursor)rowDimList.get(i);
            value = cursor.getObject(level.getLevelName());
            valueMap.put(level, value);
            ++i;
        }
        if (columnLevelList.isEmpty() && rowLevelList.isEmpty() && pageLevelList.isEmpty()) {
            return true;
        }
        if (Arrays.deepEquals(rs.getAllLevels(), member.getCubeAggrDefn().getAggrLevelsInDefinition().toArray())) {
            return this.findValueMatcher(rs, memberList, valueMap, aggrIndex);
        }
        return this.findValueMatcherOneByOne(rs, memberList, valueMap, aggrIndex);
    }

    /*
     * Unable to fully structure code
     */
    private boolean findValueMatcherOneByOne(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) throws IOException {
        position = 0;
        if (rs.length() > 0 && !levelList.isEmpty()) ** GOTO lbl18
        return true;
lbl-1000:
        // 1 sources

        {
            rs.seek(position);
            match = true;
            i = 0;
            while (i < levelList.size()) {
                level = (DimLevel)levelList.get(i);
                value1 = valueMap.get(level);
                if (!value1.equals(value2 = rs.getLevelKeyValue(rs.getLevelIndex(level))[rs.getLevelKeyColCount(rs.getLevelIndex(level)) - 1])) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (match) {
                return true;
            }
            ++position;
lbl18:
            // 2 sources

            ** while (position < rs.length())
        }
lbl19:
        // 1 sources

        return false;
    }

    private boolean findValueMatcher(IAggregationResultSet rs, List levelList, Map valueMap, int aggrIndex) {
        if (levelList.isEmpty()) {
            return true;
        }
        int start = 0;
        int state = 0;
        boolean find = false;
        this.currentPosition[aggrIndex] = rs.getPosition();
        while (start < levelList.size()) {
            int direction;
            int sortType;
            DimLevel level = (DimLevel)levelList.get(start);
            Object value1 = valueMap.get(level);
            Object value2 = rs.getLevelKeyValue(rs.getLevelIndex(level))[rs.getLevelKeyColCount(rs.getLevelIndex(level)) - 1];
            int n = sortType = rs.getSortType(rs.getLevelIndex(level)) == 1 ? -1 : 1;
            int n2 = sortType * ((Comparable)value1).compareTo(value2) < 0 ? -1 : (direction = ((Comparable)value1).compareTo(value2) == 0 ? 0 : 1);
            if (direction < 0 && this.currentPosition[aggrIndex] > 0 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n3 = aggrIndex;
                    int n4 = this.currentPosition[n3] - 1;
                    this.currentPosition[n3] = n4;
                    rs.seek(n4);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction > 0 && this.currentPosition[aggrIndex] < rs.length() - 1 && (state == 0 || state == direction)) {
                state = direction;
                try {
                    int n5 = aggrIndex;
                    int n6 = this.currentPosition[n5] + 1;
                    this.currentPosition[n5] = n6;
                    rs.seek(n6);
                }
                catch (IOException iOException) {
                    find = false;
                }
                start = 0;
                continue;
            }
            if (direction == 0) {
                if (start == levelList.size() - 1) {
                    find = true;
                    break;
                }
                ++start;
                continue;
            }
            if (this.currentPosition[aggrIndex] < 0 || this.currentPosition[aggrIndex] >= rs.length()) {
                return false;
            }
            return false;
        }
        return find;
    }

    public void close() throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return;
        }
        ArrayList<IOException> errorList = new ArrayList<IOException>();
        int i = 0;
        while (i < this.resultSet.getMeasureResult().length) {
            try {
                this.resultSet.getMeasureResult()[i].getQueryResultSet().close();
            }
            catch (IOException e) {
                errorList.add(e);
            }
            ++i;
        }
        if (!errorList.isEmpty()) {
            throw new OLAPException(((IOException)errorList.get(0)).getLocalizedMessage());
        }
    }

    public BigDecimal getBigDecimal(int arg0) throws OLAPException {
        return null;
    }

    public BigDecimal getBigDecimal(String arg0) throws OLAPException {
        return null;
    }

    public Blob getBlob(int arg0) throws OLAPException {
        return null;
    }

    public Blob getBlob(String arg0) throws OLAPException {
        return null;
    }

    public boolean getBoolean(int arg0) throws OLAPException {
        return false;
    }

    public boolean getBoolean(String arg0) throws OLAPException {
        return false;
    }

    public Date getDate(int arg0) throws OLAPException {
        return null;
    }

    public Date getDate(String arg0) throws OLAPException {
        return null;
    }

    public Date getDate(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Date getDate(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public double getDouble(int arg0) throws OLAPException {
        return 0.0;
    }

    public double getDouble(String arg0) throws OLAPException {
        return 0.0;
    }

    public float getFloat(int arg0) throws OLAPException {
        return 0.0f;
    }

    public float getFloat(String arg0) throws OLAPException {
        return 0.0f;
    }

    public int getInt(int arg0) throws OLAPException {
        return 0;
    }

    public int getInt(String arg0) throws OLAPException {
        return 0;
    }

    public long getLong(int arg0) throws OLAPException {
        return 0L;
    }

    public long getLong(String arg0) throws OLAPException {
        return 0L;
    }

    public RowDataMetaData getMetaData() throws OLAPException {
        return null;
    }

    public Object getObject(int arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            String aggrName = this.view.getMeasureNameManger().getAggrName(arg0);
            int index = this.view.getMeasureNameManger().getAggregationIndex(aggrName);
            int id = this.view.getMeasureNameManger().getAggregationResultID(aggrName);
            if (this.populateRelation(index, aggrName)) {
                return this.resultSet.getMeasureResult()[id].getQueryResultSet().getAggregationValue(index);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public Object getObject(String arg0) throws OLAPException {
        if (this.resultSet == null || this.resultSet.getMeasureResult() == null) {
            return null;
        }
        try {
            int id = this.view.getMeasureNameManger().getAggregationResultID(arg0);
            int index = this.view.getMeasureNameManger().getAggregationIndex(arg0);
            if (this.populateRelation(id, arg0)) {
                return this.resultSet.getMeasureResult()[id].getQueryResultSet().getAggregationValue(index);
            }
            return null;
        }
        catch (IOException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
        catch (DataException e) {
            throw new OLAPException(e.getLocalizedMessage());
        }
    }

    public Object getObject(int arg0, Map arg1) throws OLAPException {
        return null;
    }

    public Object getObject(String arg0, Map arg1) throws OLAPException {
        return null;
    }

    public String getString(int arg0) throws OLAPException {
        return null;
    }

    public String getString(String arg0) throws OLAPException {
        return null;
    }

    public Time getTime(int arg0) throws OLAPException {
        return null;
    }

    public Time getTime(String arg0) throws OLAPException {
        return null;
    }

    public Time getTime(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Time getTime(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(int arg0) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(String arg0) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    public Timestamp getTimestamp(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }
}

