/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRowComparator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.BaseAggregationCalculator;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.FacttableRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.SortedAggregationRowArray;
import org.eclipse.birt.data.engine.olap.data.util.BufferedStructureArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;

public class SimpleFunctionCalculator
extends BaseAggregationCalculator {
    SimpleFunctionCalculator(AggregationDefinition aggregation, IAggregationResultSet aggrResultSet) throws DataException, IOException {
        super(aggregation, aggrResultSet);
        this.keyLevelIndex = (int[])(aggregation.getLevels() != null ? this.getKeyLevelIndexs(aggregation.getLevels()) : null);
        this.facttableRow = new FacttableRow(this.getMeasureInfo(), null, null);
    }

    public IAggregationResultSet execute(StopSign stopSign) throws IOException, DataException {
        int i;
        AggregationResultRowComparator comparator = null;
        if (this.keyLevelIndex != null) {
            comparator = new AggregationResultRowComparator(this.keyLevelIndex);
        }
        SortedAggregationRowArray sortedRows = new SortedAggregationRowArray(this.aggrResultSet, this.aggregation.getLevels());
        BufferedStructureArray result = new BufferedStructureArray(AggregationResultRow.getCreator(), 4000);
        if (this.aggrResultSet.length() <= 0) {
            return this.getAggregationResultSet(result);
        }
        IAggregationResultRow lastRow = sortedRows.get(0);
        IAggregationResultRow currentRow = null;
        AggregationResultRow resultRow = this.newAggregationResultRow(lastRow);
        if (this.accumulators != null) {
            i = 0;
            while (i < this.accumulators.length) {
                this.accumulators[i].start();
                ++i;
            }
        }
        this.onRow(lastRow);
        i = 1;
        while (!stopSign.isStopped() && i < sortedRows.size()) {
            currentRow = sortedRows.get(i);
            if (comparator != null && comparator.compare(currentRow, lastRow) != 0) {
                if (this.accumulators != null) {
                    int j = 0;
                    while (j < this.accumulators.length) {
                        this.accumulators[j].finish();
                        resultRow.getAggregationValues()[j] = this.accumulators[j].getValue();
                        this.accumulators[j].start();
                        ++j;
                    }
                }
                result.add(resultRow);
                resultRow = this.newAggregationResultRow(currentRow);
            }
            this.onRow(currentRow);
            lastRow = currentRow;
            ++i;
        }
        if (this.accumulators != null) {
            int j = 0;
            while (j < this.accumulators.length) {
                this.accumulators[j].finish();
                resultRow.getAggregationValues()[j] = this.accumulators[j].getValue();
                ++j;
            }
        }
        result.add(resultRow);
        return this.getAggregationResultSet(result);
    }

    private IAggregationResultSet getAggregationResultSet(IDiskArray result) throws IOException {
        return new AggregationResultSet(this.aggregation, result, this.getKeyNames(), this.getAttributeNames());
    }
}

