/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBasePreparedQuery;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.data.dte.ResultSetIndex;
import org.eclipse.birt.report.engine.executor.EngineExtensionManager;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.engine.IDataExtension;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataInteractiveEngine
extends AbstractDataEngine {
    private DataOutputStream dos;
    protected ResultSetIndex rsetIndex = new ResultSetIndex();
    protected IBaseResultSet[] reportletResults;

    public DataInteractiveEngine(ExecutionContext context, IDocArchiveReader reader, IDocArchiveWriter writer) throws Exception {
        super(context);
        DataSessionContext dteSessionContext = new DataSessionContext(4, null, context.getScriptContext(), context.getApplicationClassLoader());
        dteSessionContext.setDocumentReader(reader);
        dteSessionContext.setDocumentWriter(writer);
        DataEngineContext dteEngineContext = dteSessionContext.getDataEngineContext();
        dteEngineContext.setLocale(context.getLocale());
        dteEngineContext.setTimeZone(context.getTimeZone());
        String tempDir = this.getTempDir(context);
        if (tempDir != null) {
            dteEngineContext.setTmpdir(tempDir);
        }
        this.dteSession = DataRequestSession.newSession((DataSessionContext)dteSessionContext);
        this.loadDteMetaInfo(reader);
        if (writer != null && this.dos == null) {
            this.dos = new DataOutputStream((OutputStream)writer.createRandomAccessStream("/Data/snap_hierarchy"));
            DteMetaInfoIOUtil.startMetaInfo(this.dos);
        }
    }

    private void storeDteMetaInfo(String pRsetId, String rowId, String queryId, String rsetId) {
        if (this.dos != null) {
            try {
                if (this.context.isExecutingMasterPage() && pRsetId == null) {
                    rowId = "-1";
                }
                DteMetaInfoIOUtil.storeMetaInfo(this.dos, pRsetId, rowId, queryId, rsetId);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage());
            }
        }
    }

    private void loadDteMetaInfo(IDocArchiveReader reader) throws IOException {
        ArrayList result = DteMetaInfoIOUtil.loadAllDteMetaInfo(reader);
        if (result != null) {
            int i = 0;
            while (i < result.size()) {
                String[] rsetRelation = (String[])result.get(i);
                String pRsetId = rsetRelation[0];
                String rowId = rsetRelation[1];
                String queryId = rsetRelation[2];
                String rsetId = rsetRelation[3];
                this.addResultSetRelation(pRsetId, rowId, queryId, rsetId);
                ++i;
            }
        }
    }

    private void addResultSetRelation(String pRsetId, String rowId, String queryId, String rsetId) {
        this.rsetIndex.addResultSet(queryId, pRsetId, rowId, rsetId);
    }

    protected String getResultID(String pRsetId, String rowId, String queryId) {
        return this.rsetIndex.getResultSet(queryId, pRsetId, rowId);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.appContext = appContext;
        this.queryIDMap.putAll(report.getQueryIDs());
    }

    protected IBaseResultSet doExecuteQuery(IBaseResultSet parentResult, IQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        String resultSetID;
        String queryID = (String)this.queryIDMap.get(query);
        IBaseQueryResults parentQueryResults = null;
        if (parentResult != null) {
            parentQueryResults = parentResult.getQueryResults();
        }
        if ((resultSetID = this.loadResultSetID(parentResult, queryID)) == null) {
            throw new EngineException("Error.ReportQueryLoadingError", query.getClass().getName());
        }
        ((QueryDefinition)query).setQueryResultsID(resultSetID);
        this.processQueryExtensions((IDataQueryDefinition)query);
        IPreparedQuery pQuery = this.dteSession.prepare(query, null);
        Scriptable scope = this.context.getSharedScope();
        String pRsetId = null;
        String rowId = "-1";
        IBaseQueryResults dteResults = null;
        QueryResultSet resultSet = null;
        boolean needExecute = this.queryCache.needExecute(query, queryOwner, useCache);
        if (parentQueryResults == null) {
            if (!needExecute) {
                dteResults = this.getCachedQueryResult((IBaseQueryDefinition)query, parentResult);
            }
            if (dteResults == null) {
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
                this.putCachedQueryResult((IBaseQueryDefinition)query, dteResults.getID());
            }
            resultSet = new QueryResultSet(this, this.context, query, (IQueryResults)dteResults);
        } else {
            pRsetId = parentResult instanceof QueryResultSet ? ((QueryResultSet)parentResult).getQueryResultsID() : ((CubeResultSet)parentResult).getQueryResultsID();
            rowId = parentResult.getRawID();
            if (!needExecute) {
                dteResults = this.getCachedQueryResult((IBaseQueryDefinition)query, parentResult);
            }
            if (dteResults == null) {
                dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, scope);
                this.putCachedQueryResult((IBaseQueryDefinition)query, dteResults.getID());
            }
            resultSet = new QueryResultSet(this, this.context, parentResult, query, (IQueryResults)dteResults);
        }
        resultSet.setBaseRSetID(resultSetID);
        this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
        return resultSet;
    }

    protected void processQueryExtensions(IDataQueryDefinition query) throws EngineException {
        String[] extensions = this.context.getEngineExtensions();
        if (extensions != null) {
            EngineExtensionManager manager = this.context.getEngineExtensionManager();
            String[] stringArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionName = stringArray[n2];
                IDataExtension extension = manager.getDataExtension(extensionName);
                if (extension != null) {
                    extension.prepareQuery(query);
                }
                ++n2;
            }
        }
    }

    protected IBaseResultSet doExecuteCube(IBaseResultSet parentResult, ICubeQueryDefinition query, Object queryOwner, boolean useCache) throws BirtException {
        IBaseQueryResults dteResults;
        String resultSetID;
        String queryID = (String)this.queryIDMap.get(query);
        IBaseQueryResults parentQueryResults = null;
        if (parentResult != null) {
            parentQueryResults = parentResult.getQueryResults();
        }
        if ((resultSetID = this.loadResultSetID(parentResult, queryID)) == null) {
            throw new EngineException("Error.ReportQueryLoadingError", queryID);
        }
        if (useCache) {
            String rsetId = String.valueOf(this.cachedQueryToResults.get(query));
            query.setQueryResultsID(rsetId);
        } else {
            query.setQueryResultsID(null);
        }
        query.setQueryResultsID(resultSetID);
        IPreparedCubeQuery pQuery = this.dteSession.prepare(query, this.appContext);
        Scriptable scope = this.context.getSharedScope();
        String pRsetId = null;
        String rowId = "-1";
        CubeResultSet resultSet = null;
        if (parentQueryResults == null) {
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, null, scope);
            resultSet = new CubeResultSet(this, this.context, query, (ICubeQueryResults)dteResults);
        } else {
            pRsetId = parentResult.getQueryResults().getID();
            rowId = parentResult.getRawID();
            dteResults = this.dteSession.execute((IBasePreparedQuery)pQuery, parentQueryResults, scope);
            resultSet = new CubeResultSet((IDataEngine)this, this.context, parentResult, query, (ICubeQueryResults)dteResults);
        }
        this.storeDteMetaInfo(pRsetId, rowId, queryID, dteResults.getID());
        if (query.cacheQueryResults()) {
            this.cachedQueryToResults.put(query, dteResults.getID());
        }
        return resultSet;
    }

    private String loadResultSetID(IBaseResultSet parentResult, String queryID) throws BirtException {
        String resultSetID = null;
        if (parentResult == null) {
            if (this.context.isExecutingMasterPage()) {
                long pageNumber;
                resultSetID = this.getResultID(null, "-1", queryID);
                if (resultSetID == null && (resultSetID = this.getResultID(null, String.valueOf(pageNumber = this.context.getPageNumber()), queryID)) == null) {
                    resultSetID = this.getResultID(null, "1", queryID);
                }
            } else {
                resultSetID = this.getResultID(null, "-1", queryID);
            }
        } else {
            String pRsetId = parentResult instanceof QueryResultSet ? ((QueryResultSet)parentResult).getQueryResultsID() : ((CubeResultSet)parentResult).getQueryResultsID();
            String rowid = parentResult.getRawID();
            resultSetID = this.getResultID(pRsetId, rowid, queryID);
        }
        return resultSetID;
    }

    public void shutdown() {
        if (this.dos != null) {
            try {
                this.dos.close();
            }
            catch (IOException iOException) {}
            this.dos = null;
        }
        this.dteSession.shutdown();
    }
}

