/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;

public class QueryResultSet
implements IQueryResultSet {
    protected IBaseResultSet parent;
    protected DataSetID id;
    protected long rowId = -1L;
    protected IResultIterator rs = null;
    protected long[] rowIdOfGroups;
    protected IDataEngine dataEngine = null;
    private ExecutionContext context;
    private IBaseQueryDefinition queryDefn;
    private IQueryResults queryResults;
    private static IResultMetaData emptyResultMetaData = new EmptyResultMetaData();
    private String queryResultsID;
    protected static Logger logger = Logger.getLogger(QueryResultSet.class.getName());
    String baseRSetID;

    protected QueryResultSet() {
    }

    public QueryResultSet(IDataEngine dataEngine, ExecutionContext context, IQueryDefinition queryDefn, IQueryResults rsets) throws BirtException {
        this.parent = null;
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.id = new DataSetID(rsets.getID());
        this.rs = rsets.getResultIterator();
        this.queryResults = rsets;
        this.queryResultsID = rsets.getID();
        this.initializeRowIdOfGroups(this.getGroupCount());
    }

    public QueryResultSet(IDataEngine dataEngine, ExecutionContext context, IBaseResultSet parent, IQueryDefinition queryDefn, IQueryResults rsets) throws BirtException {
        assert (parent != null);
        this.parent = parent;
        this.id = new DataSetID(rsets.getID());
        this.context = context;
        this.dataEngine = dataEngine;
        this.queryDefn = queryDefn;
        this.rs = rsets.getResultIterator();
        this.queryResults = rsets;
        this.queryResultsID = rsets.getID();
        this.initializeRowIdOfGroups(this.getGroupCount());
    }

    public QueryResultSet(QueryResultSet parent, ISubqueryDefinition queryDefn, IResultIterator ri) {
        assert (parent != null);
        assert (queryDefn != null);
        this.parent = parent;
        this.id = new DataSetID(parent.getID(), parent.getRowIndex(), queryDefn.getName());
        this.context = parent.context;
        this.dataEngine = parent.dataEngine;
        this.queryDefn = queryDefn;
        this.rs = ri;
        this.queryResults = this.rs.getQueryResults();
        this.queryResultsID = "S" + queryDefn.getName() + this.queryResults.getID();
        this.initializeRowIdOfGroups(queryDefn.getGroups().size());
    }

    public String getQueryResultsID() {
        return this.queryResultsID;
    }

    private void initializeRowIdOfGroups(int groupCount) {
        this.rowIdOfGroups = new long[groupCount + 2];
    }

    private int getGroupCount() {
        if (this.queryDefn instanceof IQueryDefinition) {
            List groups = ((IQueryDefinition)this.queryDefn).getGroups();
            assert (groups != null);
            return groups.size();
        }
        return 0;
    }

    public IBaseQueryResults getQueryResults() {
        return this.queryResults;
    }

    public IResultIterator getResultIterator() {
        return this.rs;
    }

    public long getRowIndex() {
        return this.rowId;
    }

    public boolean next() throws BirtException {
        boolean flag;
        boolean bl = flag = this.rs == null ? false : this.rs.next();
        if (flag) {
            ++this.rowId;
            this.updateRowIdOfGroups();
        }
        return flag;
    }

    private void updateRowIdOfGroups() {
        try {
            int startingGroup;
            int i = startingGroup = this.rs.getStartingGroupLevel();
            while (i < this.rowIdOfGroups.length) {
                this.rowIdOfGroups[i] = this.rowId;
                ++i;
            }
        }
        catch (BirtException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public boolean skipTo(long rowIndex) throws BirtException {
        if (this.rs == null) {
            return false;
        }
        long oldRowId = this.rowId;
        this.rs.moveTo((int)rowIndex);
        this.rowId = rowIndex;
        this.updateRowIdOfGroupsAfterSkip(oldRowId);
        return true;
    }

    private void updateRowIdOfGroupsAfterSkip(long oldRowId) {
        long incremetal = this.rowId - oldRowId;
        if (incremetal == 1L) {
            this.updateRowIdOfGroups();
        } else if (incremetal > 1L) {
            this.resetRowIdOfGroups();
        }
    }

    private void resetRowIdOfGroups() {
        int i = 0;
        while (i < this.rowIdOfGroups.length) {
            this.rowIdOfGroups[i] = this.rowId;
            ++i;
        }
    }

    public String getGroupId(int groupLevel) {
        return String.valueOf(String.valueOf(groupLevel)) + "." + this.getRowId(groupLevel);
    }

    private String getRowId(int groupLevel) {
        assert (this.rowIdOfGroups.length > 0);
        int level = groupLevel >= this.rowIdOfGroups.length ? this.rowIdOfGroups.length - 1 : groupLevel;
        level = groupLevel < 0 ? 0 : groupLevel;
        return String.valueOf(this.rowIdOfGroups[level]);
    }

    public void setBaseRSetID(String id) {
        this.baseRSetID = id;
    }

    public String getBaseRSetID() {
        if (this.baseRSetID == null && this.parent instanceof QueryResultSet) {
            return ((QueryResultSet)this.parent).getBaseRSetID();
        }
        return this.baseRSetID;
    }

    public void close() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        try {
            if (this.queryResults != null) {
                this.queryResults.close();
            }
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public Object evaluate(String expr) throws BirtException {
        IBaseResultSet oldRSet = this.context.getResultSet();
        if (oldRSet != this) {
            this.context.setResultSet(this);
        }
        Object result = this.context.evaluate(expr);
        if (oldRSet != this) {
            this.context.setResultSet(oldRSet);
        }
        return result;
    }

    public Object evaluate(IBaseExpression expr) throws BirtException {
        IBaseResultSet oldRSet = this.context.getResultSet();
        if (oldRSet != this) {
            this.context.setResultSet(this);
        }
        Object result = null;
        if (expr instanceof IScriptExpression) {
            result = this.context.evaluate(((IScriptExpression)expr).getText());
        } else if (expr instanceof IConditionalExpression) {
            result = this.context.evaluateCondExpr((IConditionalExpression)expr);
        }
        if (oldRSet != this) {
            this.context.setResultSet(oldRSet);
        }
        return result;
    }

    public DataSetID getID() {
        return this.id;
    }

    public IBaseResultSet getParent() {
        return this.parent;
    }

    public String getRawID() throws BirtException {
        return String.valueOf(this.rs.getRowId());
    }

    public int getType() {
        return 0;
    }

    public Object getValue(String column) throws BirtException {
        return this.rs.getValue(column);
    }

    public int getEndingGroupLevel() throws BirtException {
        return this.rs.getEndingGroupLevel();
    }

    public int getStartingGroupLevel() throws BirtException {
        return this.rs.getStartingGroupLevel();
    }

    public Boolean getBoolean(String name) throws BirtException {
        return this.rs.getBoolean(name);
    }

    public Integer getInteger(String name) throws BirtException {
        return this.rs.getInteger(name);
    }

    public Double getDouble(String name) throws BirtException {
        return this.rs.getDouble(name);
    }

    public String getString(String name) throws BirtException {
        return this.rs.getString(name);
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return this.rs.getBigDecimal(name);
    }

    public Date getDate(String name) throws BirtException {
        return this.rs.getDate(name);
    }

    public Blob getBlob(String name) throws BirtException {
        return this.rs.getBlob(name);
    }

    public byte[] getBytes(String name) throws BirtException {
        return this.rs.getBytes(name);
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        if (this.rs == null) {
            return emptyResultMetaData;
        }
        return this.rs.getResultMetaData();
    }

    public boolean isEmpty() throws BirtException {
        if (this.rs == null) {
            return true;
        }
        return this.rs.isEmpty();
    }

    public boolean isFirst() throws BirtException {
        if (this.rs == null) {
            return false;
        }
        return this.rs.isFirst();
    }

    public boolean isBeforeFirst() throws BirtException {
        if (this.rs == null) {
            return false;
        }
        return this.rs.isBeforeFirst();
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    private static class EmptyResultMetaData
    implements IResultMetaData {
        private EmptyResultMetaData() {
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int index) throws BirtException {
            return null;
        }

        public String getColumnAlias(int index) throws BirtException {
            return null;
        }

        public int getColumnType(int index) throws BirtException {
            return 0;
        }

        public String getColumnTypeName(int index) throws BirtException {
            return null;
        }

        public String getColumnNativeTypeName(int index) throws BirtException {
            return null;
        }

        public String getColumnLabel(int index) throws BirtException {
            return null;
        }

        public boolean isComputedColumn(int index) throws BirtException {
            return false;
        }
    }
}

