/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.PageContent;
import org.eclipse.birt.report.engine.emitter.ContentEmitterAdapter;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.IAreaVisitor;
import org.eclipse.birt.report.engine.layout.area.IContainerArea;
import org.eclipse.birt.report.engine.layout.area.IImageArea;
import org.eclipse.birt.report.engine.layout.area.ITemplateArea;
import org.eclipse.birt.report.engine.layout.area.ITextArea;
import org.eclipse.birt.report.engine.script.internal.OnPageBreakScriptVisitor;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;

public class OnPageBreakLayoutPageHandle
implements ILayoutPageHandler {
    protected ExecutionContext executionContext;
    protected IContentEmitter emitter;
    protected PageContent pageContent;
    protected boolean bufferAllContents;
    protected ArrayList<IContent> contents;

    public OnPageBreakLayoutPageHandle(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.emitter = new PageContentBuilder();
        this.contents = new ArrayList();
    }

    public IContentEmitter getEmitter() {
        return this.emitter;
    }

    private void initPageBuffer(PageContent pageContent) {
        MasterPageDesign pageDesign = (MasterPageDesign)pageContent.getGenerateBy();
        this.bufferAllContents = pageDesign.getOnPageStart() != null || pageDesign.getOnPageEnd() != null;
        this.contents.clear();
        this.pageContent = pageContent;
    }

    private ReportItemDesign getGenerateDesign(IContent content) {
        Object design = content.getGenerateBy();
        if (design instanceof ReportItemDesign) {
            return (ReportItemDesign)design;
        }
        if (design instanceof ReportItemHandle) {
            IReportContent reportContent = content.getReportContent();
            Report reportDesign = reportContent.getDesign();
            return reportDesign.findDesign((ReportElementHandle)((ReportItemHandle)design));
        }
        return null;
    }

    private void addContent(IContent content) {
        if (!this.bufferAllContents) {
            ReportItemDesign design = this.getGenerateDesign(content);
            if (design.getOnPageBreak() != null) {
                this.contents.add(content);
            }
        } else {
            this.contents.add(content);
        }
    }

    public void onPage(long page, Object context) {
        if (this.executionContext == null || this.pageContent == null) {
            return;
        }
        Report report = this.executionContext.getReport();
        OnPageBreakScriptVisitor onPageBreakVisitor = new OnPageBreakScriptVisitor(this.executionContext);
        onPageBreakVisitor.onPageStart(report, this.pageContent, this.contents);
        onPageBreakVisitor.onPageStart(this.pageContent, this.contents);
        for (IContent content : this.contents) {
            onPageBreakVisitor.onPageBreak(content);
        }
        onPageBreakVisitor.onPageEnd(this.pageContent, this.contents);
        onPageBreakVisitor.onPageEnd(report, this.pageContent, this.contents);
        this.contents.clear();
        this.pageContent = null;
    }

    private class PageBreakContentCollector
    implements IAreaVisitor {
        private PageBreakContentCollector() {
        }

        public void visitText(ITextArea textArea) {
            OnPageBreakLayoutPageHandle.this.addContent(textArea.getContent());
        }

        public void visitAutoText(ITemplateArea templateArea) {
            OnPageBreakLayoutPageHandle.this.addContent(templateArea.getContent());
        }

        public void visitImage(IImageArea imageArea) {
            OnPageBreakLayoutPageHandle.this.addContent(imageArea.getContent());
        }

        public void visitContainer(IContainerArea container) {
            OnPageBreakLayoutPageHandle.this.addContent(container.getContent());
            Iterator iter = container.getChildren();
            while (iter.hasNext()) {
                IArea child = (IArea)iter.next();
                child.accept(this);
            }
        }
    }

    private class PageContentBuilder
    extends ContentEmitterAdapter {
        private PageContentBuilder() {
        }

        public void startPage(IPageContent pageContent) throws BirtException {
            OnPageBreakLayoutPageHandle.this.initPageBuffer((PageContent)pageContent);
        }

        public void startContent(IContent content) throws BirtException {
            OnPageBreakLayoutPageHandle.this.contents.add(content);
        }
    }
}

