/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.data.dte.BlankResultSet;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IExecutorContext;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v3.CachedReportContentReaderV3;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.model.api.ReportElementHandle;

public abstract class ReportItemExecutor
implements IReportItemExecutor {
    protected static Logger logger = Logger.getLogger(ReportItemExecutor.class.getName());
    protected ExecutorManager manager;
    protected int executorType;
    protected CachedReportContentReaderV3 reader;
    protected IReportContent report;
    protected ExecutionContext context;
    protected ReportItemExecutor parent;
    protected Object designHandle;
    protected ReportItemDesign design;
    protected InstanceID instanceId;
    protected IContent content;
    protected long offset;
    protected Fragment fragment;
    protected IBaseResultSet[] rsets;
    protected boolean rsetEmpty;
    protected boolean executed;
    protected long uniqueId;
    protected IBaseResultSet[] parentRsets;

    protected ReportItemExecutor(ExecutorManager manager, int type) {
        this.manager = manager;
        this.executorType = type;
        this.context = manager.getExecutionContext();
        this.reader = manager.getReportReader();
        this.report = this.context.getReportContent();
        this.parent = null;
        this.design = null;
        this.offset = -1L;
        this.fragment = null;
        this.rsets = null;
        this.rsetEmpty = true;
        this.executed = false;
        this.content = null;
        this.instanceId = null;
        this.uniqueId = 0L;
        this.parentRsets = null;
    }

    int getExecutorType() {
        return this.executorType;
    }

    public void setParent(IReportItemExecutor parent) {
        this.parent = (ReportItemExecutor)parent;
        if (parent != null) {
            this.reader = this.parent.reader;
        }
    }

    public IReportItemExecutor getParent() {
        return this.parent;
    }

    public IExecutorContext getContext() {
        throw new UnsupportedOperationException();
    }

    public Object getModelObject() {
        return this.design;
    }

    public void setContext(IExecutorContext context) {
        throw new IllegalStateException("should never call setContext for system executor");
    }

    public void setModelObject(Object handle) {
        this.designHandle = handle;
        if (handle instanceof ReportElementHandle) {
            this.design = this.report.getDesign().findDesign((ReportElementHandle)handle);
            this.context.setItemDesign(this.design);
        }
    }

    void setDesign(ReportItemDesign design) {
        this.design = design;
    }

    ReportItemDesign getDesign() {
        return this.design;
    }

    public IContent getContent() {
        return this.content;
    }

    void setOffset(long offset) {
        this.offset = offset;
    }

    void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    Fragment getFragment() {
        return this.fragment;
    }

    protected IContent doCreateContent() {
        long id = this.design == null ? -1L : this.design.getID();
        throw new IllegalStateException("can't re-generate content for design " + id);
    }

    protected void doExecute() throws Exception {
    }

    protected IContent getParentContent() {
        while (this.parent != null) {
            IContent content = this.parent.getContent();
            if (content != null) {
                return content;
            }
            this.parent = this.parent.parent;
        }
        return null;
    }

    public IContent execute() {
        if (!this.executed) {
            this.executed = true;
            try {
                InstanceID instanceId = this.getInstanceID();
                if (this.offset != -1L) {
                    this.content = this.reader.loadContent(this.offset);
                    InstanceID id = this.content.getInstanceID();
                    if (!this.isSameInstance(instanceId, id)) {
                        this.content = this.doCreateContent();
                        this.content.setInstanceID(instanceId);
                    }
                } else {
                    this.content = this.doCreateContent();
                }
                this.content.setGenerateBy(this.design);
                this.content.setInstanceID(instanceId);
                IContent pContent = this.getParentContent();
                if (pContent != null) {
                    this.content.setParent(pContent);
                }
                this.doExecute();
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                this.context.addException(this.getDesign(), (BirtException)new EngineException(ex.getLocalizedMessage(), ex));
            }
        }
        return this.content;
    }

    public boolean hasNextChild() {
        return false;
    }

    public IReportItemExecutor getNextChild() {
        return null;
    }

    public IBaseResultSet[] getQueryResults() {
        return this.rsets;
    }

    public void close() {
        if (this.offset != -1L) {
            this.reader.unloadContent(this.offset);
            this.offset = -1L;
        }
        this.parent = null;
        this.reader = null;
        this.design = null;
        this.fragment = null;
        this.rsets = null;
        this.rsetEmpty = true;
        this.executed = false;
        this.content = null;
        this.instanceId = null;
        this.uniqueId = 0L;
        this.parentRsets = null;
        if (this.executorType != -1) {
            this.manager.releaseExecutor(this);
        }
    }

    protected void closeQuery() {
        if (this.rsets != null) {
            int i = 0;
            while (i < this.rsets.length) {
                if (this.rsets[i] != null) {
                    this.rsets[i].close();
                }
                ++i;
            }
            this.rsets = null;
            this.context.setResultSets(this.parentRsets);
        }
    }

    protected void executeQuery() {
        this.getParentResultSet();
        if (this.design != null) {
            IDataQueryDefinition[] queries = this.design.getQueries();
            boolean useCache = this.design.useCachedResult();
            if (queries != null) {
                this.rsets = new IBaseResultSet[queries.length];
                try {
                    this.context.getProgressMonitor().onProgress(5, (int)this.design.getID());
                    IBaseResultSet prset = this.restoreParentResultSet();
                    int i = 0;
                    while (i < queries.length) {
                        this.rsets[i] = this.context.executeQuery(prset, queries[i], this.design.getHandle(), useCache);
                        ++i;
                    }
                    this.context.setResultSets(this.rsets);
                    this.context.getProgressMonitor().onProgress(6, (int)this.design.getID());
                    this.rsetEmpty = true;
                    if (this.rsets[0] != null && this.rsets[0] instanceof IQueryResultSet) {
                        this.rsetEmpty = !((IQueryResultSet)this.rsets[0]).next();
                    }
                }
                catch (BirtException ex) {
                    this.context.addException(this.getDesign(), ex);
                }
            }
        }
    }

    protected void createQueryForShowIfBlank() {
        IBaseResultSet[] blankRsets = new IBaseResultSet[]{new BlankResultSet((IQueryResultSet)this.rsets[0])};
        this.rsets = blankRsets;
        this.context.setResultSets(this.rsets);
        this.rsetEmpty = false;
    }

    IBaseResultSet getResultSet() {
        if (this.rsets != null && this.rsets.length != 0) {
            return this.rsets[0];
        }
        return null;
    }

    IBaseResultSet restoreParentResultSet() throws BirtException {
        ReportItemExecutor pExecutor = this.parent;
        DataID dataId = this.getContent().getInstanceID().getDataID();
        while (pExecutor != null) {
            IBaseResultSet[] rsets;
            InstanceID pIID;
            IContent pContent;
            if (dataId == null && (pContent = pExecutor.getContent()) != null && (pIID = pContent.getInstanceID()) != null) {
                dataId = pIID.getDataID();
            }
            if ((rsets = pExecutor.getQueryResults()) != null) {
                if (rsets.length > 0) {
                    IBaseResultSet rset = rsets[0];
                    if (dataId != null && rset instanceof ICubeResultSet) {
                        ICubeResultSet cset = (ICubeResultSet)rset;
                        String cellId = dataId.getCellID();
                        if (cellId != null) {
                            cset.skipTo(dataId.getCellID());
                        }
                    }
                    return rset;
                }
                return null;
            }
            pExecutor = pExecutor.parent;
        }
        return null;
    }

    long getUniqueID() {
        if (this.parent != null) {
            return this.parent.uniqueId++;
        }
        return this.manager.generateUniqueID();
    }

    protected DataID getDataID() {
        IBaseResultSet[] rsets;
        if (this.parent != null && (rsets = this.parent.getQueryResults()) != null && rsets.length > 0 && rsets[0] != null) {
            if (rsets[0] instanceof IQueryResultSet) {
                IQueryResultSet rset = (IQueryResultSet)rsets[0];
                DataSetID dataSetID = rset.getID();
                long position = rset.getRowIndex();
                return new DataID(dataSetID, position);
            }
            if (rsets[0] instanceof ICubeResultSet) {
                ICubeResultSet rset = (ICubeResultSet)rsets[0];
                DataSetID dataSetID = rset.getID();
                String cellId = rset.getCellIndex();
                return new DataID(dataSetID, cellId);
            }
        }
        return null;
    }

    protected long generateUniqueID() {
        if (this.parent != null) {
            return this.parent.uniqueId++;
        }
        return this.manager.generateUniqueID();
    }

    protected long getElementId() {
        if (this.design != null) {
            return this.design.getID();
        }
        return -1L;
    }

    protected InstanceID getInstanceID() {
        if (this.instanceId == null) {
            InstanceID pid = this.parent == null ? null : this.parent.getInstanceID();
            long uid = this.generateUniqueID();
            long id = this.getElementId();
            DataID dataId = this.getDataID();
            this.instanceId = new InstanceID(pid, uid, id, dataId);
        }
        return this.instanceId;
    }

    protected boolean isSameInstance(InstanceID a, InstanceID b) {
        if (a == b) {
            return true;
        }
        return a != null && b != null && a.getUniqueID() == b.getUniqueID();
    }

    protected IBaseResultSet getParentResultSet() {
        if (this.parentRsets == null && this.parent != null) {
            if (this.parent.rsets == null) {
                IBaseResultSet[] pRsets = this.parent.getQueryResults();
                if (pRsets == null || pRsets.length > 0 && pRsets[0] == null) {
                    IBaseResultSet prset_ = this.parent.getParentResultSet();
                    if (prset_ != null) {
                        this.parentRsets = new IBaseResultSet[]{prset_};
                    }
                } else {
                    this.parentRsets = new IBaseResultSet[]{pRsets[0]};
                }
            } else {
                this.parentRsets = this.parent.rsets;
            }
        }
        if (this.parentRsets != null) {
            return this.parentRsets[0];
        }
        return null;
    }
}

