/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.AreaStyle;
import org.eclipse.birt.report.engine.css.dom.ComputedStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ITextLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.WordRecognizerWrapper;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.Hyphenation;
import org.eclipse.birt.report.engine.layout.pdf.hyphen.IWordRecognizer;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;

public class PDFTextLM
extends PDFLeafItemLM
implements ITextLayoutManager {
    public static boolean ENABLE_HYPHENATION = false;
    private ILineStackingLayoutManager lineLM;
    private boolean pause = false;
    private Compositor comp = null;
    private ITextContent textContent = null;
    private static HashSet splitChar = new HashSet();

    static {
        splitChar.add(new Character(' '));
        splitChar.add(new Character('\r'));
        splitChar.add(new Character('\n'));
    }

    public PDFTextLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.lineLM = (ILineStackingLayoutManager)((Object)parent);
        ITextContent textContent = (ITextContent)content;
        this.lineLM.setTextIndent(textContent);
        String text = textContent.getText();
        if (text != null && text.length() != 0) {
            this.transform(textContent);
            this.textContent = textContent;
            this.comp = new Compositor();
        }
    }

    protected boolean layoutChildren() {
        if (this.textContent == null) {
            return false;
        }
        this.pause = false;
        return this.comp.compose();
    }

    protected boolean checkAvailableSpace() {
        return false;
    }

    public void addSpaceHolder(IArea con) {
        this.lineLM.addArea(con, false, false);
    }

    public boolean needPause() {
        return this.pause;
    }

    public void addTextLine(IArea textLine) {
        this.lineLM.addArea(textLine, false, false);
    }

    public void newLine() {
        this.pause = !this.lineLM.endLine();
    }

    public int getFreeSpace() {
        return this.lineLM.getCurrentMaxContentWidth();
    }

    public void transform(ITextContent textContent) {
        String transformType = textContent.getComputedStyle().getTextTransform();
        if (transformType.equalsIgnoreCase("uppercase")) {
            textContent.setText(textContent.getText().toUpperCase());
        } else if (transformType.equalsIgnoreCase("lowercase")) {
            textContent.setText(textContent.getText().toLowerCase());
        } else if (transformType.equalsIgnoreCase("capitalize")) {
            textContent.setText(this.capitalize(textContent.getText()));
        }
        ArabicShaping shaping = new ArabicShaping(8);
        try {
            String shapingText = shaping.shape(textContent.getText());
            textContent.setText(shapingText);
        }
        catch (ArabicShapingException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private String capitalize(String text) {
        boolean capitalizeNextChar = true;
        char[] array = text.toCharArray();
        int i = 0;
        while (i < array.length) {
            Character c = new Character(text.charAt(i));
            if (splitChar.contains(c)) {
                capitalizeNextChar = true;
            } else if (capitalizeNextChar) {
                array[i] = Character.toUpperCase(array[i]);
                capitalizeNextChar = false;
            }
            ++i;
        }
        return new String(array);
    }

    protected boolean handlePageBreakAfter() {
        if (this.content != null && PropertyUtil.isInlineElement(this.content)) {
            return super.handlePageBreakAfter();
        }
        return false;
    }

    protected boolean handlePageBreakBefore() {
        if (this.content != null && PropertyUtil.isInlineElement(this.content)) {
            return super.handlePageBreakBefore();
        }
        return false;
    }

    private class Compositor {
        private ChunkGenerator cg = null;
        private Chunk chunk = null;
        private ITextContent content;
        private boolean isInline;
        private boolean isNew = true;
        private boolean pdfTextWrapping;
        private int leftSpaceHolder = 0;
        private int rightSpaceHolder = 0;
        private int vestigeIndex = -1;
        private int vestigeLength = 0;
        private int currentPos = 0;
        private int areaStartPos = 0;
        private int letterSpacing = 0;
        private int wordSpacing = 0;
        private int maxLineSpace = 0;
        private IWordRecognizer wr = null;
        private int leftMargin;
        private int leftBorder;
        private int leftPadding;
        private int rightMargin;
        private int rightBorder;
        private int rightPadding;
        private int topBorder;
        private int topPadding;
        private int bottomBorder;
        private int bottomPadding;

        public Compositor() {
            this.content = PDFTextLM.this.textContent;
            boolean bidiProcessing = PDFTextLM.this.context.getBidiProcessing();
            boolean fontSubstitution = PDFTextLM.this.context.getFontSubstitution();
            this.pdfTextWrapping = PDFTextLM.this.context.getTextWrapping();
            this.cg = new ChunkGenerator(PDFTextLM.this.context.getFontManager(), this.content, bidiProcessing, fontSubstitution);
            this.isInline = PropertyUtil.isInlineElement(this.content);
            this.maxLineSpace = PDFTextLM.this.lineLM.getMaxLineWidth();
            IStyle style = this.content.getComputedStyle();
            this.letterSpacing = PDFTextLM.this.getDimensionValue(style.getProperty(27));
            this.wordSpacing = PDFTextLM.this.getDimensionValue(style.getProperty(37));
            AreaStyle boxStyle = new AreaStyle((ComputedStyle)style);
            PDFTextLM.this.validateBoxProperty(boxStyle, this.maxLineSpace, PDFTextLM.this.context.getMaxHeight());
            this.leftMargin = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(0));
            this.leftBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(48));
            this.leftPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(7));
            this.rightMargin = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(1));
            this.rightBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(8));
            this.rightPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(13));
            this.topBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(44));
            this.topPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(11));
            this.bottomBorder = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(24));
            this.bottomPadding = PDFTextLM.this.getDimensionValue(boxStyle.getProperty(9));
        }

        public boolean compose() {
            while (this.hasMore()) {
                this.handleNext();
                if (!PDFTextLM.this.needPause()) continue;
                return true;
            }
            return false;
        }

        private boolean hasMore() {
            if (this.cg.hasMore()) {
                return true;
            }
            if (this.chunk == null) {
                return false;
            }
            if (this.currentPos < this.chunk.getText().length()) {
                return true;
            }
            if (this.isInline) {
                ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(this.content, false, true);
                con.setWidth(this.rightBorder + this.rightPadding);
                if (this.chunk.getFontInfo() == null) {
                    IStyle style = this.content.getComputedStyle();
                    con.setHeight(PDFTextLM.this.getDimensionValue(style.getProperty(42)) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                } else {
                    con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                }
                PDFTextLM.this.addSpaceHolder(con);
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        private void handleNext() {
            freeSpace = PDFTextLM.this.getFreeSpace();
            if (this.isNew || this.currentPos == this.chunk.getText().length()) {
                if (this.cg.hasMore()) {
                    this.chunk = this.cg.getNext();
                    if (this.chunk == Chunk.HARD_LINE_BREAK) {
                        handler = new FontHandler(PDFTextLM.this.context.getFontManager(), this.content, false);
                        d = new Dimension(0, (int)(handler.getFontInfo().getWordHeight() * 1000.0f));
                        con = this.buildArea("", this.content, handler.getFontInfo(), d);
                        PDFTextLM.this.addSpaceHolder(con);
                        PDFTextLM.this.newLine();
                        this.currentPos = this.chunk.getText().length();
                        this.vestigeIndex = -1;
                        return;
                    }
                    if (!this.pdfTextWrapping) {
                        originalText = this.chunk.getText();
                        areaWidth = (int)(this.chunk.getFontInfo().getWordWidth(originalText) * 1000.0f) + this.letterSpacing * originalText.length();
                        d = new Dimension(areaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                        builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
                        PDFTextLM.this.addTextLine(builtArea);
                        PDFTextLM.this.newLine();
                        this.currentPos = this.chunk.getText().length();
                        this.vestigeIndex = -1;
                        return;
                    }
                    this.currentPos = 0;
                    this.vestigeIndex = -1;
                    this.vestigeLength = 0;
                    this.wr = new WordRecognizerWrapper(this.chunk.getText(), PDFTextLM.this.context.getLocale());
                } else {
                    return;
                }
            }
            if (this.isNew) {
                this.isNew = false;
                if (this.isInline) {
                    con = (AbstractArea)AreaFactory.createInlineContainer(this.content, true, false);
                    con.setWidth(this.leftBorder + this.leftPadding);
                    con.setHeight((int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f) + this.topBorder + this.topPadding + this.bottomBorder + this.bottomPadding);
                    PDFTextLM.this.addSpaceHolder(con);
                    this.leftSpaceHolder = this.leftMargin + this.leftBorder + this.leftPadding;
                    freeSpace -= this.leftSpaceHolder;
                }
            }
            str = null;
            currentWord = null;
            if (-1 == this.vestigeIndex) {
                currentWord = this.wr.getNextWord();
                if (currentWord == null) {
                    return;
                }
                str = currentWord.getValue();
                this.areaStartPos = this.chunk.getOffset() + currentWord.getStart();
            } else {
                str = this.chunk.getText().substring(this.vestigeIndex, this.vestigeIndex + this.vestigeLength);
                this.areaStartPos = this.chunk.getOffset() + this.vestigeIndex;
            }
            prevAreaWidth = 0;
            areaWidth = (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
            if (this.isInline && this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) {
                this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
                freeSpace -= this.rightSpaceHolder;
            }
            if (!((float)this.maxLineSpace < this.chunk.getFontInfo().getWordWidth(str) * 1000.0f + (float)(this.letterSpacing * str.length()) + (float)this.wordSpacing)) ** GOTO lbl82
            if (str.length() == 0) {
                this.vestigeIndex = -1;
                this.vestigeLength = 0;
                return;
            }
            d = new Dimension((int)(this.chunk.getFontInfo().getWordWidth(str) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
            originalText = str;
            if (this.maxLineSpace != freeSpace) {
                PDFTextLM.this.newLine();
            }
            builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
            PDFTextLM.this.addTextLine(builtArea);
            PDFTextLM.this.newLine();
            this.currentPos += str.length();
            this.vestigeIndex = -1;
            this.vestigeLength = 0;
            return;
lbl-1000:
            // 1 sources

            {
                this.currentPos += str.length();
                currentWord = this.wr.getNextWord();
                if (currentWord == null) {
                    str = null;
                    break;
                }
                str = currentWord.getValue();
                prevAreaWidth = areaWidth;
                areaWidth += (int)(this.chunk.getFontInfo().getWordWidth(this.chunk.getText().substring(this.currentPos, this.currentPos + str.length())) * 1000.0f) + this.letterSpacing * str.length() + this.wordSpacing;
                if (!this.isAtLast(this.chunk.getOffset() + this.currentPos + str.length())) continue;
                this.rightSpaceHolder = this.rightMargin + this.rightBorder + this.rightPadding;
                freeSpace -= this.rightSpaceHolder;
lbl82:
                // 3 sources

                ** while (freeSpace >= areaWidth)
            }
lbl83:
            // 2 sources

            length = this.chunk.getText().length();
            if (this.currentPos == length) {
                d = new Dimension(areaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
                originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.chunk.getText().length());
                builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
                PDFTextLM.this.addTextLine(builtArea);
                this.vestigeIndex = -1;
                this.vestigeLength = 0;
                return;
            }
            d = new Dimension(prevAreaWidth, (int)(this.chunk.getFontInfo().getWordHeight() * 1000.0f));
            originalText = this.chunk.getText().substring(this.areaStartPos - this.chunk.getOffset(), this.currentPos);
            builtArea = this.buildArea(this.getReverseText(originalText), this.content, this.chunk.getFontInfo(), d);
            PDFTextLM.this.addTextLine(builtArea);
            PDFTextLM.this.newLine();
            if (currentWord == null) {
                if (originalText.length() == 0) {
                    return;
                }
                this.vestigeIndex = -1;
                this.vestigeLength = 0;
            } else {
                this.vestigeIndex = currentWord.getStart();
                this.vestigeLength = currentWord.getLength();
            }
        }

        private IArea buildArea(String text, ITextContent content, FontInfo fi, Dimension dimension) {
            if (this.isInline) {
                return this.createInlineTextArea(text, content, fi, dimension);
            }
            return PDFTextLM.this.createBlockTextArea(text, content, fi, dimension);
        }

        private int hyphen(int startIndex, int width, Hyphenation hyphenation, FontInfo fi) {
            assert (startIndex >= 0);
            if (startIndex > hyphenation.length() - 1) {
                return -1;
            }
            int last = 0;
            int current = 0;
            int i = startIndex + 1;
            while (i < hyphenation.length()) {
                last = current;
                String pre = hyphenation.getHyphenText(startIndex, i);
                current = (int)(fi.getWordWidth(pre) * 1000.0f) + this.letterSpacing * pre.length();
                if (width > last && width <= current) {
                    return i - 1;
                }
                ++i;
            }
            return hyphenation.length() - 1;
        }

        private String getReverseText(String text) {
            if ((this.chunk.getRunLevel() & 1) == 0) {
                return text;
            }
            return this.flip(text);
        }

        private String flip(String text) {
            char[] indexChars = text.toCharArray();
            int start = 0;
            int end = indexChars.length;
            int mid = (start + end) / 2;
            --end;
            while (start < mid) {
                char temp = indexChars[start];
                indexChars[start] = indexChars[end];
                indexChars[end] = temp;
                ++start;
                --end;
            }
            return new String(indexChars);
        }

        private boolean isAtLast(int index) {
            return index >= this.content.getText().length();
        }

        private IArea createInlineTextArea(String text, ITextContent content, FontInfo fi, Dimension contentDimension) {
            ContainerArea con = (ContainerArea)AreaFactory.createInlineContainer(content, false, false);
            int textHeight = contentDimension.getHeight();
            int textWidth = contentDimension.getWidth();
            con.setWidth(Math.min(textWidth, PDFTextLM.this.context.getMaxWidth()));
            con.setHeight(Math.min(textHeight + this.topPadding + this.topBorder + this.bottomPadding + this.bottomBorder, PDFTextLM.this.context.getMaxHeight()));
            AbstractArea textArea = (AbstractArea)AreaFactory.createTextArea(content, text, fi);
            con.addChild(textArea);
            textArea.setHeight(textHeight);
            textArea.setWidth(textWidth);
            textArea.setPosition(0, this.topPadding + this.topBorder);
            return con;
        }
    }
}

