/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Image;
import java.util.Locale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ConcreteImageLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.util.FlashFile;

public class ImageAreaLayout
implements ILayout {
    public static final int TYPE_IMAGE_OBJECT = 0;
    public static final int TYPE_FLASH_OBJECT = 1;
    private ILayout layout = null;
    private ContainerArea parent;
    private IImageContent content;
    private LayoutContext context;
    private int objectType = 0;

    public ImageAreaLayout(ContainerArea parent, LayoutContext context, IImageContent content) {
        this.parent = parent;
        this.content = content;
        this.context = context;
    }

    public void layout() throws BirtException {
        this.initialize();
        if (this.layout != null) {
            this.layout.layout();
        }
    }

    protected void initialize() throws BirtException {
        this.checkObjectType();
        IImageContent imageContent = this.content;
        Image imageObject = null;
        if (this.objectType == 0) {
            imageObject = EmitterUtil.getImage(imageContent);
        }
        if (this.isOutputSupported(this.objectType) && (this.objectType == 1 || imageObject != null)) {
            this.layout = new ConcreteImageLayout(this.context, this.parent, this.content, imageObject);
        } else {
            ITextContent altTextContent = this.createAltText(this.content);
            if (altTextContent == null) {
                return;
            }
            this.layout = new BlockTextArea(this.parent, this.context, altTextContent);
        }
    }

    private ITextContent createAltText(IImageContent imageContent) {
        IReportContent report = imageContent.getReportContent();
        if (report == null) {
            return null;
        }
        ITextContent altTextContent = report.createTextContent(imageContent);
        String alt = imageContent.getAltText();
        if (alt == null) {
            ULocale locale = ULocale.forLocale((Locale)this.context.getLocale());
            if (locale == null) {
                locale = ULocale.getDefault();
            }
            EngineResourceHandle resourceHandle = new EngineResourceHandle(locale);
            alt = this.objectType == 1 ? resourceHandle.getMessage("Error.FlashObjectNotSupported") : resourceHandle.getMessage("Error.ReportItemNotSupported");
        }
        altTextContent.setText(alt);
        return altTextContent;
    }

    protected void checkObjectType() {
        String extension;
        IImageContent image = this.content;
        String uri = image.getURI();
        String mimeType = image.getMIMEType();
        this.objectType = FlashFile.isFlash(mimeType, uri, extension = image.getExtension()) ? 1 : 0;
    }

    private boolean isOutputSupported(int type) {
        String supportedImageFormats = this.context.getSupportedImageFormats();
        return type == 0 ? -1 != supportedImageFormats.indexOf("PNG") || -1 != supportedImageFormats.indexOf("GIF") || -1 != supportedImageFormats.indexOf("BMP") || -1 != supportedImageFormats.indexOf("JPG") : type == 1 && -1 != supportedImageFormats.indexOf("SWF");
    }
}

