/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.List;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.PropertyStructure;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class ColumnHint
extends PropertyStructure {
    public static final String COLUMN_HINT_STRUCT = "ColumnHint";
    public static final String COLUMN_NAME_MEMBER = "columnName";
    public static final String ALIAS_MEMBER = "alias";
    public static final String SEARCHING_MEMBER = "searching";
    public static final String EXPORT_MEMBER = "export";
    public static final String ANALYSIS_MEMBER = "analysis";
    public static final String PARENT_LEVEL_MEMBER = "parentLevel";
    public static final String FORMAT_MEMBER = "format";
    public static final String DISPLAY_NAME_ID_MEMBER = "displayNameID";
    public static final String DISPLAY_NAME_MEMBER = "displayName";
    public static final String HELP_TEXT_ID_MEMBER = "helpTextID";
    public static final String HELP_TEXT_MEMBER = "helpText";

    public String getStructName() {
        return COLUMN_HINT_STRUCT;
    }

    public List validate(Module module, DesignElement element) {
        List<SemanticException> list = super.validate(module, element);
        PropertyDefn propDefn = (PropertyDefn)this.getDefn().getMember(COLUMN_NAME_MEMBER);
        String columnName = (String)this.getProperty(module, propDefn);
        if (StringUtil.isBlank(columnName)) {
            list.add(new PropertyValueException(element, propDefn, (Object)columnName, "Error.PropertyValueException.VALUE_REQUIRED"));
        }
        return list;
    }

    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new ColumnHintHandle(valueHandle, index);
    }
}

