/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.AbstractNameContext;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionNameContext
extends AbstractNameContext {
    protected Dimension dimension = null;

    public DimensionNameContext(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    public List<DesignElement> getElements(int level) {
        ArrayList<DesignElement> elements = new ArrayList<DesignElement>();
        if (level == 0) {
            elements.addAll(this.namespace.getElements());
        } else {
            elements.addAll(this.namespace.getElements());
            int newLevel = level - 1;
            Dimension parent = (Dimension)this.dimension.getExtendsElement();
            if (parent == null) {
                parent = (Dimension)this.dimension.getVirtualParent();
            }
            while (parent != null && newLevel >= 0) {
                elements.addAll(((AbstractNameHelper)parent.getNameHelper()).getNameContext(0).getElements(newLevel));
            }
        }
        return Collections.unmodifiableList(elements);
    }

    private ElementRefValue resolve(String elementName) {
        String namespace = StringUtil.extractNamespace(elementName);
        String name = StringUtil.extractName(elementName);
        List<DesignElement> elements = this.getElements(0);
        int i = 0;
        while (i < elements.size()) {
            DesignElement tmpElement = elements.get(i);
            if (tmpElement.getFullName().equals(name)) {
                return new ElementRefValue(namespace, tmpElement);
            }
            ++i;
        }
        return new ElementRefValue(namespace, name);
    }

    private ElementRefValue resolve(DesignElement element) {
        if (element == null) {
            return null;
        }
        return this.doResolveElement(this.getElements(0), element);
    }

    private ElementRefValue doResolveElement(List<DesignElement> elements, DesignElement element) {
        boolean isFound = false;
        int i = 0;
        while (i < elements.size()) {
            DesignElement tmpElement = elements.get(i);
            if (tmpElement == element) {
                isFound = true;
                break;
            }
            ++i;
        }
        Module root = element.getRoot();
        String namespace = null;
        if (root instanceof Library) {
            namespace = ((Library)root).getNamespace();
        }
        if (!isFound) {
            return new ElementRefValue(namespace, element.getFullName());
        }
        return new ElementRefValue(namespace, element);
    }

    @Override
    public ElementRefValue resolve(DesignElement element, PropertyDefn propDefn) {
        if (propDefn != null && "extends".equalsIgnoreCase(propDefn.getName())) {
            return this.resolve(element);
        }
        return this.resolve(element);
    }

    @Override
    public ElementRefValue resolve(String elementName, PropertyDefn propDefn) {
        if (propDefn != null && "extends".equalsIgnoreCase(propDefn.getName())) {
            return this.resolve(elementName);
        }
        return this.resolve(elementName);
    }

    @Override
    public DesignElement findElement(String elementName, IElementDefn elementDefn) {
        return this.resolve(elementName).getElement();
    }

    @Override
    public DesignElement getElement() {
        return this.dimension;
    }

    @Override
    public int getNameSpaceID() {
        return 0;
    }
}

