/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.validators.MasterPageRequiredValidator;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.CssStyleSheetAdapter;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ICssStyleSheetOperation;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.interfaces.IReportDesignModel;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.writer.DesignWriter;
import org.eclipse.birt.report.model.writer.ModuleWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportDesign
extends Module
implements IReportDesignModel,
ICssStyleSheetOperation {
    private ICssStyleSheetOperation operation = null;

    public ReportDesign() {
        super((DesignSession)null);
        this.initSlots();
        this.onCreate();
    }

    public ReportDesign(DesignSession session) {
        super(session);
        this.initSlots();
        this.onCreate();
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitReportDesign(this);
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(MasterPageRequiredValidator.getInstance().validate(this, this));
        list.addAll(this.validateStructureList(module, "images"));
        list.addAll(this.validateStructureList(module, "colorPalette"));
        list.addAll(this.validateStructureList(module, "includeScripts"));
        list.addAll(this.validateStructureList(module, "libraries"));
        list.addAll(this.validateStructureList(module, "propertyBindings"));
        return list;
    }

    @Override
    public String getElementName() {
        return "ReportDesign";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle();
    }

    public ReportDesignHandle handle() {
        if (this.handle == null) {
            this.handle = new ReportDesignHandle(this);
        }
        return (ReportDesignHandle)this.handle;
    }

    public IncludeScript findIncludeScript(String fileName) {
        ArrayList list = (ArrayList)this.getLocalProperty(null, "includeScripts");
        if (list == null) {
            return null;
        }
        int i = 0;
        while (i < list.size()) {
            IncludeScript script = (IncludeScript)list.get(i);
            if (script.getFileName() != null && script.getFileName().equals(fileName)) {
                return script;
            }
            ++i;
        }
        return null;
    }

    @Override
    protected int getSlotCount() {
        return 10;
    }

    @Override
    public ModuleWriter getWriter() {
        return new DesignWriter(this);
    }

    public List<Object> collectPropValues(int slotId, String propName) {
        ArrayList<Object> rtnList = new ArrayList<Object>();
        ContentIterator contents = new ContentIterator((Module)this, new ContainerContext((DesignElement)this, slotId));
        while (contents.hasNext()) {
            DesignElement ele = contents.next();
            Object obj = ele.getProperty((Module)this, propName);
            if (obj == null) continue;
            rtnList.add(obj);
        }
        return rtnList;
    }

    public byte[] getThumbnail() {
        String data = this.getStringProperty(this, "thumbnail");
        if (data == null) {
            return null;
        }
        try {
            return data.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    @Override
    public ModuleOption getOptions() {
        return this.options;
    }

    @Override
    public int dropCss(CssStyleSheet css) {
        if (this.operation == null) {
            return -1;
        }
        return this.operation.dropCss(css);
    }

    @Override
    public void addCss(CssStyleSheet css) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.addCss(css);
    }

    @Override
    public void insertCss(CssStyleSheet css, int index) {
        if (this.operation == null) {
            this.operation = new CssStyleSheetAdapter();
        }
        this.operation.insertCss(css, index);
    }

    @Override
    public List<CssStyleSheet> getCsses() {
        if (this.operation == null) {
            return Collections.emptyList();
        }
        return this.operation.getCsses();
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        Module module = (Module)super.doClone(policy);
        if (this.isCached()) {
            this.cacheValues();
        }
        return module;
    }

    @Override
    public void cacheValues() {
        this.setIsCached(true);
        super.cacheValues();
        ContentIterator iter1 = new ContentIterator((Module)this, new ContainerContext((DesignElement)this, 6));
        while (iter1.hasNext()) {
            DesignElement tmpElement = iter1.next();
            if (!(tmpElement instanceof ReportItem)) continue;
            ((ReportItem)tmpElement).cacheValues();
        }
    }

    public VariableElement findVariableElement(String name) {
        return (VariableElement)this.nameHelper.getNameSpace(9).getElement(name);
    }
}

