/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ChoiceSet;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ColorPropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(ColorPropertyType.class.getName());
    public static final String COLORS_CHOICE_SET = "colors";
    public static final String BLACK = "black";
    public static final String WHITE = "white";
    public static final String RED = "red";
    public static final String BLUE = "blue";
    public static final String ORANGE = "orange";
    public static final String SILVER = "silver";
    public static final String GRAY = "gray";
    public static final String MAROON = "maroon";
    public static final String PURPLE = "purple";
    public static final String FUCHSIA = "fuchsia";
    public static final String GREEN = "green";
    public static final String LIME = "lime";
    public static final String OLIVE = "olive";
    public static final String YELLOW = "yellow";
    public static final String NAVY = "navy";
    public static final String TEAL = "teal";
    public static final String AQUA = "aqua";
    private ChoiceSet colorChoices = null;
    private static final String DISPLAY_NAME_KEY = "Property.color";

    public ColorPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public IChoiceSet getChoices() {
        if (this.colorChoices == null) {
            this.colorChoices = (ChoiceSet)MetaDataDictionary.getInstance().getChoiceSet(COLORS_CHOICE_SET);
            assert (this.colorChoices != null);
        }
        return this.colorChoices;
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        int intValue;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        if (value instanceof Integer && (intValue = ((Integer)value).intValue()) >= 0 && intValue <= 0xFFFFFF) {
            return value;
        }
        logger.log(Level.SEVERE, "Invalid color value " + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 4);
    }

    public Object validateXml(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        Object validValue = this.validateColor(module, tmpValue);
        if (validValue != null) {
            return validValue;
        }
        logger.log(Level.SEVERE, "Invalid color property value " + tmpValue);
        throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.INVALID_VALUE", 4);
    }

    public int getTypeCode() {
        return 4;
    }

    public String getName() {
        return "color";
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Integer) {
            int color = (Integer)value;
            return StringUtil.toRgbText(color).toUpperCase();
        }
        return null;
    }

    public int toInteger(Module module, Object value) {
        CustomColor customColor;
        if (value == null) {
            return -1;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        IChoiceSet choices = this.getChoices();
        assert (choices != null);
        if (choices.contains((String)value)) {
            return ColorUtil.parsePredefinedColor((String)value);
        }
        if (module != null && (customColor = module.findColor((String)value)) != null) {
            return customColor.getRGB();
        }
        return -1;
    }

    public String toCssColor(Module module, Object value) {
        CustomColor customColor;
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return StringUtil.toRgbText((Integer)value);
        }
        String colorName = (String)value;
        IChoice choice = this.getChoices().findChoice(colorName);
        if (choice != null) {
            return choice.getName();
        }
        if (module != null && (customColor = module.findColor(colorName)) != null) {
            return StringUtil.toRgbText(customColor.getRGB());
        }
        return null;
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        IChoiceSet choices = this.getChoices();
        if (value instanceof String) {
            if (choices != null) {
                IChoice color = null;
                color = choices.findChoice((String)value);
                if (color != null) {
                    return color.getDisplayName();
                }
            }
            assert (module != null);
            CustomColor customColor = module.findColor((String)value);
            if (customColor != null) {
                return customColor.getDisplayName(module);
            }
        } else if (value instanceof Integer) {
            return ColorUtil.format((Integer)value, module.getSession().getColorFormat());
        }
        assert (false);
        return null;
    }

    public Object validateInputString(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        IChoice color;
        if ((value = StringUtil.trimString(value)) == null) {
            return null;
        }
        Object validValue = this.validateColor(module, value);
        if (validValue != null) {
            return validValue;
        }
        IChoiceSet choices = this.getChoices();
        if (choices != null && (color = choices.findChoiceByDisplayName(value)) != null) {
            return color.getName();
        }
        logger.log(Level.SEVERE, "Invalid color value " + value);
        throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 4);
    }

    private Object validateColor(Module module, String value) throws PropertyValueException {
        CustomColor customColor;
        IChoice choice;
        if (StringUtil.isBlank(value)) {
            return null;
        }
        IChoiceSet choices = this.getChoices();
        if (choices != null && (choice = choices.findChoice(value)) != null) {
            return choice.getName();
        }
        try {
            int retValue = ColorUtil.parseColor(value);
            if (retValue != -1) {
                return new Integer(retValue);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.log(Level.SEVERE, "Invalid color value " + value);
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 4);
        }
        if (module != null && (customColor = module.findColor(value)) != null) {
            return value;
        }
        return null;
    }

    public String toCSSCompatibleColor(Module module, Object value) {
        if (value == null) {
            return null;
        }
        int rgbValue = -1;
        if (value instanceof String) {
            CustomColor customColor;
            IChoice choice = this.getChoices().findChoice((String)value);
            if (choice != null) {
                return choice.getName();
            }
            if (module != null && (customColor = module.findColor((String)value)) != null) {
                rgbValue = customColor.getRGB();
            }
        } else if (value instanceof Integer) {
            rgbValue = (Integer)value;
        }
        if (rgbValue != -1) {
            return ColorUtil.format(rgbValue, 3);
        }
        return null;
    }
}

