/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class DateTimePropertyType
extends PropertyType {
    private static Logger logger = Logger.getLogger(DateTimePropertyType.class.getName());
    private static final String DISPLAY_NAME_KEY = "Property.dateTime";
    private static final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", DEFAULT_LOCALE);

    public DateTimePropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof String) {
            return this.validateInputString(module, defn, (String)value);
        }
        logger.log(Level.SEVERE, "Invalid date value type:" + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 11);
    }

    public Object validateXml(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        assert (value == null || value instanceof String);
        String tmpValue = (String)value;
        if ((tmpValue = StringUtil.trimString(tmpValue)) == null) {
            return null;
        }
        try {
            return formatter.parse(tmpValue);
        }
        catch (ParseException parseException) {
            logger.log(Level.SEVERE, "Invalid date value:" + tmpValue);
            throw new PropertyValueException((Object)tmpValue, "Error.PropertyValueException.INVALID_VALUE", this.getTypeCode());
        }
    }

    public String toDisplayString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        assert (value instanceof Date);
        DateFormat formatter = DateFormat.getDateInstance((int)3, (ULocale)ThreadResources.getLocale());
        return formatter.format((Date)value);
    }

    public int getTypeCode() {
        return 11;
    }

    public String getName() {
        return "dateTime";
    }

    public Object validateInputString(Module module, PropertyDefn defn, String value) throws PropertyValueException {
        if (StringUtil.isBlank(value)) {
            return null;
        }
        DateFormat formatter = DateFormat.getDateInstance((int)3, (ULocale)ThreadResources.getLocale());
        try {
            return formatter.parse(value);
        }
        catch (ParseException parseException) {
            logger.log(Level.SEVERE, "Invalid date value:" + value);
            throw new PropertyValueException((Object)value, "Error.PropertyValueException.INVALID_VALUE", 11);
        }
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return formatter.format((Date)value);
    }
}

