/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.INameHelper;
import org.eclipse.birt.report.model.core.namespace.NameContextFactory;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.NamePropertyType;

public class DimensionNameHelper
extends AbstractNameHelper {
    protected Dimension dimension = null;

    public DimensionNameHelper(Dimension dimension) {
        this.dimension = dimension;
        this.initialize();
    }

    int getNameSpaceCount() {
        return 1;
    }

    protected void initialize() {
        int count = this.getNameSpaceCount();
        this.nameContexts = new INameContext[count];
        int i = 0;
        while (i < count) {
            this.nameContexts[i] = NameContextFactory.createDimensionNameContext(this.dimension, i);
            ++i;
        }
    }

    public String getUniqueName(DesignElement element) {
        if (element == null) {
            return null;
        }
        ElementDefn eDefn = (ElementDefn)element.getDefn();
        if (!this.dimension.getDefn().isKindOf(eDefn.getNameConfig().getNameContainer())) {
            INameHelper nameHelper = new NameExecutor(element).getNameHelper(this.dimension.getRoot());
            return nameHelper == null ? null : nameHelper.getUniqueName(element);
        }
        String name = StringUtil.trimString(element.getName());
        name = NamePropertyType.validateName(name);
        if (eDefn.getNameOption() == 0) {
            return null;
        }
        if (eDefn.getNameOption() == 1 && name == null && this.dimension.getRoot() instanceof ReportDesign) {
            return null;
        }
        int id = eDefn.getNameSpaceID();
        NameSpace nameSpace = this.getCachedNameSpace(id);
        NameSpace moduleNameSpace = this.nameContexts[id].getNameSpace();
        if (name != null && DimensionNameHelper.isValidInNameSpace(nameSpace, element, name) && DimensionNameHelper.isValidInNameSpace(moduleNameSpace, element, name)) {
            return name;
        }
        if (name == null) {
            name = ModelMessages.getMessage("New." + element.getDefn().getName());
            name = name.trim();
        }
        int index = 0;
        String baseName = name;
        while (nameSpace.contains(name) || moduleNameSpace.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        return name;
    }

    public void addElement(DesignElement element) {
        if (element == null || element.getName() == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (!this.dimension.getDefn().isKindOf(defn.getNameConfig().getNameContainer())) {
            return;
        }
        int id = defn.getNameSpaceID();
        NameSpace ns = this.getCachedNameSpace(id);
        if (!ns.contains(element.getName())) {
            ns.insert(element);
        }
    }

    public void addContentName(int id, String name) {
    }

    public DesignElement getElement() {
        return this.dimension;
    }
}

