/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.validators.CellOverlappingValidator;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.interfaces.ITableRowModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRow
extends StyledElement
implements ITableRowModel {
    public TableRow() {
        this.initSlots();
    }

    @Override
    public ContainerSlot getSlot(int slot) {
        assert (slot == 0);
        return this.slots[0];
    }

    public List<DesignElement> getContentsSlot() {
        return this.slots[0].getContents();
    }

    @Override
    public void apply(ElementVisitor visitor) {
        visitor.visitRow(this);
    }

    @Override
    public String getElementName() {
        return "Row";
    }

    @Override
    public DesignElementHandle getHandle(Module module) {
        return this.handle(module);
    }

    public RowHandle handle(Module module) {
        if (this.handle == null) {
            this.handle = new RowHandle(module, this);
        }
        return (RowHandle)this.handle;
    }

    public int getColumnCount(Module module) {
        int colCount = 0;
        int cellCount = this.slots[0].getCount();
        int i = 0;
        while (i < cellCount) {
            Cell cell = (Cell)this.slots[0].getContent(i);
            int posn = cell.getColumn(module);
            int span = cell.getColSpan(module);
            if (posn > 0) {
                int end = posn + span - 1;
                if (end > colCount) {
                    colCount = end;
                }
            } else {
                colCount += span;
            }
            ++i;
        }
        return colCount;
    }

    @Override
    public List<SemanticException> validate(Module module) {
        List<SemanticException> list = super.validate(module);
        list.addAll(CellOverlappingValidator.getInstance().validate(module, this));
        return list;
    }
}

