/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.DesignSession;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ReportState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.URIUtilImpl;
import org.eclipse.birt.report.model.util.XMLParserHandler;

public class DesignParserHandler
extends ModuleParserHandler {
    public DesignParserHandler(DesignSession theSession, String fileName, ModuleOption options) {
        super(theSession, fileName);
        this.module = new ReportDesign(this.session);
        URL systemId = URIUtilImpl.getDirectory(fileName);
        this.module.setSystemId(systemId);
        this.module.setFileName(fileName);
        this.module.setOptions(options);
        URL location = ModelUtil.getURLPresentation(fileName);
        this.module.setLocation(location);
        this.buildModuleOptions(options);
    }

    public DesignParserHandler(DesignSession theSession, URL systemId, ModuleOption options) {
        super(theSession, systemId.toExternalForm());
        this.module = new ReportDesign(this.session);
        URL url = URIUtilImpl.getDirectory(systemId.toExternalForm());
        this.module.setSystemId(url);
        this.module.setOptions(options);
        this.buildModuleOptions(options);
    }

    public AbstractParseState createStartState() {
        return new StartState();
    }

    class StartState
    extends XMLParserHandler.InnerParseState {
        StartState() {
            super(DesignParserHandler.this);
        }

        public AbstractParseState startElement(String tagName) {
            if (tagName.equalsIgnoreCase("report")) {
                if (DesignParserHandler.this.markLineNumber) {
                    DesignParserHandler.this.tempLineNumbers.put(DesignParserHandler.this.module, new Integer(DesignParserHandler.this.locator.getLineNumber()));
                }
                return new ReportState(DesignParserHandler.this);
            }
            return super.startElement(tagName);
        }
    }
}

