/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.ICompatibleReportItem;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParseStateFactory;
import org.eclipse.birt.report.model.parser.ReportItemState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.BoundDataColumnUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtendedItemState
extends ReportItemState {
    public ExtendedItem element;

    public ExtendedItemState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public ExtendedItemState(ModuleParserHandler handler, DesignElement theContainer, String prop) {
        super(handler, theContainer, prop);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.element = new ExtendedItem();
        this.handler.addExtendedItem(this.element);
        this.parseExtensionName(attrs, true);
        String extensionVersion = attrs.getValue("extensionVersion");
        this.setProperty("extensionVersion", extensionVersion);
        boolean nameRequired = this.element.getDefn().getNameOption() == 2;
        this.initElement(attrs, nameRequired);
    }

    public DesignElement getElement() {
        return this.element;
    }

    public AbstractParseState startElement(String tagName) {
        if (this.element.getExtDefn() != null) {
            return super.startElement(tagName);
        }
        return ParseStateFactory.createParseState(tagName, this.handler, (DesignElement)this.element, this.element.getExtensibilityProvider().getContentTree());
    }

    public void end() throws SAXException {
        if (this.handler.versionNumber < 3021300) {
            IElementDefn levelDefn = MetaDataDictionary.getInstance().getElement("Level");
            IElementDefn eDefn = this.element.getDefn();
            List<IElementPropertyDefn> properties = eDefn.getProperties();
            int i = 0;
            while (i < properties.size()) {
                Level level;
                ElementRefValue value;
                ElementPropertyDefn defn = (ElementPropertyDefn)properties.get(i);
                if (defn.getTypeCode() == 15 && defn.getTargetElementType().isKindOf(levelDefn) && (value = (ElementRefValue)this.element.getLocalProperty(this.handler.module, defn)) != null && !value.isResolved() && (level = ((ModuleNameHelper)this.handler.module.getNameHelper()).findCachedLevel(value.getName())) != null) {
                    value.resolve(level);
                    level.addClient(this.element, defn.getName());
                }
                ++i;
            }
            List columnBindings = (List)this.element.getLocalProperty(this.handler.module, "boundDataColumns");
            if (columnBindings != null) {
                int i2 = 0;
                while (i2 < columnBindings.size()) {
                    ComputedColumn column = (ComputedColumn)columnBindings.get(i2);
                    List aggregationList = column.getAggregateOnList();
                    if (aggregationList != null) {
                        int j = 0;
                        while (j < aggregationList.size()) {
                            Level level;
                            String aggregationOn = (String)aggregationList.get(j);
                            if (aggregationOn != null && (level = ((ModuleNameHelper)this.handler.module.getNameHelper()).findCachedLevel(aggregationOn)) != null) {
                                aggregationList.set(j, level.getFullName());
                            }
                            ++j;
                        }
                    }
                    ++i2;
                }
            }
        }
        if (this.handler.versionNumber >= 3020100) {
            super.end();
            return;
        }
        try {
            this.element.initializeReportItem(this.handler.module);
        }
        catch (ExtendedElementException extendedElementException) {
            return;
        }
        IReportItem reportItem = this.element.getExtendedElement();
        if (reportItem != null && reportItem instanceof ICompatibleReportItem) {
            List jsExprs = ((ICompatibleReportItem)((Object)reportItem)).getRowExpressions();
            Map<String, String> updatedExprs = BoundDataColumnUtil.handleJavaExpression((List<String>)jsExprs, this.element, this.handler.module, this.handler.tempValue);
            ((ICompatibleReportItem)((Object)reportItem)).updateRowExpressions(updatedExprs);
        }
        super.end();
    }
}

