/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementDefn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelContentIterator
implements Iterator<DesignElement> {
    protected static final int MAX_LEVEL = Integer.MAX_VALUE;
    List<DesignElement> elementContents = null;
    protected int posn = 0;

    public LevelContentIterator(Module module, DesignElement element, int level) {
        assert (element != null);
        this.elementContents = new ArrayList<DesignElement>();
        this.buildContentsList(module, element, level);
    }

    public LevelContentIterator(Module module, ContainerContext containerInfor, int level) {
        assert (containerInfor != null);
        this.elementContents = new ArrayList<DesignElement>();
        this.buildContentsList(module, containerInfor, level);
    }

    private void buildContentsList(Module module, DesignElement element, int level) {
        if (level < 0 || !element.getDefn().isContainer()) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        int i = 0;
        while (i < defn.getSlotCount()) {
            this.buildContentsList(module, new ContainerContext(element, i), level);
            ++i;
        }
        List<IElementPropertyDefn> properties = defn.getContents();
        int i2 = 0;
        while (i2 < properties.size()) {
            this.buildContentsList(module, new ContainerContext(element, properties.get(i2).getName()), level);
            ++i2;
        }
    }

    private void buildContentsList(Module module, ContainerContext containerInfor, int level) {
        if (level <= 0) {
            return;
        }
        List<DesignElement> contents = containerInfor.getContents(module);
        for (DesignElement e : contents) {
            this.elementContents.add(e);
            this.buildContentsList(module, e, level - 1);
        }
    }

    @Override
    public void remove() {
        assert (false);
    }

    @Override
    public boolean hasNext() {
        return this.posn < this.elementContents.size();
    }

    @Override
    public DesignElement next() {
        return this.elementContents.get(this.posn++);
    }
}

