/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import org.eclipse.birt.chart.computation.Vector;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Location3D;
import org.eclipse.birt.chart.model.attribute.impl.LocationImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class Location3DImpl
extends LocationImpl
implements Location3D {
    protected static final double Z_EDEFAULT = 0.0;
    protected double z = 0.0;
    protected boolean zESet;
    private Vector vector;

    public static Location3D create(double x, double y, double z) {
        Location3D lo = AttributeFactory.eINSTANCE.createLocation3D();
        lo.setX(x);
        lo.setY(y);
        lo.setZ(z);
        return lo;
    }

    public Location3D copyInstance() {
        Location3DImpl dest = new Location3DImpl();
        dest.set(this);
        return dest;
    }

    protected void set(Location3D src) {
        super.set(src);
        this.z = src.getZ();
        this.zESet = src.isSetZ();
    }

    public static final Location3D[] create(double[] xa, double[] ya, double[] za) {
        Location3D[] loa = new Location3D[xa.length];
        int i = 0;
        while (i < loa.length) {
            loa[i] = Location3DImpl.create(xa[i], ya[i], za[i]);
            ++i;
        }
        return loa;
    }

    public static double[] getXArray(Location3D[] loc) {
        double[] xa = new double[loc.length];
        int i = 0;
        while (i < loc.length) {
            xa[i] = loc[i].getX();
            ++i;
        }
        return xa;
    }

    public static double[] getYArray(Location3D[] loc) {
        double[] ya = new double[loc.length];
        int i = 0;
        while (i < loc.length) {
            ya[i] = loc[i].getY();
            ++i;
        }
        return ya;
    }

    public static double[] getZArray(Location3D[] loc) {
        double[] za = new double[loc.length];
        int i = 0;
        while (i < loc.length) {
            za[i] = loc[i].getZ();
            ++i;
        }
        return za;
    }

    protected Location3DImpl() {
    }

    protected EClass eStaticClass() {
        return AttributePackage.Literals.LOCATION3_D;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double newZ) {
        double oldZ = this.z;
        this.z = newZ;
        boolean oldZESet = this.zESet;
        this.zESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldZ, this.z, !oldZESet));
        }
    }

    public void unsetZ() {
        double oldZ = this.z;
        boolean oldZESet = this.zESet;
        this.z = 0.0;
        this.zESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 2, oldZ, 0.0, oldZESet));
        }
    }

    public boolean isSetZ() {
        return this.zESet;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 2: {
                return new Double(this.getZ());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.setZ((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.unsetZ();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 2: {
                return this.isSetZ();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (z: ");
        if (this.zESet) {
            result.append(this.z);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public void translate(double dTranslateX, double dTranslateY, double dTranslateZ) {
        this.setX(this.getX() + dTranslateX);
        this.setY(this.getY() + dTranslateY);
        this.setZ(this.getZ() + dTranslateZ);
    }

    public void scale(double dScale) {
        this.setX(this.getX() * dScale);
        this.setY(this.getY() * dScale);
        this.setZ(this.getZ() * dScale);
    }

    public void set(double dX, double dY, double dZ) {
        this.setX(dX);
        this.setY(dY);
        this.setZ(dZ);
        if (this.vector != null) {
            this.vector.set(dX, dY, dZ);
        }
    }

    public void linkToVector(Vector vector) {
        this.vector = vector;
    }

    public static Location3D create(EObject parent, EReference ref) {
        return new Location3DImpl();
    }

    public static /* bridge */ /* synthetic */ Location create(EObject eObject, EReference eReference) {
        return Location3DImpl.create(eObject, eReference);
    }
}

