/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.layout.impl;

import java.util.EnumSet;
import java.util.Map;
import org.eclipse.birt.chart.computation.BoundingBox;
import org.eclipse.birt.chart.computation.IChartComputation;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.LayoutFactory;
import org.eclipse.birt.chart.model.layout.LayoutPackage;
import org.eclipse.birt.chart.model.layout.TitleBlock;
import org.eclipse.birt.chart.model.layout.impl.LabelBlockImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;

public class TitleBlockImpl
extends LabelBlockImpl
implements TitleBlock {
    protected TitleBlockImpl() {
    }

    public boolean isTitle() {
        return true;
    }

    public boolean isCustom() {
        return false;
    }

    protected EClass eStaticClass() {
        return LayoutPackage.Literals.TITLE_BLOCK;
    }

    public static Block create() {
        TitleBlock tb = LayoutFactory.eINSTANCE.createTitleBlock();
        ((TitleBlockImpl)tb).initialize();
        return tb;
    }

    protected BoundingBox computeBox(IDisplayServer xs, RunTimeContext rtc) throws ChartException {
        Label la = goFactory.copyOf(this.getLabel());
        String sPreviousValue = la.getCaption().getValue();
        la.getCaption().setValue(rtc.externalizedMessage(sPreviousValue));
        la.setEllipsis(1);
        Map<Label, LabelLimiter> mapLimiter = rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        LabelLimiter lbLimiter = mapLimiter.get(this.getLabel());
        lbLimiter.computeWrapping(xs, la);
        int iTitileAnchor = this.getAnchor().getValue();
        EnumSet<LabelLimiter.Option> option = iTitileAnchor == 2 || iTitileAnchor == 6 ? EnumSet.of(LabelLimiter.Option.FIX_HEIGHT) : EnumSet.of(LabelLimiter.Option.FIX_WIDTH);
        IChartComputation cComp = rtc.getState(RunTimeContext.StateKey.CHART_COMPUTATION_KEY);
        LabelLimiter lbLimiterNew = lbLimiter.limitLabelSize(cComp, xs, la, option);
        mapLimiter.put(this.getLabel(), lbLimiterNew);
        return lbLimiterNew.getBounding(null);
    }

    public TitleBlock copyInstance() {
        TitleBlockImpl dest = new TitleBlockImpl();
        dest.set(this);
        return dest;
    }

    protected void set(TitleBlock src) {
        super.set(src);
    }

    public static TitleBlock create(EObject parent, EReference ref) {
        return new TitleBlockImpl();
    }

    public static /* bridge */ /* synthetic */ LabelBlock create(EObject eObject, EReference eReference) {
        return TitleBlockImpl.create(eObject, eReference);
    }
}

