/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Map;
import org.eclipse.birt.chart.device.DisplayAdapter;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.ITextMetrics;
import org.eclipse.birt.chart.device.extension.i18n.Messages;
import org.eclipse.birt.chart.device.swing.SwingImageCache;
import org.eclipse.birt.chart.device.swing.SwingTextMetrics;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.Size;
import org.eclipse.birt.chart.model.attribute.impl.SizeImpl;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.SecurityUtil;

public class SwingDisplayServer
extends DisplayAdapter {
    private transient BufferedImage _bufferedImage = null;
    private transient Graphics2D _g2d = null;
    private transient SwingImageCache _imageCache = null;
    private int iDpiResolution = 0;
    private int userResolution;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swing");

    public SwingDisplayServer() {
        logger.log(1, Messages.getString("SwingDisplayServer.info.display.server", new Object[]{SecurityUtil.getSysProp((String)"java.vendor"), SecurityUtil.getSysProp((String)"java.version")}, this.getULocale()));
        this._imageCache = new SwingImageCache((IDisplayServer)this);
    }

    public void dispose() {
        if (this._bufferedImage != null) {
            this._g2d.dispose();
            this._g2d = null;
            this._bufferedImage = null;
        }
        super.dispose();
    }

    public final Object createFont(FontDefinition fontDef) {
        Map fontAttribs = ChartUtil.newHashMap();
        fontAttribs.put(TextAttribute.FAMILY, fontDef.getName());
        fontAttribs.put(TextAttribute.SIZE, new Float((double)(fontDef.getSize() * (float)this.getDpiResolution()) / 72.0));
        if (fontDef.isItalic()) {
            fontAttribs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        if (fontDef.isBold()) {
            fontAttribs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        if (fontDef.isUnderline()) {
            fontAttribs.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (fontDef.isStrikethrough()) {
            fontAttribs.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        return new Font(fontAttribs);
    }

    public final Object getColor(ColorDefinition colorDef) {
        return new Color(colorDef.getRed(), colorDef.getGreen(), colorDef.getBlue(), colorDef.getTransparency());
    }

    public final Object getMetrics(FontDefinition fontDef) {
        return this.getGraphicsContext().getFontMetrics((Font)this.createFont(fontDef));
    }

    protected int computeScreenDpi() {
        if (GraphicsEnvironment.isHeadless()) {
            return super.getDpiResolution();
        }
        return Toolkit.getDefaultToolkit().getScreenResolution();
    }

    public final int getDpiResolution() {
        if (this.iDpiResolution == 0) {
            switch (this.getGraphicsContext().getDeviceConfiguration().getDevice().getType()) {
                case 0: {
                    this.iDpiResolution = this.computeScreenDpi();
                    break;
                }
                case 1: {
                    this.iDpiResolution = 72;
                    break;
                }
                case 2: {
                    this.iDpiResolution = this.userResolution == 0 ? this.computeScreenDpi() : this.userResolution;
                }
            }
            this.adjustFractionalMetrics();
        }
        return this.iDpiResolution;
    }

    private void adjustFractionalMetrics() {
        if (this.iDpiResolution == 0 || this._g2d == null) {
            return;
        }
        if (this.iDpiResolution >= 192) {
            this._g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            this._g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    public final void setDpiResolution(int dpi) {
        this.userResolution = dpi;
    }

    public Object loadImage(URL url) throws ChartException {
        URL urlFound = this.findResource(url);
        return this._imageCache.loadImage(urlFound);
    }

    public final Size getSize(Object oImage) {
        Image img = (Image)oImage;
        ImageObserver io = (ImageObserver)this._imageCache.getObserver();
        return SizeImpl.create((double)img.getWidth(io), (double)img.getHeight(io));
    }

    public final Object getObserver() {
        return this._imageCache.getObserver();
    }

    public ITextMetrics getTextMetrics(Label label, boolean autoReuse) {
        return new SwingTextMetrics((IDisplayServer)this, label, this.getGraphicsContext(), autoReuse);
    }

    final SwingImageCache getImageCache() {
        return this._imageCache;
    }

    public void setGraphicsContext(Object g2d) {
        if (g2d != this._g2d && this._bufferedImage != null) {
            this._g2d.dispose();
            this._bufferedImage = null;
        }
        this._g2d = (Graphics2D)g2d;
        this.setAntialiasProperties(this._g2d);
    }

    private Graphics2D getGraphicsContext() {
        if (this._g2d == null) {
            this._bufferedImage = new BufferedImage(1, 1, 2);
            this._g2d = (Graphics2D)this._bufferedImage.getGraphics();
            this.setAntialiasProperties(this._g2d);
        }
        return this._g2d;
    }

    private void setAntialiasProperties(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.adjustFractionalMetrics();
    }
}

