/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.viewer.internal.util;

import com.ibm.icu.util.ULocale;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.IActionEvaluator;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.integrate.SimpleActionEvaluator;
import org.eclipse.birt.chart.integrate.SimpleActionRenderer;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.viewer.internal.util.ChartWebHelper;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.mozilla.javascript.Scriptable;

public class ChartImageManager {
    private static final String IMAGE_FOLDER = "imageTemp";
    private static final String IMAGE_NAME_PREFIX = "ChartImage";
    public static String imageFolder = null;
    private static List<String> sessionIds = new ArrayList<String>();
    private static int imageIndex = 0;
    private final HttpServletRequest request;
    private final Chart cm;
    private String sExtension = null;
    private final IDataRowExpressionEvaluator evaluator;
    private final IStyleProcessor styleProc;
    private RunTimeContext rtc = null;
    private IExternalContext externalContext = null;
    private String imageMap = null;
    private File imageFile;
    private int dpi = 72;

    public ChartImageManager(HttpServletRequest httpServletRequest, Chart chart, String string, IDataRowExpressionEvaluator iDataRowExpressionEvaluator, RunTimeContext runTimeContext, IExternalContext iExternalContext, IStyleProcessor iStyleProcessor) throws Exception {
        this.request = httpServletRequest;
        this.cm = chart;
        this.sExtension = string;
        this.evaluator = iDataRowExpressionEvaluator;
        this.styleProc = iStyleProcessor;
        this.externalContext = iExternalContext == null ? new IExternalContext(){
            private static final long serialVersionUID = 4666361117214885689L;

            public Object getObject() {
                return null;
            }

            public Scriptable getScriptable() {
                return null;
            }
        } : iExternalContext;
        if (runTimeContext == null) {
            this.rtc = new RunTimeContext();
            this.rtc.setULocale(ULocale.getDefault());
        } else {
            this.rtc = runTimeContext;
        }
        sessionIds.add(httpServletRequest.getSession().getId());
        this.generateImage();
    }

    private InputStream generateStream() throws BirtException {
        ByteArrayInputStream byteArrayInputStream = null;
        Generator generator = Generator.instance();
        IDeviceRenderer iDeviceRenderer = null;
        try {
            if (this.evaluator == null) {
                if (!ChartWebHelper.isChartInRuntime(this.cm)) {
                    this.cm.createSampleRuntimeSeries();
                }
            } else {
                generator.bindData(this.evaluator, (IActionEvaluator)new SimpleActionEvaluator(), this.cm, this.rtc);
            }
            this.rtc.setActionRenderer((IActionRenderer)new SimpleActionRenderer(this.evaluator));
            iDeviceRenderer = ChartEngine.instance().getRenderer("dv." + this.sExtension.toUpperCase(Locale.US));
            iDeviceRenderer.setProperty("device.resolution", (Object)this.dpi);
            if ("SVG".equalsIgnoreCase(this.sExtension)) {
                iDeviceRenderer.setProperty("resize.svg", (Object)Boolean.TRUE);
            }
            Bounds bounds = this.cm.getBlock().getBounds();
            Bounds bounds2 = bounds.copyInstance();
            GeneratedChartState generatedChartState = generator.build(iDeviceRenderer.getDisplayServer(), this.cm, bounds2, this.externalContext, this.rtc, this.styleProc);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            iDeviceRenderer.setProperty("device.file.identifier", (Object)bufferedOutputStream);
            iDeviceRenderer.setProperty("device.component", (Object)new EmptyUpdateNotifier(this.cm, generatedChartState.getChartModel()));
            generator.render(iDeviceRenderer, generatedChartState);
            try {
                byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                bufferedOutputStream.close();
            }
            catch (Exception exception) {
                throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)exception);
            }
            if (!"SVG".equalsIgnoreCase(this.sExtension) && iDeviceRenderer instanceof IImageMapEmitter) {
                this.imageMap = ((IImageMapEmitter)iDeviceRenderer).getImageMap();
            }
        }
        catch (BirtException birtException) {
            Throwable throwable = birtException;
            while (throwable.getCause() != null) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof ChartException && ((ChartException)throwable).getType() == 16) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (throwable instanceof ChartException && ((ChartException)throwable).getType() == 20) {
                InputStream inputStream = null;
                return inputStream;
            }
            if (throwable instanceof ChartException && ((ChartException)throwable).getType() == 18) {
                InputStream inputStream = null;
                return inputStream;
            }
            throw birtException;
        }
        catch (RuntimeException runtimeException) {
            throw new ChartException("org.eclipse.birt.chart.engine", 3, (Throwable)runtimeException);
        }
        finally {
            if (iDeviceRenderer != null) {
                iDeviceRenderer.dispose();
            }
        }
        return byteArrayInputStream;
    }

    private void generateImage() throws Exception {
        String string = IMAGE_NAME_PREFIX + imageIndex++ + "." + this.sExtension.toLowerCase();
        this.imageFile = new File(this.getAbsoluteImageFolder() + File.separator + string);
        if (!this.imageFile.getParentFile().exists()) {
            this.imageFile.getParentFile().mkdirs();
        }
        this.request.getSession().getServletContext().log("Generated file: " + this.imageFile.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(this.imageFile);
        InputStream inputStream = this.generateStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = inputStream.read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
    }

    public File getImage() {
        return this.imageFile;
    }

    public String getImageMap() {
        return this.imageMap;
    }

    public static synchronized void init(ServletContext servletContext) {
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setProperty("STANDALONE", (Object)"true");
        ChartEngine.instance((PlatformConfig)platformConfig);
        imageFolder = ChartImageManager.processRealPath(servletContext, IMAGE_FOLDER, true);
    }

    public static void dispose(ServletContext servletContext) {
        int n = sessionIds.size();
        for (int i = 0; i < n; ++i) {
            String string = sessionIds.get(i);
            ChartImageManager.clearSessionFiles(string, servletContext);
        }
        sessionIds.clear();
    }

    public static void clearSessionFiles(String string, ServletContext servletContext) {
        if (string == null) {
            return;
        }
        String string2 = imageFolder + File.separator + string;
        File file = new File(string2);
        ChartImageManager.deleteDir(file, servletContext);
    }

    public String getAbsoluteImageFolder() {
        return imageFolder + File.separator + this.request.getSession().getId();
    }

    public String getRelativeImageFolder() {
        return this.request.getContextPath() + "/" + IMAGE_FOLDER + "/" + this.request.getSession().getId();
    }

    private static boolean deleteDir(File file, ServletContext servletContext) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = ChartImageManager.deleteDir(new File(file, stringArray[i]), servletContext);
                if (bl) continue;
                return false;
            }
        }
        servletContext.log("Cleaned file: " + file.getPath());
        return file.delete();
    }

    private static String processRealPath(ServletContext servletContext, String string, boolean bl) {
        String string2 = null;
        if (!new File(string).isAbsolute()) {
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((string2 = ChartImageManager.getRealPath(string, servletContext)) != null && ChartImageManager.makeDir(string2)) {
                if (!bl) {
                    return ChartImageManager.trimSep(string2);
                }
                try {
                    if (bl && new File(string2).canWrite()) {
                        return ChartImageManager.trimSep(string2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            string2 = ChartImageManager.trimSep(System.getProperty("java.io.tmpdir")) + string;
        } else {
            string2 = ChartImageManager.trimSep(string);
        }
        ChartImageManager.makeDir(string2);
        return string2;
    }

    private static String getRealPath(String string, ServletContext servletContext) {
        assert (string != null);
        String string2 = null;
        try {
            URL uRL;
            if (!string.startsWith("/")) {
                string = "/" + string;
            }
            if ((string2 = servletContext.getRealPath(string)) == null && (uRL = servletContext.getResource("/")) != null) {
                string2 = ChartImageManager.trimString(uRL.getFile()) + string;
            }
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    protected static String trimSep(String string) {
        if ((string = ChartImageManager.trimString(string)).endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private static String trimString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    private static boolean makeDir(String string) {
        assert (string != null);
        File file = new File(string);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }
}

