/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.viewer.internal.util;

public class ImageHTMLEmitter {
    public String id = "";
    public String ext = "PNG";
    public String src = "";
    public String alt = "";
    public String imageMap;
    public int width = 0;
    public int height = 0;
    private StringBuffer html = new StringBuffer();

    public String generateHTML() {
        if (this.isSVG()) {
            this.addSVG();
        } else if (this.isPDF()) {
            this.addPDF();
        } else {
            this.addImage();
        }
        return this.html.toString();
    }

    private void addSVG() {
        this.addIFrame();
    }

    private void addSVGEmbed() {
        this.html.append("<div>\n ");
        this.html.append("<embed id=\"" + this.id + "\" type=\"image/svg+xml\" src=\"" + this.src + "\" alt=\"" + this.alt + "\" style=\" width: " + this.width + "pt; height: " + this.height + "pt;\">");
        this.html.append("\n</div>");
    }

    private void addPDF() {
        this.addIFrame();
    }

    private void addImage() {
        this.addImageDiv();
    }

    private void addImageDiv() {
        this.html.append("<div>\n ");
        if (this.imageMap != null) {
            this.html.append("<map name=\"" + this.id + "\">");
            this.html.append(this.imageMap);
            this.html.append("</map>");
        }
        this.html.append("<img id=\"" + this.id + "\" src=\"" + this.src + "\" alt=\"" + this.alt + "\" style=\" width: " + this.width + "; height: " + this.height + ";\" border=0");
        if (this.imageMap != null) {
            this.html.append(" usemap=\"#" + this.id + "\"");
        }
        this.html.append(">");
        this.html.append("\n</div>");
    }

    private void addIFrame() {
        this.html.append("<iframe id=\"" + this.id + "\" src=\"" + this.src + "\" width=" + this.width + " height=" + this.height + " scrolling=\"no\" frameborder=0 ></iframe>\n");
    }

    private void addAutoFresh() {
        int n = 5000;
        String string = "window.frames['" + this.id + "']";
        String string2 = "refreshIFrame_" + this.id + "( )";
        this.html.append("<script language=\"javascript\">\n");
        this.html.append(string + ".onload = " + string2 + ";\n");
        this.html.append("function " + string2 + "\n{\n  ");
        this.html.append("window.setInterval(\"" + string + ".location.reload()\"," + n + ");\n}\n");
        this.html.append("</script>");
    }

    public boolean isSVG() {
        return "SVG".equalsIgnoreCase(this.ext);
    }

    public boolean isPDF() {
        return "PDF".equalsIgnoreCase(this.ext);
    }
}

