/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.viewer.sample;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.datafeed.DifferenceEntry;
import org.eclipse.birt.chart.factory.IDataRowExpressionEvaluator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.integrate.SimpleDataRowExpressionEvaluator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.FontDefinition;
import org.eclipse.birt.chart.model.attribute.HorizontalAlignment;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendBehaviorType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.MarkerType;
import org.eclipse.birt.chart.model.attribute.MultipleFill;
import org.eclipse.birt.chart.model.attribute.Style;
import org.eclipse.birt.chart.model.attribute.StyleMap;
import org.eclipse.birt.chart.model.attribute.StyledComponent;
import org.eclipse.birt.chart.model.attribute.TextAlignment;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.VerticalAlignment;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.FontDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.MultipleFillImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextAlignmentImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.DifferenceDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.DifferenceDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.layout.Plot;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.DifferenceSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.DifferenceSeriesImpl;
import org.eclipse.birt.chart.style.IStyle;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.style.SimpleStyle;

public class SampleHelper {
    private static final String EXPR_CATEGORY = "row[\"Category\"]";
    private static final String EXPR_VALUE = "row[\"Value\"]";
    private static StyleProcessor instance;

    public static IDataRowExpressionEvaluator createSampleHeaderEvaluator() {
        String[] stringArray = new String[]{EXPR_CATEGORY, EXPR_VALUE};
        Object[][] objectArray = new Object[][]{{"Chart", "Data", "Report", "ReportEngine", "ReportDesigner"}, {100, 80, 60, 90, 120}};
        return new SimpleDataRowExpressionEvaluator(stringArray, objectArray);
    }

    public static IDataRowExpressionEvaluator createSampleDetailsEvaluator(String string) {
        Object[][] objectArray;
        String[] stringArray;
        int n = 0;
        IDataRowExpressionEvaluator iDataRowExpressionEvaluator = SampleHelper.createSampleHeaderEvaluator();
        if (iDataRowExpressionEvaluator.first()) {
            do {
                if (!string.equals(stringArray = iDataRowExpressionEvaluator.evaluate(EXPR_CATEGORY))) continue;
                objectArray = iDataRowExpressionEvaluator.evaluate(EXPR_VALUE);
                if (!(objectArray instanceof Integer)) break;
                n = (Integer)objectArray;
                break;
            } while (iDataRowExpressionEvaluator.next());
        }
        stringArray = new String[]{EXPR_CATEGORY, EXPR_VALUE};
        objectArray = new Object[][]{{"2005", "2006", "2007", "2008"}, {(double)n * 0.3, Math.round((double)n * 0.24), Math.round((double)n * 0.26), (double)n * 0.2}};
        return new SimpleDataRowExpressionEvaluator(stringArray, objectArray);
    }

    public static synchronized StyleProcessor getSampleStyleProcessor() {
        if (instance == null) {
            instance = new StyleProcessor();
        }
        return instance;
    }

    public static RunTimeContext createSampleRuntimeContext(ULocale uLocale) {
        RunTimeContext runTimeContext = new RunTimeContext();
        runTimeContext.setULocale(uLocale);
        return runTimeContext;
    }

    public static Chart createSampleRuntimeChart() {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)255, (int)255, (int)225));
        chartWithAxes.getTitle().getLabel().getCaption().setValue("Price difference among years");
        chartWithAxes.getLegend().setVisible(true);
        chartWithAxes.getInteractivity().setEnable(true);
        chartWithAxes.getInteractivity().setLegendBehavior(LegendBehaviorType.HIGHLIGHT_SERIE_LITERAL);
        Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
        axis.setType(AxisType.TEXT_LITERAL);
        axis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        axis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        axis.getTitle().setVisible(true);
        axis.getTitle().getCaption().setValue("Year");
        Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
        axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        axis2.getTitle().setVisible(true);
        axis2.getTitle().getCaption().setValue("Price");
        TextDataSet textDataSet = TextDataSetImpl.create((Object)new String[]{"2005", "2006", "2007", "2008"});
        DifferenceDataSet differenceDataSet = DifferenceDataSetImpl.create((Object)new DifferenceEntry[]{new DifferenceEntry(50.0, 60.0), new DifferenceEntry(70.0, 70.0), new DifferenceEntry(15.0, 30.0), new DifferenceEntry(65.0, 20.0)});
        Series series = SeriesImpl.create();
        series.setDataSet((DataSet)textDataSet);
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add((Object)series);
        DifferenceSeries differenceSeries = (DifferenceSeries)DifferenceSeriesImpl.create();
        differenceSeries.setSeriesIdentifier((Object)"Diff");
        differenceSeries.setDataSet((DataSet)differenceDataSet);
        differenceSeries.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
        for (int i = 0; i < differenceSeries.getMarkers().size(); ++i) {
            ((Marker)differenceSeries.getMarkers().get(i)).setType(MarkerType.TRIANGLE_LITERAL);
        }
        differenceSeries.setCurve(true);
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().shift(-2);
        axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
        MultipleFill multipleFill = MultipleFillImpl.create();
        multipleFill.getFills().add((Object)ColorDefinitionImpl.CYAN());
        multipleFill.getFills().add((Object)ColorDefinitionImpl.RED());
        seriesDefinition2.getSeriesPalette().getEntries().add(0, (Object)multipleFill);
        seriesDefinition2.getSeries().add((Object)differenceSeries);
        return chartWithAxes;
    }

    public static final Chart createSampleDesignTimeChart(String string, String string2, String string3) {
        ChartWithAxes chartWithAxes = ChartWithAxesImpl.create();
        chartWithAxes.getBlock().setBackground((Fill)ColorDefinitionImpl.WHITE());
        Plot plot = chartWithAxes.getPlot();
        plot.getClientArea().setBackground((Fill)ColorDefinitionImpl.create((int)225, (int)225, (int)225));
        chartWithAxes.getTitle().getLabel().getCaption().setValue(string);
        chartWithAxes.getTitle().setVisible(true);
        Legend legend = chartWithAxes.getLegend();
        legend.getText().getFont().setSize(16.0f);
        legend.getInsets().set(10.0, 5.0, 0.0, 0.0);
        legend.getOutline().setVisible(false);
        legend.setItemType(LegendItemType.CATEGORIES_LITERAL);
        Axis axis = chartWithAxes.getPrimaryBaseAxes()[0];
        axis.setType(AxisType.TEXT_LITERAL);
        axis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        axis.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLUE(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        axis.getMinorGrid().getLineAttributes().setVisible(true);
        axis.getOrigin().setType(IntersectionType.MIN_LITERAL);
        axis.getTitle().getCaption().setValue(string2);
        axis.getTitle().setVisible(true);
        axis.getTitle().getCaption().getFont().setRotation(0.0);
        axis.getLabel().setVisible(true);
        Axis axis2 = chartWithAxes.getPrimaryOrthogonalAxis(axis);
        axis2.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        axis2.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)ColorDefinitionImpl.BLACK(), (LineStyle)LineStyle.SOLID_LITERAL, (int)1));
        axis2.getMinorGrid().getLineAttributes().setVisible(true);
        axis2.setPercent(false);
        axis2.getTitle().getCaption().setValue(string3);
        axis2.getTitle().setVisible(true);
        axis2.getTitle().getCaption().getFont().setRotation(90.0);
        axis2.getLabel().setVisible(true);
        Series series = SeriesImpl.create();
        series.getDataDefinition().add((Object)QueryImpl.create((String)EXPR_CATEGORY));
        SeriesDefinition seriesDefinition = SeriesDefinitionImpl.create();
        seriesDefinition.getSeriesPalette().shift(0);
        axis.getSeriesDefinitions().add((Object)seriesDefinition);
        seriesDefinition.getSeries().add((Object)series);
        AreaSeries areaSeries = (AreaSeries)AreaSeriesImpl.create();
        areaSeries.setTranslucent(true);
        areaSeries.getLineAttributes().setColor(ColorDefinitionImpl.BLUE());
        areaSeries.getLabel().setVisible(true);
        areaSeries.setCurve(true);
        areaSeries.getDataDefinition().add((Object)QueryImpl.create((String)EXPR_VALUE));
        SeriesDefinition seriesDefinition2 = SeriesDefinitionImpl.create();
        seriesDefinition2.getSeriesPalette().shift(-1);
        axis2.getSeriesDefinitions().add((Object)seriesDefinition2);
        seriesDefinition2.getSeries().add((Object)areaSeries);
        return chartWithAxes;
    }

    static final class StyleProcessor
    implements IStyleProcessor {
        private static final SimpleStyle sstyle;

        private StyleProcessor() {
        }

        public IStyle getStyle(Chart chart, StyledComponent styledComponent) {
            if (chart != null && chart.getStyles().size() > 0) {
                for (StyleMap styleMap : chart.getStyles()) {
                    if (!styleMap.getComponentName().equals((Object)styledComponent)) continue;
                    Style style = styleMap.getStyle();
                    SimpleStyle simpleStyle = new SimpleStyle((IStyle)sstyle);
                    if (style.getFont() != null) {
                        simpleStyle.setFont(style.getFont().copyInstance());
                    }
                    if (style.getColor() != null) {
                        simpleStyle.setColor(style.getColor().copyInstance());
                    }
                    if (style.getBackgroundColor() != null) {
                        simpleStyle.setBackgroundColor(style.getBackgroundColor().copyInstance());
                    }
                    if (style.getBackgroundImage() != null) {
                        simpleStyle.setBackgroundImage(style.getBackgroundImage().copyInstance());
                    }
                    if (style.getPadding() != null) {
                        simpleStyle.setPadding(style.getPadding().copyInstance());
                    }
                    return simpleStyle;
                }
            }
            return sstyle.copy();
        }

        static {
            TextAlignment textAlignment = TextAlignmentImpl.create();
            textAlignment.setHorizontalAlignment(HorizontalAlignment.CENTER_LITERAL);
            textAlignment.setVerticalAlignment(VerticalAlignment.BOTTOM_LITERAL);
            FontDefinition fontDefinition = FontDefinitionImpl.create((String)"BookAntique", (float)14.0f, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)true, (double)0.0, (TextAlignment)textAlignment);
            sstyle = new SimpleStyle(fontDefinition, ColorDefinitionImpl.create((int)10, (int)100, (int)200), ColorDefinitionImpl.CREAM(), null, InsetsImpl.create((double)1.0, (double)1.0, (double)1.0, (double)1.0));
        }
    }
}

