/*******************************************************************************
 * Copyright (c) 2009 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.chart.device.image;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;

import org.eclipse.birt.chart.model.attribute.MultiURLValues;
import org.eclipse.birt.chart.model.attribute.URLValue;

/**
 * The class generates javascript contents for multiple URL values.
 * 
 * @since 2.5
 */

public class MultiURLValuesScriptGenerator
{
	private MultiURLValues fURLValues;

	private static final String SHOW_MENU_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function showMenu()  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		var redge=document.body.clientWidth-evt.clientX;  "); //$NON-NLS-1$
		sb.append("\n		var bedge=document.body.clientHeight-evt.clientY;  "); //$NON-NLS-1$
		sb.append("\n		var menu = document.getElementById( rightMenuName );  "); //$NON-NLS-1$
		sb.append("\n		if (redge<menu.offsetWidth) {  "); //$NON-NLS-1$
		sb.append("\n			menu.style.left=document.body.scrollLeft + evt.clientX-menu.offsetWidth + 'px';  "); //$NON-NLS-1$
		sb.append("\n		} else {  "); //$NON-NLS-1$
		sb.append("\n			menu.style.left=document.body.scrollLeft + evt.clientX + 'px';  "); //$NON-NLS-1$
		sb.append("\n		}  "); //$NON-NLS-1$
		sb.append("\n		if (bedge<menu.offsetHeight) {  "); //$NON-NLS-1$
		sb.append("\n			menu.style.top=document.body.scrollTop - document.body.getBoundingClientRect().top + evt.clientY - menu.offsetHeight + 'px';  "); //$NON-NLS-1$
		sb.append("\n		} else {  "); //$NON-NLS-1$
		sb.append("\n			menu.style.top = document.body.scrollTop - document.body.getBoundingClientRect().top + evt.clientY + 'px';  "); //$NON-NLS-1$
		sb.append("\n		}  "); //$NON-NLS-1$
		sb.append("\n		menu.style.display = 'block';  "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		SHOW_MENU_FUNCTION = sb.toString( );
	}
	
	private static final String HIDE_MENU_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function hideMenu()  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		document.getElementById( rightMenuName ).style.display='none';  "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		HIDE_MENU_FUNCTION = sb.toString( );
	}
	
	private static final String ON_MOUSE_OVER_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function onMouseOver( )  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		try {  "); //$NON-NLS-1$
		sb.append("\n			window.clearTimeout(hideTimer);  "); //$NON-NLS-1$
		sb.append("\n		} catch(e) {  "); //$NON-NLS-1$
		sb.append("\n		};  "); //$NON-NLS-1$
		sb.append("\n		  "); //$NON-NLS-1$
		sb.append("\n		setOnMouseOverStyle( this.style );  "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		ON_MOUSE_OVER_FUNCTION = sb.toString( );
	}
	
	private static final String ON_MOUSE_OUT_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function onMouseOut()  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		hideTimer = window.setTimeout(\"document.getElementById( '\" +rightMenuName + \"').style.display='none';\", 300);  "); //$NON-NLS-1$
		sb.append("\n		setOnMouseOutStyle( this.style );  "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		ON_MOUSE_OUT_FUNCTION = sb.toString( );
	}
	
	private static final String CREATE_MENU_ITEM_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function createMenuItem( menuItemName, displayText, urlLink, urlTarget, tooltip )  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		var divMenuItem          = document.createElement('Div');  "); //$NON-NLS-1$
		sb.append("\n		divMenuItem.className   = menuItemName;  "); //$NON-NLS-1$
		sb.append("\n		if ( tooltip ) divMenuItem.title = tooltip; "); //$NON-NLS-1$
		sb.append("\n		else  divMenuItem.title = '';  "); //$NON-NLS-1$
		sb.append("\n		divMenuItem.onmouseover = onMouseOver;  "); //$NON-NLS-1$
		sb.append("\n		divMenuItem.onmouseout  = onMouseOut;  "); //$NON-NLS-1$
		sb.append("\n		divMenuItem.onclick     = function( ) {  ");  //$NON-NLS-1$
		sb.append("\n					hideMenu();  "); //$NON-NLS-1$
		sb.append("\n					var url = urlLink;  "); //$NON-NLS-1$
		sb.append("\n					var target = '_blank'; "); //$NON-NLS-1$
		sb.append("\n					if ( urlTarget ) target = urlTarget;  "); //$NON-NLS-1$
		sb.append("\n					if ( !target || target == '' ) target = '_self';  "); //$NON-NLS-1$
		sb.append("\n					if ( url.indexOf('#', 0) == 0 ) {  "); //$NON-NLS-1$
		sb.append("\n						window.location= url;  "); //$NON-NLS-1$
		sb.append("\n						return;	  "); //$NON-NLS-1$
		sb.append("\n					}  "); //$NON-NLS-1$
		sb.append("\n					if ( url.indexOf( 'javascript:', 0) == 0 ) {  "); //$NON-NLS-1$
		sb.append("\n						eval( url.substring( 11, url.length -1 ) ) ;  "); //$NON-NLS-1$
		sb.append("\n						return;  "); //$NON-NLS-1$
		sb.append("\n					}  "); //$NON-NLS-1$
		sb.append("\n					try {  ");	 //$NON-NLS-1$
		sb.append("\n						window.open( url, target );	  ");  //$NON-NLS-1$
		sb.append("\n					} catch( e ) {  "); //$NON-NLS-1$
		sb.append("\n						redirect( target, url );  ");	 //$NON-NLS-1$
		sb.append("\n					}  "); //$NON-NLS-1$
		sb.append("\n		}; "); //$NON-NLS-1$
		sb.append("\n		divMenuItem.innerHTML   = displayText;  "); //$NON-NLS-1$
		sb.append("\n	 	setMenuItemStyle( divMenuItem.style );  "); //$NON-NLS-1$
		sb.append("\n		return divMenuItem;  "); //$NON-NLS-1$
		sb.append("\n	}   "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		CREATE_MENU_ITEM_FUNCTION = sb.toString( );
	}
	
	private static final String CREATE_MENU_FUNCTION;
	static {
		StringBuilder sb = new StringBuilder();
		sb.append("\n	function createMenu( menuName )  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		var divMenu          = document.createElement('Div');  "); //$NON-NLS-1$
		sb.append("\n		divMenu.style.display='none';  "); //$NON-NLS-1$
		sb.append("\n		divMenu.id           = menuName;  "); //$NON-NLS-1$
		sb.append("\n		divMenu.className    = menuName;  "); //$NON-NLS-1$
		sb.append("\n		setMenuStyle( divMenu.style );  "); //$NON-NLS-1$
		sb.append("\n		return divMenu;   "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		CREATE_MENU_FUNCTION = sb.toString( );
	}
	
	/**
	 * Consturctor.
	 * 
	 * @param urlValues
	 */
	public MultiURLValuesScriptGenerator( MultiURLValues urlValues )
	{
		fURLValues = urlValues;
	}
	
	/**
	 * Returns javascript content.
	 * 
	 * @return
	 */
	public String getJSContent()
	{
		StringBuilder sb = generateMenuBase( );
		
		sb.append( generateMenu( sb.hashCode( ) ) );
		return sb.toString( );
	}

	/**
	 * Returns javascript key for current URL values.
	 * 
	 * @return
	 */
	public String getJSKey()
	{
		return generateMenuBase( ).toString( );
	}
	
	/**
	 * @return
	 */
	private StringBuilder generateMenuBase( )
	{
		StringBuilder sb = new StringBuilder();
		sb.append("\n	var hideTimer;  ");                                                                                                      //$NON-NLS-1$
		sb.append("\n	var rightMenuName = 'div_RightMenu';  "); //$NON-NLS-1$
		sb.append("\n	var menuItemName = 'divMenuItem';  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		
		sb.append( SHOW_MENU_FUNCTION );
		sb.append( HIDE_MENU_FUNCTION );
		sb.append( ON_MOUSE_OVER_FUNCTION );
		sb.append( ON_MOUSE_OUT_FUNCTION );
		
		for ( Entry<String, String> e : fURLValues.getPropertiesMap( ).entrySet( ) )
		{
			String properties = e.getValue( );
			sb.append( generateSetStyle( e.getKey(), properties ) );
		}
		sb.append( CREATE_MENU_FUNCTION );
		sb.append( CREATE_MENU_ITEM_FUNCTION );

		return sb;
	}
		
	private String generateSetStyle( String key, String properties )
	{
		List<String[]> attributes = deserializeProperties( properties );
		StringBuffer sb = new StringBuffer();
		sb.append("\n	function set" + key +"Style( style )  "); //$NON-NLS-1$ //$NON-NLS-2$
		sb.append("\n	{  "); //$NON-NLS-1$
		
		for ( String[] att : attributes ) 
		{
			sb.append( "\n    style." + att[0] + "=\"" + att[1] + "\";");  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		}
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		return sb.toString( );
	}

	private String generateMenu( int uniqueKey ) 
	{
		StringBuilder sb = new StringBuilder();
		sb.append("\n   rightMenuName = rightMenuName + " + uniqueKey ); //$NON-NLS-1$
		sb.append("\n   menuItemName = menuItemName + " + uniqueKey ); //$NON-NLS-1$
		sb.append("\n	if(document.getElementById(rightMenuName) != null)  "); //$NON-NLS-1$
		sb.append("\n	{  "); //$NON-NLS-1$
		sb.append("\n		document.body.removeChild(document.getElementById(rightMenuName));  "); //$NON-NLS-1$
		sb.append("\n	}  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$

		sb.append("\n	var divMenu = createMenu(rightMenuName);  "); //$NON-NLS-1$
		sb.append("\n	document.body.appendChild(divMenu);   "); //$NON-NLS-1$
		
		for ( URLValue uv : getValidURLValues( fURLValues ) )
		{
			String target = uv.getTarget( ) == null ? "" : uv.getTarget( );//$NON-NLS-1$
			String url = uv.getBaseUrl( );
			if ( !( url.startsWith( "\"" ) || url.endsWith( "\"" ) ) )//$NON-NLS-1$ //$NON-NLS-2$
			{
				url = "\"" + url + "\"";//$NON-NLS-1$ //$NON-NLS-2$
			}
			sb.append( "\n    divMenu.appendChild( createMenuItem( menuItemName," ); //$NON-NLS-1$
			sb.append( " '" + uv.getLabel( ).getCaption( ).getValue( ) + "'," ); //$NON-NLS-1$ //$NON-NLS-2$
			sb.append( url + "," );//$NON-NLS-1$
			if ( uv.getTooltip( ) != null && uv.getTooltip( ).trim( ).length( ) > 0 )
			{
				sb.append( " '" + target + "'," ); //$NON-NLS-1$//$NON-NLS-2$
				sb.append( " '" + uv.getTooltip( ) + "' ) );" );//$NON-NLS-1$//$NON-NLS-2$
			}
			else
				sb.append( " '" + target + "' ) );" ); //$NON-NLS-1$//$NON-NLS-2$	
		}
		
		sb.append("\n	document.body.oncontextmenu = hideMenu;  "); //$NON-NLS-1$
		sb.append("\n	  "); //$NON-NLS-1$
		sb.append("\n	showMenu();   "); //$NON-NLS-1$
		sb.append( "\n" ); //$NON-NLS-1$
		return sb.toString( );
	}
	
	private List<String[]> deserializeProperties( String properties )
	{
		String[] attributes = properties.split( ";" ); //$NON-NLS-1$
		List<String[]> AttrList = new ArrayList<String[]>( attributes.length );
		for ( String v : attributes )
		{
			int index = v.indexOf( ':' );
			String[] element = new String[2];
			element[0] = v.substring( 0, index );
			element[1] = v.substring( index + 1 );
			AttrList.add( element );
		}

		return AttrList;
	}
	
	/**
	 * @param multiUrlValue
	 * @return
	 */
	public static List<URLValue> getValidURLValues( MultiURLValues multiUrlValue )
	{
		List<URLValue> validURLValues = new ArrayList<URLValue>();
		for ( URLValue uv : ((MultiURLValues)multiUrlValue).getURLValues( ) )
		{
			if ( uv.getBaseUrl( ) == null
					|| uv.getBaseUrl( ).length( ) <= 0
					|| uv.getBaseUrl( ).equals( "\"\"" ) )//$NON-NLS-1$
			{
				continue;
			}
			validURLValues.add( uv );
		}
		return validURLValues;
	}
}
