/***********************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.device.svg;


/**
 * This class provides javascript helper functions to enable user interactions
 * such as tooltip support. Defines default styles for svg elements.
 */
public final class EventHandlers
{

	public static final StringBuffer STYLES = new StringBuffer( ).append( ".tooltip.text{ text-anchor:start;font-size:12pt;fill:black;}.tooltip{fill:rgb(244,245,235)}" ); //$NON-NLS-1$

	public static final StringBuffer CONTENT = new StringBuffer( ).append( "function BuildHelper(tag, attrList, text) {\n" ) //$NON-NLS-1$
			.append( "	this.tag = tag;\n" ) //$NON-NLS-1$
			.append( "	this.attrList = attrList;\n" ) //$NON-NLS-1$
			.append( "	this.text       = text;\n" ) //$NON-NLS-1$
			.append( "	this.element  = null;\n" ) //$NON-NLS-1$
			.append( "	this.textNode = null;\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	BuildHelper.prototype.addToParent= function(parent) {	\n" ) //$NON-NLS-1$
			.append( "	if (!parent) return;	\n" ) //$NON-NLS-1$
			.append( "	var svgDocument = parent.ownerDocument;\n" ) //$NON-NLS-1$
			.append( "	this.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	for (var attribute in this.attrList){\n" ) //$NON-NLS-1$
			.append( "	if (attribute == 'classType')	\n" ) //$NON-NLS-1$
			.append( "		     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);\n" ) //$NON-NLS-1$
			.append( "	else	\n" ) //$NON-NLS-1$
			.append( "		     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	if (this.text) {\n" ) //$NON-NLS-1$
			.append( "		this.textNode = svgDocument.createTextNode(this.text);\n" ) //$NON-NLS-1$
			.append( "		this.element.appendChild(this.textNode);\n" ) //$NON-NLS-1$
			.append( "	}\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	parent.appendChild(this.element);\n" ) //$NON-NLS-1$
			.append( "	};	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "BuildHelper.prototype.insertBefore = function(parent, before) {\n" ) //$NON-NLS-1$
			.append( "	if (typeof parent == 'undefined') return;	\n" ) //$NON-NLS-1$
			.append( "	var svgDocument = parent.ownerDocument;\n" ) //$NON-NLS-1$
			.append( "	this.element = svgDocument.createElementNS(\"http://www.w3.org/2000/svg\",this.tag);\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	for (var attribute in this.attrList){\n" ) //$NON-NLS-1$
			.append( "	if (attribute == 'classType')	\n" ) //$NON-NLS-1$
			.append( "		     this.element.setAttributeNS(null, 'class', this.attrList[attribute]);\n" ) //$NON-NLS-1$
			.append( "	else	\n" ) //$NON-NLS-1$
			.append( "		     this.element.setAttributeNS(null, attribute, this.attrList[attribute]);\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	if (this.text) {\n" ) //$NON-NLS-1$
			.append( "		this.textNode = svgDocument.createTextNode(this.text);\n" ) //$NON-NLS-1$
			.append( "		this.element.appendChild(textNode);\n" ) //$NON-NLS-1$
			.append( "	}\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	parent.insertBefore(this.element, before);\n" ) //$NON-NLS-1$
			.append( "	};	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	BuildHelper.prototype.removeNode = function() {	\n" ) //$NON-NLS-1$
			.append( "	if (this.element) this.element.parentNode.removeChild(this.element);\n" ) //$NON-NLS-1$
			.append( "	this.tag = \"\";\n" ) //$NON-NLS-1$
			.append( "	this.attrList = null;\n" ) //$NON-NLS-1$
			.append( "	this.text = null;\n" ) //$NON-NLS-1$
			.append( "	this.element = null;\n" ) //$NON-NLS-1$
			.append( "	this.textNode = null;\n" ) //$NON-NLS-1$
			.append( "	};	\n" ) //$NON-NLS-1$
			.append( "	function TM(){	\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "TM.setParent = function TooltipManager_setParent(parent, mainSvg){\n" ) //$NON-NLS-1$
			.append( "	this.parent = parent;	\n" ) //$NON-NLS-1$
			.append( "	this.mainSvg = mainSvg	\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	TM.toggleToolTip = function TooltipManager_toggleToolTip(evt){	\n" ) //$NON-NLS-1$
			.append( "	if (typeof this.group != 'undefined'){	\n" ) //$NON-NLS-1$
			.append( "	  TM.remove();\n" ) //$NON-NLS-1$
			.append( "	}else{	\n" ) //$NON-NLS-1$
			.append( "	  TM.show(evt);\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "	TM.remove = function TooltipManager_removeTooltip(){	\n" ) //$NON-NLS-1$
			.append( "	if (typeof this.group != 'undefined'){	\n" ) //$NON-NLS-1$
			.append( "	  this.group.removeNode();\n" ) //$NON-NLS-1$
			.append( "	  this.group = undefined;\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "	}	\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "			TM.show = function TooltiplManager_showTooltip(evt,id,title){	\n" ) //$NON-NLS-1$
			.append( "        if (id != null && typeof id != 'undefined'){	\n" ) //$NON-NLS-1$
			.append( "     	       var mainSvg = evt.target.ownerDocument;	\n" ) //$NON-NLS-1$
			.append( "               var comp = mainSvg.getElementById(id);	\n" ) //$NON-NLS-1$
			.append( "               var styleStr = comp.getAttribute(\"style\");	\n" ) //$NON-NLS-1$
			.append( "               rHiddenExp=/visibility:[ ]*hidden/g;	\n" ) //$NON-NLS-1$
			.append( "               results = styleStr.search(rHiddenExp);	\n" ) //$NON-NLS-1$
			.append( "               if (results != -1)	\n" ) //$NON-NLS-1$
			.append( "     		       return;	\n" ) //$NON-NLS-1$
			.append( "     }	\n" ) //$NON-NLS-1$
			.append( "		var text = TM.getText(TM.getTitleElement(evt));	\n" ) //$NON-NLS-1$
			.append( "		if ( title) text = TM.getText( title );	\n" ) //$NON-NLS-1$
			.append( "		x = evt.clientX;	\n" ) //$NON-NLS-1$
			.append( "		y = evt.clientY;	\n" ) //$NON-NLS-1$
			.append( "		update = true;\n" ) //$NON-NLS-1$
			.append( "	    if (this.oldX != 'undefined'){\n" ) //$NON-NLS-1$
			.append( "	      diffX = (x - this.oldX);\n" ) //$NON-NLS-1$
			.append( "	      if (diffX < 0) diffX= diffX*(-1);\n" ) //$NON-NLS-1$
			.append( "	      diffY = (y - this.oldY);\n" ) //$NON-NLS-1$
			.append( "	      if (diffY < 0) diffY= diffY*(-1);\n" ) //$NON-NLS-1$
			.append( "	      if ((diffY > 5) || (diffX > 5))\n" ) //$NON-NLS-1$
			.append( "	        update = true;\n" ) //$NON-NLS-1$
			.append( "	    }\n" ) //$NON-NLS-1$
			.append( "	    if (update)\n" ) //$NON-NLS-1$
			.append( "	       TM.remove();			\n" ) //$NON-NLS-1$
			.append( "		if (typeof this.group == 'undefined'){	\n" ) //$NON-NLS-1$
			.append( "	           this.oldX = x;\n" ) //$NON-NLS-1$
			.append( "	           this.oldY = y;		\n" ) //$NON-NLS-1$
			.append( "	   	   this.height = 15;	\n" ) //$NON-NLS-1$
			.append( "	 	   this.xPadding = 5;	\n" ) //$NON-NLS-1$
			.append( "		   this.yPadding = 20;\n" ) //$NON-NLS-1$
			.append( "		   var mainSvg = evt.target.ownerDocument.documentElement;\n" ) //$NON-NLS-1$
			.append( "		   var off = mainSvg.currentTranslate;\n" ) //$NON-NLS-1$
			.append( "		   var scl = mainSvg.currentScale;\n" ) //$NON-NLS-1$
			.append( "	           var adjustedX = (x-off.x)/scl;\n" ) //$NON-NLS-1$
			.append( "	           var adjustedY = (y-off.y)/scl;\n" ) //$NON-NLS-1$
			.append( "		   this.group = new BuildHelper(\"g\",\n" ) //$NON-NLS-1$
			.append( "		     {\n" ) //$NON-NLS-1$
			.append( "	             opacity:0.8,\n" ) //$NON-NLS-1$
			.append( "	  	     display: \"inline\",\n" ) //$NON-NLS-1$
			.append( "		     transform:\"translate(\"+(adjustedX + (10/scl))+\",\"+(adjustedY + (10/scl))+\")\"\n" ) //$NON-NLS-1$
			.append( "		 } );\n" ) //$NON-NLS-1$
			.append( "		   this.group.addToParent(mainSvg);\n" ) //$NON-NLS-1$
			.append( "		   this.rectangle = new BuildHelper(\"rect\",\n" ) //$NON-NLS-1$
			.append( "		     {id:\"test\",\n" ) //$NON-NLS-1$
			.append( "		      x: 0,\n" ) //$NON-NLS-1$
			.append( "		      y: 5,\n" ) //$NON-NLS-1$
			.append( "		      transform:\"scale(\"+(1/scl)+\",\"+(1/scl)+\")\",\n" ) //$NON-NLS-1$
			.append( "	              rx: 2,\n" ) //$NON-NLS-1$
			.append( "	              ry: 2,\n" ) //$NON-NLS-1$
			.append( "	              stroke: \"black\",\n" ) //$NON-NLS-1$
			.append( "		      height: this.height,\n" ) //$NON-NLS-1$
			.append( "		      classType: \"tooltip\"\n" ) //$NON-NLS-1$
			.append( "		 } );\n" ) //$NON-NLS-1$
			.append( "		   this.rectangle.addToParent(this.group.element);\n" ) //$NON-NLS-1$
			.append( "		   var textObj = new BuildHelper(\"text\",\n" ) //$NON-NLS-1$
			.append( "		     {id:\"tooltip\",\n" ) //$NON-NLS-1$
			.append( "		      x: this.xPadding,\n" ) //$NON-NLS-1$
			.append( "		      y: (this.yPadding),\n" ) //$NON-NLS-1$
			.append( "		      transform:\"scale(\"+(1/scl)+\",\"+(1/scl)+\")\",\n" ) //$NON-NLS-1$
			.append( "		      classType: \"tooltip text\"\n" ) //$NON-NLS-1$
			.append( "		 });\n" ) //$NON-NLS-1$
			.append( "		   textObj.addToParent(this.group.element);\n" ) //$NON-NLS-1$
			.append( "	           TM.setContent(textObj, text);\n" ) //$NON-NLS-1$
			.append( "	           var outline = textObj.element.getBBox();\n" ) //$NON-NLS-1$
			.append( "                   var tooltipHeight = outline.height+6;\n" ) //$NON-NLS-1$
			.append( "                   if ( tooltipHeight < 17 ) tooltipHeight = 17;\n" ) //$NON-NLS-1$
			.append( "                   var tooltipWidth = outline.width+2*this.xPadding;\n" ) //$NON-NLS-1$
			.append( "                   var root=evt.target.ownerDocument.documentElement;\n" ) //$NON-NLS-1$
			.append( "                   var rootWidth =root.getAttribute('width');\n" ) //$NON-NLS-1$
			.append( "                   var rootHeight = root.getAttribute('height');\n" ) //$NON-NLS-1$
			.append( "                   if (((y+tooltipHeight)> rootHeight) || ((x+tooltipWidth)> rootWidth)){\n" ) //$NON-NLS-1$
			.append( "                      var transformX = x + this.xPadding;\n" ) //$NON-NLS-1$
			.append( "                      var transformY = y+ this.yPadding;\n" ) //$NON-NLS-1$
			.append( "                      if ((y+tooltipHeight)> rootHeight)\n" ) //$NON-NLS-1$
			.append( "                        transformY  = (rootHeight-tooltipHeight)-this.yPadding;\n" ) //$NON-NLS-1$
			.append( "                   if ((x+tooltipWidth)> rootWidth)\n" ) //$NON-NLS-1$
			.append( "                        transformX  = (rootWidth-tooltipWidth)-this.xPadding;\n" ) //$NON-NLS-1$
			.append( "                      this.group.element.setAttributeNS(null, \"transform\", \"translate(\"+(transformX*xScale)+\", \"+(transformY*yScale)+\")\");\n" ) //$NON-NLS-1$
			.append( "                   }\n" ) //$NON-NLS-1$
			.append( "                   this.rectangle.element.setAttributeNS(null, \"width\", tooltipWidth);\n" ) //$NON-NLS-1$
			.append( "                   this.rectangle.element.setAttributeNS(null, \"height\", tooltipHeight);\n" ) //$NON-NLS-1$
			.append( "		  }\n" ) //$NON-NLS-1$
			.append( "		}\n" ) //$NON-NLS-1$
			.append( "		TM.setContent = function TooltipManager_setContent(textElement, text){\n" ) //$NON-NLS-1$
			.append( "		    text = text.replace(/\\n/g, \"\\\\n\");\n" ) //$NON-NLS-1$
			.append( "		    var multiLine = text.split(/\\\\n/);\n" ) //$NON-NLS-1$
			.append( "		    for (var x=0; x<multiLine.length; x++){\n" ) //$NON-NLS-1$
			.append( "			if (x == 0){\n" ) //$NON-NLS-1$
			.append( "	 	         textObj = new BuildHelper(\"tspan\",\n" ) //$NON-NLS-1$
			.append( "	   	             {x: 5\n" ) //$NON-NLS-1$
			.append( "		             },multiLine[x]);\n" ) //$NON-NLS-1$
			.append( "	                 }\n" ) //$NON-NLS-1$
			.append( "	                 else{\n" ) //$NON-NLS-1$
			.append( "	 	         textObj = new BuildHelper(\"tspan\",\n" ) //$NON-NLS-1$
			.append( "	   	             {x: 5,\n" ) //$NON-NLS-1$
			.append( "	                      dy:17\n" ) //$NON-NLS-1$
			.append( "		             },multiLine[x]);\n" ) //$NON-NLS-1$
			.append( "	                 }\n" ) //$NON-NLS-1$
			.append( "		      textObj.addToParent(textElement.element);\n" ) //$NON-NLS-1$
			.append( "	            }\n" ) //$NON-NLS-1$
			.append( "	        }\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	TM.getTitleElement = function TM_getTitleElement(evt){\n" ) //$NON-NLS-1$
			.append( "	    var elem = evt.currentTarget;\n" ) //$NON-NLS-1$
			.append( "	if (elem == null ) return;	\n" ) //$NON-NLS-1$
			.append( "	    var childs = elem.childNodes;\n" ) //$NON-NLS-1$
			.append( "	    for (var x=0; x<childs.length; x++){\n" ) //$NON-NLS-1$
			.append( "		if (childs.item(x).nodeType == 1 && childs.item(x).nodeName == \"title\")\n" ) //$NON-NLS-1$
			.append( "		    return childs.item(x);\n" ) //$NON-NLS-1$
			.append( "	    }\n" ) //$NON-NLS-1$
			.append( "	    return null;\n" ) //$NON-NLS-1$
			.append( "	}\n" ) //$NON-NLS-1$
			.append( "		\n" ) //$NON-NLS-1$
			.append( "	TM.getText = function TM_getText(elem){\n" ) //$NON-NLS-1$
			.append( "	   var childs = elem ? elem.childNodes : null;\n" ) //$NON-NLS-1$
			.append( "	   for (var x = 0;  childs && x < childs.length; x++)\n" ) //$NON-NLS-1$
			.append( "	      if (childs.item(x).nodeType == 3)\n" ) //$NON-NLS-1$
			.append( "		  return childs.item(x).nodeValue;\n" ) //$NON-NLS-1$
			.append( "	   return \"\";\n" ) //$NON-NLS-1$
			.append( "	}\n" ) //$NON-NLS-1$
			.append( "	        function toggleLabelsVisibility(evt, id, compList, labelList){\n" ) //$NON-NLS-1$
		.append( "       var mainSvg = evt.target.ownerDocument;\n" ) //$NON-NLS-1$
		.append( "    for (i = 0; i < compList.length; i=i+1){\n" ) //$NON-NLS-1$
			.append( "         var comp = mainSvg.getElementById(id+'_'+compList[i]);\n" ) //$NON-NLS-1$
			.append( "         if ( comp == null ) continue;\n")		//$NON-NLS-1$
			.append( "         var styleStr = comp.getAttribute(\"style\");\n" ) //$NON-NLS-1$
			.append( "        rVisibleExp=/visibility:[ ]*visible/g;\n" ) //$NON-NLS-1$
			.append( "        rInheritExp=/visibility:[ ]*inherit/g;\n" ) //$NON-NLS-1$
			.append( "        rHiddenExp=/visibility:[ ]*hidden/g;\n" ) //$NON-NLS-1$
			.append( "        results = styleStr.search(rVisibleExp);\n" ) //$NON-NLS-1$
			.append( "        inResults = styleStr.search(rInheritExp);\n" ) //$NON-NLS-1$
			.append( "        if ((results == -1) && (inResults == -1)){\n" ) //$NON-NLS-1$
 			.append( "           results = styleStr.search(rHiddenExp);\n" ) //$NON-NLS-1$
			.append( "            if (results == -1)\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr + \"visibility:hidden;\";\n" ) //$NON-NLS-1$
    			.append( "            else\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr.replace(rHiddenExp,\"visibility:visible\");\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
			.append( "         else{\n" ) //$NON-NLS-1$
			.append( "         if (inResults == -1){\n" ) //$NON-NLS-1$
 			.append( "                styleStr = styleStr.replace(rVisibleExp,\"visibility:hidden\");\n" ) //$NON-NLS-1$
			.append( "         }else{\n" ) //$NON-NLS-1$
 			.append( "                styleStr = styleStr.replace(rInheritExp,\"visibility:hidden\");\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
			.append( "         comp.setAttributeNS(null, \"style\", styleStr);\n" ) //$NON-NLS-1$
			.append( "     }\n" ) //$NON-NLS-1$
			.append( "	}\n" ) //$NON-NLS-1$
			.append( "	        function toggleVisibility(evt, id, compList, labelList){\n" ) //$NON-NLS-1$
		.append( "       var mainSvg = evt.target.ownerDocument;\n" ) //$NON-NLS-1$
		.append( "       var isHidden = true;\n" ) //$NON-NLS-1$
		.append( "    for (i = 0; i < compList.length; i=i+1){\n" ) //$NON-NLS-1$
			.append( "         var comp = mainSvg.getElementById(id+'_'+compList[i]);\n" ) //$NON-NLS-1$
			.append( "         if ( comp == null ) continue;\n")		//$NON-NLS-1$
			.append( "         var styleStr = comp.getAttribute(\"style\");\n" ) //$NON-NLS-1$
			.append( "        rVisibleExp=/visibility:[ ]*visible/g;\n" ) //$NON-NLS-1$
			.append( "        rHiddenExp=/visibility:[ ]*hidden/g;\n" ) //$NON-NLS-1$
			.append( "        results = styleStr.search(rVisibleExp);\n" ) //$NON-NLS-1$
			.append( "        if (results == -1){\n" ) //$NON-NLS-1$
 			.append( "           results = styleStr.search(rHiddenExp);\n" ) //$NON-NLS-1$
			.append( "            if (results == -1)\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr + \"visibility:hidden;\";\n" ) //$NON-NLS-1$
    			.append( "            else{\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr.replace(rHiddenExp,\"visibility:visible\");\n" ) //$NON-NLS-1$
			.append( "                isHidden = false;\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
			.append( "         else{\n" ) //$NON-NLS-1$
 			.append( "                styleStr = styleStr.replace(rVisibleExp,\"visibility:hidden\");\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
			.append( "         comp.setAttributeNS(null, \"style\", styleStr);\n" ) //$NON-NLS-1$
			.append( "     }\n" ) //$NON-NLS-1$
			.append( "        if (labelList != null){\n" ) //$NON-NLS-1$
		.append( "    for (i = 0; i < labelList.length; i=i+1){\n" ) //$NON-NLS-1$
			.append( "         var comp = mainSvg.getElementById(id+'_'+labelList[i]+'_g');\n" ) //$NON-NLS-1$
			.append( "         if ( comp == null ) continue;\n")		//$NON-NLS-1$			
			.append( "         var styleStr = comp.getAttribute(\"style\");\n" ) //$NON-NLS-1$
			.append( "        if (isHidden){\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr + \"visibility:hidden;\";\n" ) //$NON-NLS-1$
			.append( "         toggleLabelVisibility(evt, id+'_'+labelList[i], 'inherit');\n" ) //$NON-NLS-1$
    			.append( "            }else{\n" ) //$NON-NLS-1$
			.append( "                styleStr = styleStr.replace(rHiddenExp,\"visibility:visible\");\n" ) //$NON-NLS-1$
    			.append( "         }\n" ) //$NON-NLS-1$
			.append( "         comp.setAttributeNS(null, \"style\", styleStr);\n" ) //$NON-NLS-1$
			.append( "     }\n" ) //$NON-NLS-1$
			.append( "     }\n" ) //$NON-NLS-1$
		.append( "     }			\n" ) //$NON-NLS-1$
		.append( "        function toggleLabelVisibility(evt, id, property){\n" ) //$NON-NLS-1$
		.append( "	      var mainSvg = evt.target.ownerDocument;\n" ) //$NON-NLS-1$
		.append( "	        var comp = mainSvg.getElementById(id);\n" ) //$NON-NLS-1$
		.append( "	        var styleStr = comp.getAttribute(\"style\");\n" ) //$NON-NLS-1$
		.append( "	       rVisibleExp=/visibility:[ ]*visible/g;\n" ) //$NON-NLS-1$
		.append( "	       rInheritExp=/visibility:[ ]*inherit/g;\n" ) //$NON-NLS-1$
		.append( "	       rHiddenExp=/visibility:[ ]*hidden/g;\n" ) //$NON-NLS-1$
		.append( "	       results = styleStr.search(rVisibleExp);\n" ) //$NON-NLS-1$
		.append( "	       inResults = styleStr.search(rInheritExp);\n" ) //$NON-NLS-1$
		.append( "	       if ((results == -1) && (inResults == -1)){\n" ) //$NON-NLS-1$
		.append( "	          results = styleStr.search(rHiddenExp);\n" ) //$NON-NLS-1$
		.append( "	           if (results == -1)\n" ) //$NON-NLS-1$
		.append( "	               styleStr = styleStr + \"visibility:\"+property+\";\";\n" ) //$NON-NLS-1$
		.append( "	        }\n" ) //$NON-NLS-1$
		.append( "	        else{\n" ) //$NON-NLS-1$
		.append( "	            if (inResults == -1)\n" ) //$NON-NLS-1$
		.append( "	               styleStr = styleStr.replace(rVisibleExp,\"visibility:\"+property);\n" ) //$NON-NLS-1$		
		.append( "        else\n" ) //$NON-NLS-1$
		.append( "            styleStr = styleStr.replace(rInheritExp,\"visibility:\"+property);\n" ) //$NON-NLS-1$
		.append( "     }\n" ) //$NON-NLS-1$
		.append( "     comp.setAttributeNS(null, \"style\", styleStr);\n" ) //$NON-NLS-1$
		.append( "     }			\n" ) //$NON-NLS-1$
		.append( "   		function toHex(val)\n" ) //$NON-NLS-1$
	.append( "	{\n" ) //$NON-NLS-1$
	.append( "	    strVal = Number(val).toString(16);\n" ) //$NON-NLS-1$
	.append( "	    while (strVal.length < 6){\n" ) //$NON-NLS-1$
	.append( "	        strVal = \"0\"+strVal;\n" ) //$NON-NLS-1$
	.append( "	    }\n" ) //$NON-NLS-1$
	.append( "	    return strVal;\n" ) //$NON-NLS-1$
	.append( "	}\n" ) //$NON-NLS-1$
	.append( "	function getXorColor(color){\n" ) //$NON-NLS-1$
	.append( "	    var value = parseInt(color, 16);\n" ) //$NON-NLS-1$
	.append( "	    value = 0xFFFFFF ^ value;\n" ) //$NON-NLS-1$
	.append( "	    return \"#\"+toHex(value);\n" ) //$NON-NLS-1$
	.append( "	}		\n" ) //$NON-NLS-1$
	.append( "	var oldCompId = null;\n" ) //$NON-NLS-1$
	.append( "	var oldCompList = null;\n" ) //$NON-NLS-1$
    .append( "    var fillToColor = new Array(); \n" ) //$NON-NLS-1$
    .append( "    var strokeToColor = new Array();	\n" ) //$NON-NLS-1$
 	.append( "   function highlight(evt, id, compList){\n" ) //$NON-NLS-1$
		.append( "       highlightElement(evt, oldCompId, oldCompList, false);\n" ) //$NON-NLS-1$
    	.append( "       if (id != oldCompId){\n" ) //$NON-NLS-1$
        	.append( "           highlightElement(evt, id, compList, true);\n" ) //$NON-NLS-1$
       	.append( "           oldCompId = id;\n" ) //$NON-NLS-1$
       	.append( "          oldCompList = compList;\n" ) //$NON-NLS-1$
       	.append( "        }\n" ) //$NON-NLS-1$
    	.append( "        else{\n" ) //$NON-NLS-1$
        	.append( "           oldCompId = null;\n" ) //$NON-NLS-1$
       	.append( "           oldCompList = null;\n" ) //$NON-NLS-1$
       	.append( "       	fillToColor = new Array();\n" ) //$NON-NLS-1$
		.append( "      strokeToColor = new Array();\n" ) //$NON-NLS-1$
       	.append( "        }\n" ) //$NON-NLS-1$
    	.append( "     }\n" ) //$NON-NLS-1$
    	.append( "    	function highlightElement(evt, id, compList, highlight){\n" ) //$NON-NLS-1$
    	.append( "		   if ((id == null) || (compList == null)) return;\n" ) //$NON-NLS-1$
    	.append( "	       var mainSvg = evt.target.ownerDocument;\n" ) //$NON-NLS-1$

    	.append( "	    for (i = 0; i < compList.length; i=i+1){\n" ) //$NON-NLS-1$
    	.append( "	    var comp = mainSvg.getElementById(id+'_'+compList[i]);\n" ) //$NON-NLS-1$
    	.append( "         if ( comp == null ) continue;\n")		//$NON-NLS-1$
    	.append( "	    var styleStr = comp.getAttribute(\"style\");\n" ) //$NON-NLS-1$
    	.append( "		   fillIndex = styleStr.search(\"fill:\");\n" ) //$NON-NLS-1$
    	.append( "		   if (fillIndex != -1){\n" ) //$NON-NLS-1$
    	.append( "	              styleStr = getNewStyle(styleStr, fillIndex, \"fill:\", highlight, fillToColor, compList[i]);\n" ) //$NON-NLS-1$
    	.append( "		   }\n" ) //$NON-NLS-1$
    	.append( "		   strokeIndex = styleStr.search(\"stroke:\");\n" ) //$NON-NLS-1$
    	.append( "		   if (strokeIndex != -1){\n" ) //$NON-NLS-1$
    	.append( "	              styleStr = getNewStyle(styleStr, strokeIndex, \"stroke:\", highlight, strokeToColor, compList[i]);\n" ) //$NON-NLS-1$
    	.append( "		   }\n" ) //$NON-NLS-1$
    	.append( "	   comp.setAttributeNS(null, \"style\", styleStr);\n" ) //$NON-NLS-1$
    	.append( "	     }\n" ) //$NON-NLS-1$
    	.append( "	     }\n" ) //$NON-NLS-1$			    	
    	
    	.append( "    	function getNewStyle(style, index, styleAttr, highlight, lookUpTable, id){\n" ) //$NON-NLS-1$
    	.append( "	     color = style.substring(index+styleAttr.length, style.length );\n" ) //$NON-NLS-1$
   	
    	.append( "             if (color.substring(0, 6).search(\"none\")  != -1) return style;\n" ) //$NON-NLS-1$
    	.append( "              rgbIndex = color.search(\"rgb\");\n" ) //$NON-NLS-1$
    	.append( "              if (rgbIndex == -1){\n" ) //$NON-NLS-1$
    	.append( "          if (styleAttr == \"fill:\")\n" ) //$NON-NLS-1$
    	.append( "             urlStr = /fill:\\s*url\\(#([^\\x27]+)\\);/g;\n" ) //$NON-NLS-1$
    	.append( "         else\n" ) //$NON-NLS-1$
    	.append( "             urlStr = /stroke:\\s*url\\(#([^\\x27]+)\\);/g;\n" ) //$NON-NLS-1$
    	
    	.append( "        result = urlStr.exec(style);\n" ) //$NON-NLS-1$
    	.append( "        if (result != null){\n" ) //$NON-NLS-1$
    	.append( "    		endOf= /\\w+h\\b/g;\n" ) //$NON-NLS-1$
    	.append( "    		if (endOf.exec(result[1])== null){\n" ) //$NON-NLS-1$    	
    	.append( "             return style.replace(urlStr, styleAttr+\"url(#\"+result[1]+\"h);\");\n") //$NON-NLS-1$
    	.append( "          }\n" ) //$NON-NLS-1$
    	.append( "          else{\n" ) //$NON-NLS-1$
    	.append( "             return style.replace(urlStr, styleAttr+\"url(#\"+result[1].substring(0, result[1].length-1)+\");\");\n") //$NON-NLS-1$
    	.append( "          }\n" ) //$NON-NLS-1$    	
    	.append( "        }\n" ) //$NON-NLS-1$
    	.append( "               else{\n" ) //$NON-NLS-1$
    	.append( "	        hexColor = color.substring(1, 7);\n" ) //$NON-NLS-1$
    	.append( "	        hc = getHighlight(hexColor, highlight, lookUpTable, id);\n" ) //$NON-NLS-1$
    	.append( "	        return style.replace(styleAttr+\"#\"+hexColor,styleAttr+hc);\n" ) //$NON-NLS-1$
    	.append( "               }\n" ) //$NON-NLS-1$
    	.append( "	     }\n" ) //$NON-NLS-1$
    	.append( "	     else{\n" ) //$NON-NLS-1$
    	.append( "	        bracketIndex = color.search(\"\\\\)\");\n" ) //$NON-NLS-1$
    	.append( "	        color = color.substring(0, bracketIndex);\n" ) //$NON-NLS-1$
    	.append( "	        hexColor = getHexFromRGB(color);\n" ) //$NON-NLS-1$
    	.append( "	        hc = getHighlight(hexColor, highlight, lookUpTable, id);\n" ) //$NON-NLS-1$
    	.append( "	        return style.substring(0, index) + styleAttr+hc+ style.substring(index+bracketIndex+styleAttr.length+1, style.length);\n" ) //$NON-NLS-1$
    	.append( "	   }    \n" ) //$NON-NLS-1$
    	.append( "	}\n" ) //$NON-NLS-1$
		//////////////////////////////////////////////////////////////////
		//    	 function: redirect
		//    	 description: Redirects url to a certain target instance
		//    	 inputs:
		//    	   target - target instance
    	//         url - url
		////////////////////////////////////////////////////////////////    	
    	.append( "	function redirect(target, url){\n" ) //$NON-NLS-1$
    	.append( "		if (target =='_blank'){\n" ) //$NON-NLS-1$    	
    	.append( "		try{\n" ) //$NON-NLS-1$
    	.append( "			open(url);\n" ) //$NON-NLS-1$
    	.append( "		}catch(e){}\n" ) //$NON-NLS-1$
    	.append( "		}\n" ) //$NON-NLS-1$
    	.append( "		else if (target == '_top'){\n" ) //$NON-NLS-1$
    	.append( "          window.top.location.href=url;\n" ) //$NON-NLS-1$									
    	.append( "		}\n" ) //$NON-NLS-1$
    	.append( "		else if (target == '_parent'){\n" ) //$NON-NLS-1$
    	.append( "          parent.location.href=url;\n" ) //$NON-NLS-1$									
    	.append( "		}\n" ) //$NON-NLS-1$
    	.append( "		else if (target == '_self'){\n" ) //$NON-NLS-1$
    	.append( "          parent.location.href=url;\n" ) //$NON-NLS-1$									
    	.append( "		}\n" ) //$NON-NLS-1$    	
    	.append( "		else if (target == '_self'){\n" ) //$NON-NLS-1$
    	.append( "          parent.location.href=url;\n" ) //$NON-NLS-1$									
    	.append( "		}\n" ) //$NON-NLS-1$    	
    	.append( "		else{\n" ) //$NON-NLS-1$
    	.append( "		try{\n" ) //$NON-NLS-1$
    	.append( "			open(url);\n" ) //$NON-NLS-1$
    	.append( "		}catch(e){}\n" ) //$NON-NLS-1$
    	.append( "		}\n" ) //$NON-NLS-1$
    	.append( "	}\n" ) //$NON-NLS-1$    	    
		//////////////////////////////////////////////////////////////////
		//    	 function: scaleSVG
		//    	 description: scales the svg document by a specified zoom factor
		//    	 inputs:
		//    	   factor - zoom factor 
		////////////////////////////////////////////////////////////////
//    	.append( "function scaleSVG(factor){\n" ) //$NON-NLS-1$
//    	.append( "  root=document.rootElement;\n" ) //$NON-NLS-1$
//    	.append( "  root.currentScale = factor\n" ) //$NON-NLS-1$
//    	.append( "}    	\n" ) //$NON-NLS-1$
 		//////////////////////////////////////////////////////////////////
		//    	 function: isIE
		//    	 description: detects whether the browser is a Mircosoft internet explorer browser
		//    	 outputs:
		//    	   true/false 
		////////////////////////////////////////////////////////////////   	
    	.append( "	function isIE(){\n" )//$NON-NLS-1$
		.append( "   var agt=parent.navigator.userAgent.toLowerCase();\n" )//$NON-NLS-1$
		.append( "   return (agt.indexOf(\"msie\")!=-1);\n" )//$NON-NLS-1$
		.append( "}  \n" )//$NON-NLS-1$  	
 		//////////////////////////////////////////////////////////////////
		//    	 function: resizeSVG
		//    	 description: changes the size of the SVG to the width and height
		//                    of the containing embed tag.  Currently this 
		//                    support is only for IE browsers.
		//    	 input: 
		//            e - the event that triggers the resize
		////////////////////////////////////////////////////////////////
		.append( "       var xScale = 1;\n" )//$NON-NLS-1$
		.append( "       var yScale = 1;\n" )//$NON-NLS-1$
    	.append( "	function resizeSVG(e){\n" )//$NON-NLS-1$
    	.append( "    try{\n" )//$NON-NLS-1$
		.append( "       var root=e.target.ownerDocument.documentElement;\n" )//$NON-NLS-1$
		.append( "       var hotSpot = e.target.ownerDocument.getElementById('hotSpots');\n" )//$NON-NLS-1$
		.append( "       var g = e.target.ownerDocument.getElementById('outerG');\n" )//$NON-NLS-1$
		.append( "       xScale = (innerWidth) / root.getAttribute('initialWidth');\n" )//$NON-NLS-1$
		.append( "       yScale = (innerHeight) / root.getAttribute('initialHeight');\n" )//$NON-NLS-1$
		.append( "       root.setAttribute('width', xScale*root.getAttribute('initialWidth'));\n" )//$NON-NLS-1$
		.append( "       root.setAttribute('height', yScale*root.getAttribute('initialHeight'));\n" )//$NON-NLS-1$
		.append( "       g.setAttributeNS(null, 'transform', 'scale('+xScale+','+yScale+')');\n" )//$NON-NLS-1$
		.append( "       hotSpot.setAttributeNS(null, 'transform', 'scale('+xScale+','+yScale+')');\n" )//$NON-NLS-1$
		.append( "    }catch(e){}\n" )//$NON-NLS-1$
		.append( "  }\n" )//$NON-NLS-1$		
		.append( "        function getHighlight(color, highlight, lookupTable, id){\n" )//$NON-NLS-1$
    	.append( "        if (!(highlight)){\n" )//$NON-NLS-1$
    	.append( "            color = lookupTable[id];\n" )//$NON-NLS-1$
    	.append( "        }\n" )//$NON-NLS-1$
    	.append( "        else{\n" )//$NON-NLS-1$
    	.append( "            lookupTable[id] = color;\n" )//$NON-NLS-1$
    	.append( "        }\n" )//$NON-NLS-1$
    	.append( "        var r = color.substring(0, 2);\n" )//$NON-NLS-1$
    	.append( "        r = parseInt(r, 16);\n" )//$NON-NLS-1$
    	.append( "        var g = color.substring(2, 4);\n" )//$NON-NLS-1$
    	.append( "        g = parseInt(g, 16);\n" )//$NON-NLS-1$
    	.append( "        var b = color.substring(4, 6);\n" )//$NON-NLS-1$
    	.append( "        b = parseInt(b, 16);\n" )//$NON-NLS-1$
    	.append( "    var value = parseInt(r, 16);\n" )//$NON-NLS-1$
    	.append( "        if (highlight){\n" )//$NON-NLS-1$
    	.append( "           r = Math.ceil( (r + 255) / 2 );\n" )//$NON-NLS-1$
    	.append( "           g = Math.ceil( (g + 255) / 2 );\n" )//$NON-NLS-1$
    	.append( "           b = Math.ceil( (b + 255) / 2 );\n" )//$NON-NLS-1$
    	.append( "        }\n" )//$NON-NLS-1$
    	.append( "        rStr = r.toString(16);\n" )//$NON-NLS-1$		
    	.append( "        gStr = g.toString(16);\n" )//$NON-NLS-1$
    	.append( "    bStr = b.toString(16);\n" )//$NON-NLS-1$
    	.append( "    while (rStr.length < 2){\n" )//$NON-NLS-1$
    	.append( "        rStr = \"0\"+rStr;\n" )//$NON-NLS-1$
    	.append( "    }\n" )//$NON-NLS-1$
    	.append( "    while (gStr.length < 2){\n" )//$NON-NLS-1$
    	.append( "        gStr = \"0\"+gStr;\n" )//$NON-NLS-1$
    	.append( "    }\n" )//$NON-NLS-1$
    	.append( "    while (bStr.length < 2){\n" )//$NON-NLS-1$
    	.append( "        bStr = \"0\"+bStr;\n" )//$NON-NLS-1$
    	.append( "    }\n" )//$NON-NLS-1$
    	.append( "return \"#\"+rStr+gStr+bStr;\n" )//$NON-NLS-1$
    	.append( "}\n" )//$NON-NLS-1$    	    	
    	.append( "	function getHexFromRGB(color){\n" ) //$NON-NLS-1$
    	.append( "	        findThem = /\\d{1,3}/g;\n" ) //$NON-NLS-1$
    	.append( "	        listOfnum = color.match(findThem);\n" ) //$NON-NLS-1$
    	.append( "	        r = Number(listOfnum[0]).toString(16);\n" ) //$NON-NLS-1$
    	.append( "	        while (r.length < 2){\n" ) //$NON-NLS-1$
    	.append( "		    r = \"0\"+r;\n" ) //$NON-NLS-1$
    	.append( "	        }\n" ) //$NON-NLS-1$
    	.append( "	        g = Number(listOfnum[1]).toString(16);\n" ) //$NON-NLS-1$
    	.append( "	        while (g.length < 2){\n" ) //$NON-NLS-1$
    	.append( "		   g = \"0\"+g;\n" ) //$NON-NLS-1$
    	.append( "	        }\n" ) //$NON-NLS-1$
    	.append( "	        b = Number(listOfnum[2]).toString(16);\n" ) //$NON-NLS-1$
    	.append( "	        while (b.length < 2){\n" ) //$NON-NLS-1$
    	.append( "	 	   b = \"0\"+b;\n" ) //$NON-NLS-1$
    	.append( "	        }\n" ) //$NON-NLS-1$
    	.append( "		return r+g+b;\n" ) //$NON-NLS-1$
    	.append( "	}\n" ) //$NON-NLS-1$
	 /////////////////////////////////////////////////////////////////////////////////////////
	 //
	 // Follow code defines scripts to display hyperlink menu in svg.
    /////////////////////////////////////////////////////////////////////////////////////////
    	.append("    			\n") //$NON-NLS-1$
    	.append("    function MenuLayout() {		\n") //$NON-NLS-1$
    	.append("    	this.width = 0;		\n") //$NON-NLS-1$
    	.append("    	this.height = 0;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    MenuLayout.prototype.updateMenuWidth = function(width ) {		\n") //$NON-NLS-1$
    	.append("    	if ( width > this.width ) this.width = width;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    function HM() {		\n") //$NON-NLS-1$
    	.append("    	this.hideTimer;		\n") //$NON-NLS-1$
    	.append("    	this.TEXT_STYLES;		\n") //$NON-NLS-1$
    	.append("    	this.menuStyles;		\n") //$NON-NLS-1$
    	.append("    	this.hyperlinks;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    // Hide tooltip		\n") //$NON-NLS-1$
    	.append("    HM.remove = function HM_removeMenu(){    		\n") //$NON-NLS-1$
    	.append("    	if (typeof this.group != 'undefined'){    		\n") //$NON-NLS-1$
    	.append("    	this.group.removeNode();		\n") //$NON-NLS-1$
    	.append("    	this.group = undefined;		\n") //$NON-NLS-1$
    	.append("    	}    		\n") //$NON-NLS-1$
    	.append("    }  		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.show = function HM_showMenu( evt, source, categoryData, valueData, valueSeriesName, hyperlinks, menustyles ) {		\n") //$NON-NLS-1$
    	.append("    	this.TEXT_STYLES = \"font:font-family:font-size:font-size-adjust:font-stretch:font-style:font-variant:font-weight:direction:letter-spacing:text-decoration:unicode-bidi:word-spacing:alignment-baseline:baseline-shift:dominant-baseline:glyph-orientation-horizontal:glyph-orientation-vertical:kerning:text-anchor:writing-mode:cursor:color:\";		\n") //$NON-NLS-1$
    	.append("    	this.hyperlinks = hyperlinks;		\n") //$NON-NLS-1$
    	.append("    	this.menuStyles = menustyles;		\n") //$NON-NLS-1$
    	.append("    	this.menuLayout = new MenuLayout();		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	if ( typeof id != 'undefined' ){    		\n") //$NON-NLS-1$
    	.append("    	    var mainSvg = evt.target.ownerDocument;    		\n") //$NON-NLS-1$
    	.append("    	    var comp = mainSvg.getElementById(id);    		\n") //$NON-NLS-1$
    	.append("    	    var styleStr = comp.getAttribute(\"style\");    		\n") //$NON-NLS-1$
    	.append("    	    rHiddenExp=/visibility:[ ]*hidden/g;    		\n") //$NON-NLS-1$
    	.append("    	    results = styleStr.search(rHiddenExp);    		\n") //$NON-NLS-1$
    	.append("    	    if (results != -1)    		\n") //$NON-NLS-1$
    	.append("    	        return;    		\n") //$NON-NLS-1$
    	.append("    	 }		\n") //$NON-NLS-1$
    	.append("    	    		\n") //$NON-NLS-1$
    	.append("    	 x = evt.clientX;    		\n") //$NON-NLS-1$
    	.append("    	 y = evt.clientY;    		\n") //$NON-NLS-1$
    	.append("    	 		\n") //$NON-NLS-1$
    	.append("    	 update = true;		\n") //$NON-NLS-1$
    	.append("    	 if ( this.oldX != 'undefined' ){		\n") //$NON-NLS-1$
    	.append("    	     diffX = ( x - this.oldX );		\n") //$NON-NLS-1$
    	.append("    	     if (diffX < 0)		\n") //$NON-NLS-1$
    	.append("    			diffX= diffX*(-1);		\n") //$NON-NLS-1$
    	.append("    	     diffY = ( y - this.oldY);		\n") //$NON-NLS-1$
    	.append("    	     if (diffY < 0) diffY= diffY*(-1);		\n") //$NON-NLS-1$
    	.append("    	     if ((diffY > 5) || (diffX > 5))		\n") //$NON-NLS-1$
    	.append("    	        update = true;		\n") //$NON-NLS-1$
    	.append("    	 }		\n") //$NON-NLS-1$
    	.append("    	     		\n") //$NON-NLS-1$
    	.append("    	 if (update)		\n") //$NON-NLS-1$
    	.append("    	     HM.remove();            		\n") //$NON-NLS-1$
    	.append("    	     		\n") //$NON-NLS-1$
    	.append("    	 if (typeof this.group == 'undefined'){    		\n") //$NON-NLS-1$
    	.append("    	     this.oldX = x;		\n") //$NON-NLS-1$
    	.append("    	     this.oldY = y;        		\n") //$NON-NLS-1$
    	.append("    	     this.xPadding = 5;    		\n") //$NON-NLS-1$
    	.append("    	     this.yPadding = 2;		\n") //$NON-NLS-1$
    	.append("    	     var mainSvg = evt.target.ownerDocument.documentElement;		\n") //$NON-NLS-1$
    	.append("    	     var off = mainSvg.currentTranslate;		\n") //$NON-NLS-1$
    	.append("    	     var scl = mainSvg.currentScale;		\n") //$NON-NLS-1$
    	.append("    	     var adjustedX = ( x - off.x ) / scl;		\n") //$NON-NLS-1$
    	.append("    	     var adjustedY = ( y - off.y ) / scl;		\n") //$NON-NLS-1$
    	.append("    	     this.group = new BuildHelper(\"g\",		\n") //$NON-NLS-1$
    	.append("    	         { opacity:0.8,		\n") //$NON-NLS-1$
    	.append("    	           display: \"row-group\",		\n") //$NON-NLS-1$
    	.append("    	           transform:\"translate(\"+ adjustedX + \",\"+ adjustedY +\")\"		\n") //$NON-NLS-1$
    	.append("    	         }		\n") //$NON-NLS-1$
    	.append("    	     );		\n") //$NON-NLS-1$
    	.append("    	     this.group.addToParent(mainSvg);		\n") //$NON-NLS-1$
    	.append("    	     		\n") //$NON-NLS-1$
    	.append("    	     // Create a menu item		\n") //$NON-NLS-1$
    	.append("    	     this.menu = new Array(2);		\n") //$NON-NLS-1$
    	.append("    		 this.textItem = new Array(2);		\n") //$NON-NLS-1$
    	.append("    		 var menuX = 0;		\n") //$NON-NLS-1$
    	.append("    		 var menuY = 0;		\n") //$NON-NLS-1$
    	.append("    		 var textX = this.xPadding;		\n") //$NON-NLS-1$
    	.append("    		 var textY = this.yPadding;		\n") //$NON-NLS-1$
    	.append("    		 		\n") //$NON-NLS-1$
    	.append("    		 var menu = HM.createMenu( evt, menuX, menuY, scl);		\n") //$NON-NLS-1$
    	.append("    		 menuX = menuX + 1;		\n") //$NON-NLS-1$
    	.append("    		 menuY = menuY + 1;		\n") //$NON-NLS-1$
    	.append("    		 		\n") //$NON-NLS-1$
    	.append("       		 for (var i = 0; i < this.hyperlinks.length; i ++ ) {		\n") //$NON-NLS-1$
    	.append("    					\n") //$NON-NLS-1$
    	.append("       			this.menu[i] = HM.createMenuItem( evt, menuX, menuY, scl, i ); 				\n") //$NON-NLS-1$
    	.append("       			this.textItem[i] = HM.createTextItem( evt, textX, textY , scl, i );				\n") //$NON-NLS-1$
    	.append("       			var outline = this.textItem[i].element.getBBox();				\n") //$NON-NLS-1$
    	.append("       			this.textItem[i].element.setAttributeNS(null, \"y\", textY + outline.height );				\n") //$NON-NLS-1$
    	.append("       			menuY = menuY + this.yPadding * 2 + outline.height;				\n") //$NON-NLS-1$
    	.append("       			textY = textY + outline.height + this.yPadding * 2 ;				\n") //$NON-NLS-1$
    	.append("       			this.menuLayout.updateMenuWidth( this.xPadding * 2 + outline.width );				\n") //$NON-NLS-1$
    	.append("       			var height = this.yPadding * 2 + outline.height;				\n") //$NON-NLS-1$
    	.append("       			this.menu[i].element.setAttributeNS(null, \"height\", height );				\n") //$NON-NLS-1$
    	.append("       			this.menuLayout.height = this.menuLayout.height + height;				\n") //$NON-NLS-1$
    	.append("           	}				\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    		menu.element.setAttributeNS( null, \"width\", this.menuLayout.width + 1);		\n") //$NON-NLS-1$
    	.append("    		menu.element.setAttributeNS( null, \"height\", this.menuLayout.height + 1 );		\n") //$NON-NLS-1$
    	.append("    		 		\n") //$NON-NLS-1$
    	.append("    		// Update menu item bounds.		\n") //$NON-NLS-1$
    	.append("    		for ( var i = 0; i < this.menu.length; i++ ) {		\n") //$NON-NLS-1$
    	.append("    			this.menu[i].element.setAttributeNS(null, \"width\", this.menuLayout.width);		\n") //$NON-NLS-1$
    	.append("    		}		\n") //$NON-NLS-1$
    	.append("    				\n") //$NON-NLS-1$
    	.append("    		// Adjust position of menu.		\n") //$NON-NLS-1$
    	.append("    		var root=evt.target.ownerDocument.documentElement;		\n") //$NON-NLS-1$
    	.append("    		var rootWidth =root.getAttribute('width');		\n") //$NON-NLS-1$
    	.append("    		var rootHeight = root.getAttribute('height');		\n") //$NON-NLS-1$
    	.append("    		var menuWidth = this.menuLayout.menuitemWidth;		\n") //$NON-NLS-1$
    	.append("    		var menuHeight = this.menuLayout.height;		\n") //$NON-NLS-1$
    	.append("    		if (((y + menuHeight ) > rootHeight) || ((x+ menuWidth)> rootWidth)){		\n") //$NON-NLS-1$
    	.append("    			var transformX = x + this.xPadding;		\n") //$NON-NLS-1$
    	.append("    			var transformY = y + this.yPadding;		\n") //$NON-NLS-1$
    	.append("    			if ( ( y + menuHeight ) > rootHeight )		\n") //$NON-NLS-1$
    	.append("    				transformY  = ( rootHeight - menuHeight ) - this.yPadding;		\n") //$NON-NLS-1$
    	.append("    			if ( ( x + menuWidth ) > rootWidth )		\n") //$NON-NLS-1$
    	.append("    				transformX  = ( rootWidth - menuWidth ) - this.xPadding;		\n") //$NON-NLS-1$
    	.append("    			this.group.element.setAttributeNS(null, \"transform\", \"translate(\"+(transformX*xScale)+\", \"+(transformY*yScale)+\")\");		\n") //$NON-NLS-1$
    	.append("    		}		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	stopBubble(evt);		\n") //$NON-NLS-1$
    	.append("    	stopDefault(evt);		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("       HM.createMenu = function HM_createMenu( evt, xOff, yOff, scl ) {				\n") //$NON-NLS-1$
    	.append("       	var rectangle = new BuildHelper(\"rect\",				\n") //$NON-NLS-1$
    	.append("       	    {id: \"hyperlinkmenu\",				\n") //$NON-NLS-1$
    	.append("       	     x: xOff,				\n") //$NON-NLS-1$
    	.append("       	     y: yOff,				\n") //$NON-NLS-1$
    	.append("       		 stroke:\"black\",				\n") //$NON-NLS-1$
    	.append("       	     transform:\"scale(\"+(1/scl)+\",\"+(1/scl)+\")\",				\n") //$NON-NLS-1$
    	.append("                style: \"fill: white; cursor: pointer; stroke: black; stroke-width: 1px;\"				\n") //$NON-NLS-1$
    	.append("       	    }				\n") //$NON-NLS-1$
    	.append("       	);				\n") //$NON-NLS-1$
    	.append("       				\n") //$NON-NLS-1$
    	.append("       	rectangle.addToParent(this.group.element);		\n") //$NON-NLS-1$
    	.append("       	setStyles( rectangle.element, HM.getMenuStyles( this.menuStyles[0] ) );		\n") //$NON-NLS-1$
    	.append("           return rectangle;				\n") //$NON-NLS-1$
    	.append("       }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    HM.createMenuItem = function HM_createMenuItem( evt, xOff, yOff, scl, index ) {		\n") //$NON-NLS-1$
    	.append("    	var menuID = \"menuitem_\" + this.hyperlinks[index][0];		\n") //$NON-NLS-1$
    	.append("    	var rectangle = new BuildHelper(\"rect\",		\n") //$NON-NLS-1$
    	.append("    	    {id: menuID,		\n") //$NON-NLS-1$
    	.append("    	     x: xOff,		\n") //$NON-NLS-1$
    	.append("    	     y: yOff,		\n") //$NON-NLS-1$
    	.append("    		 stroke:\"black\",		\n") //$NON-NLS-1$
    	.append("    	     transform:\"scale(\"+(1/scl)+\",\"+(1/scl)+\")\",		\n") //$NON-NLS-1$
    	.append("                style: \"fill: white; cursor: pointer; stroke: none;\",		\n") //$NON-NLS-1$
    	.append("    	     onmouseover: \"HM.onMouseOver(evt)\",		\n") //$NON-NLS-1$
    	.append("    	     onmouseout: \"HM.onMouseOut(evt)\",		\n") //$NON-NLS-1$
    	.append("    		 onclick: \"HM.redirect(\\\"\" + this.hyperlinks[index][1] + \"\\\", \\\"\" + this.hyperlinks[index][2] + \"\\\"); \"		\n") //$NON-NLS-1$
    	.append("    	    }		\n") //$NON-NLS-1$
    	.append("    	);		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	rectangle.addToParent(this.group.element);		\n") //$NON-NLS-1$
    	.append("    	setStyles( rectangle.element, HM.getMenuStyles( this.menuStyles[1] ) );		\n") //$NON-NLS-1$
    	.append("    	HM.createTooltipItem(evt, rectangle, this.hyperlinks[index][3] );		\n") //$NON-NLS-1$
    	.append("        return rectangle;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.createTextItem = function HM_createTextItem( evt, xOff, yOff, scl, index ) {		\n") //$NON-NLS-1$
    	.append("    	var menuID = \"menuitem_\" + this.hyperlinks[index][0];		\n") //$NON-NLS-1$
    	.append("    	var textObj = new BuildHelper(\"text\",		\n") //$NON-NLS-1$
    	.append("    		{id: \"text_\" + menuID,		\n") //$NON-NLS-1$
    	.append("            x: xOff,		\n") //$NON-NLS-1$
    	.append("            y: yOff,		\n") //$NON-NLS-1$
    	.append("            transform:\"scale(\"+(1/scl)+\",\"+(1/scl)+\")\",		\n") //$NON-NLS-1$
    	.append("               style: \"text-anchor:start; fill:black; cursor: pointer\", 		\n") //$NON-NLS-1$
    	.append("    	    onmouseover: \"HM.onMouseOver(evt)\",		\n") //$NON-NLS-1$
    	.append("    	    onmouseout: \"HM.onMouseOut(evt)\",		\n") //$NON-NLS-1$
    	.append("    		onclick: \"HM.redirect(\\\"\" + this.hyperlinks[index][1] + \"\\\", \\\"\" + this.hyperlinks[index][2] + \"\\\"); \"		\n") //$NON-NLS-1$
    	.append("    		}					\n") //$NON-NLS-1$
    	.append("    		);		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	textObj.addToParent(this.group.element);		\n") //$NON-NLS-1$
    	.append("    	HM.setContent(evt, textObj, this.hyperlinks[index][0], this.hyperlinks[index][3]);		\n") //$NON-NLS-1$
    	.append("    	setStyles( textObj.element, HM.getTextStyles( this.menuStyles[1] ) );		\n") //$NON-NLS-1$
    	.append("    	return textObj;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.setContent = function HM_setContent(evt, textElement, text, tooltip ){		\n") //$NON-NLS-1$
    	.append("       text = text.replace(/\\n/g, \"\\\\n\");		\n") //$NON-NLS-1$
    	.append("       var multiLine = text.split(/\\n/);		\n") //$NON-NLS-1$
    	.append("       for (var x=0; x<multiLine.length; x++){		\n") //$NON-NLS-1$
    	.append("           if (x == 0){		\n") //$NON-NLS-1$
    	.append("               textObj = new BuildHelper(\"tspan\",		\n") //$NON-NLS-1$
    	.append("                              {x: 5, onmouseover: \"HM.showTooltip(evt);\", onmouseout:\"try{TM.remove();}catch(e){}\"},		\n") //$NON-NLS-1$
    	.append("                              multiLine[x]);		\n") //$NON-NLS-1$
    	.append("            }		\n") //$NON-NLS-1$
    	.append("            else{		\n") //$NON-NLS-1$
    	.append("                textObj = new BuildHelper(\"tspan\",		\n") //$NON-NLS-1$
    	.append("                           {x: 5,		\n") //$NON-NLS-1$
    	.append("                             dy:17, onmouseover: \"HM.showTooltip(evt);\", onmouseout:\"try{TM.remove();}catch(e){}\"		\n") //$NON-NLS-1$
    	.append("                        },multiLine[x]);		\n") //$NON-NLS-1$
    	.append("            }		\n") //$NON-NLS-1$
    	.append("            textObj.addToParent(textElement.element);		\n") //$NON-NLS-1$
    	.append("            HM.createTooltipItem(evt, textObj, tooltip );	\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    HM.createTooltipItem = function HM_createTooltipItem( evt, parent, tooltip ) {		\n") //$NON-NLS-1$
    	.append("        if ( typeof tooltip == 'undefined' ) return null; 		\n") //$NON-NLS-1$
    	.append("        var title = new BuildHelper(\"title\", 		\n") //$NON-NLS-1$               
    	.append("            {id: \"title_\" + tooltip}                		\n") //$NON-NLS-1$
    	.append("        );              		\n") //$NON-NLS-1$
    	.append("        title.addToParent( parent.element );		\n") //$NON-NLS-1$
    	.append("        var textObj = evt.target.ownerDocument.createTextNode( tooltip );		\n") //$NON-NLS-1$
    	.append("        title.element.appendChild( textObj );		\n") //$NON-NLS-1$
    	.append("        return title;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("                		\n") //$NON-NLS-1$
    	.append("    HM.showTooltip = function HM_showTooltip( evt ) {		\n") //$NON-NLS-1$
    	.append("        try {		\n") //$NON-NLS-1$
    	.append("            var elem = HM.getTitleElement( evt.currentTarget );		\n") //$NON-NLS-1$
    	.append("            if ( elem != null ) TM.show( evt, null, elem );		\n") //$NON-NLS-1$
    	.append("        } catch ( e ) {}		\n") //$NON-NLS-1$
    	.append("	 return;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("           		\n") //$NON-NLS-1$
    	.append("    HM.getTitleElement = function TM_getTitleElement(elem){		\n") //$NON-NLS-1$
    	.append("        if (elem == null ) return;  		\n") //$NON-NLS-1$
    	.append("        var childs = elem.childNodes;		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("        for (var x=0; x<childs.length; x++){		\n") //$NON-NLS-1$
    	.append("            if (childs.item(x).nodeType == 1 && childs.item(x).nodeName == \"title\")		\n") //$NON-NLS-1$
    	.append("                return childs.item(x);		\n") //$NON-NLS-1$
    	.append("    		 var e = HM.getTitleElement( childs.item(x) );		\n") //$NON-NLS-1$
    	.append("    		if ( e != null ) return e;		\n") //$NON-NLS-1$
    	.append("        }		\n") //$NON-NLS-1$
    	.append("        return null;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    HM.redirect = function(url, urlTarget) {		\n") //$NON-NLS-1$
    	.append("    	try {		\n") //$NON-NLS-1$
    	.append("    		TM.remove();		\n") //$NON-NLS-1$
    	.append("    	} catch ( e ) {};  		\n") //$NON-NLS-1$ 
    	.append("    	HM.remove();		\n") //$NON-NLS-1$
    	.append("    	if ( url.indexOf(\"#\", 0) == 0 ) {		\n") //$NON-NLS-1$
    	.append("    		top.document.location.hash = url;		\n") //$NON-NLS-1$
    	.append("    		return;		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	if ( url.indexOf(\"javascript:\", 0) == 0 ) {		\n") //$NON-NLS-1$
    	.append("    		eval( url.substring( 11, url.length -1 ) );		\n") //$NON-NLS-1$
    	.append("    		return;		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	var target = 'null';		\n") //$NON-NLS-1$
    	.append("    	if ( urlTarget && urlTarget != '' ) target = urlTarget;		\n") //$NON-NLS-1$
    	.append("        try {		\n") //$NON-NLS-1$
    	.append("    		parent.redirect(target, url);		\n") //$NON-NLS-1$
    	.append("    	} catch( e ) {		\n") //$NON-NLS-1$
    	.append("    		redirect(target, url );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.onMouseOver = function HM_onMouseOver(evt)		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("    	var target = evt.currentTarget;		\n") //$NON-NLS-1$
    	.append("    	if ( target == null ) return;		\n") //$NON-NLS-1$
    	.append("    	var id = target.id;		\n") //$NON-NLS-1$
    	.append("    	if ( id.substr(0, \"text_\".length ) == \"text_\" ) {		\n") //$NON-NLS-1$
    	.append("    		var mainSvg = evt.target.ownerDocument;		\n") //$NON-NLS-1$
    	.append("    		var menuComp = mainSvg.getElementById( id.substring(\"text_\".length, id.length ) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  \"stroke: none;\" );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  HM.getMenuStyles(this.menuStyles[2]) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( target,  HM.getTextStyles(this.menuStyles[2]) );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		var mainSvg = evt.target.ownerDocument;		\n") //$NON-NLS-1$
    	.append("    		var menuComp = mainSvg.getElementById( id );		\n") //$NON-NLS-1$
    	.append("    		var textComp = mainSvg.getElementById( \"text_\" + id );		\n") //$NON-NLS-1$
    	.append("    				\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  \"stroke: none;\" );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  HM.getMenuStyles(this.menuStyles[2]) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( textComp,  HM.getTextStyles(this.menuStyles[2]) ); 		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	HM.showTooltip( evt );  \n") //$NON-NLS-1$
    	.append("    	try {		\n") //$NON-NLS-1$
    	.append("    		window.clearTimeout( this.hideTimer );		\n") //$NON-NLS-1$
    	.append("    	} catch ( e) {};		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.onMouseOut = function HM_onMouseOut(evt)		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("    	var target = evt.currentTarget;		\n") //$NON-NLS-1$
    	.append("    	if ( target == null ) return;		\n") //$NON-NLS-1$
    	.append("    	var id = target.id;		\n") //$NON-NLS-1$
    	.append("    	if ( id.substr(0, \"text_\".length ) == \"text_\" ) {		\n") //$NON-NLS-1$
    	.append("    		var mainSvg = evt.target.ownerDocument;		\n") //$NON-NLS-1$
    	.append("    		var menuComp = mainSvg.getElementById( id.substring(\"text_\".length, id.length ) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  \"stroke: none;\" );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  HM.getMenuStyles(this.menuStyles[3]) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( target,  HM.getTextStyles(this.menuStyles[3]) );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		var mainSvg = evt.target.ownerDocument;		\n") //$NON-NLS-1$
    	.append("    		var menuComp = mainSvg.getElementById( id );		\n") //$NON-NLS-1$
    	.append("    		var textComp = mainSvg.getElementById( \"text_\" + id );		\n") //$NON-NLS-1$
    	.append("    				\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  \"stroke: none;\" );		\n") //$NON-NLS-1$
    	.append("    		setStyles( menuComp,  HM.getMenuStyles(this.menuStyles[3]) );		\n") //$NON-NLS-1$
    	.append("    		setStyles( textComp,  HM.getTextStyles(this.menuStyles[3]) ); 		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	try {		\n") //$NON-NLS-1$
    	.append("    		TM.remove();		\n") //$NON-NLS-1$
    	.append("    	} catch ( e ) {};  		\n") //$NON-NLS-1$ 
    	.append("    	this.hideTimer = window.setTimeout(\"HM.remove();\", 300);		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.getTextStyles = function HM_getTextStyles( styles )		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("        var total;		\n") //$NON-NLS-1$
    	.append("    	if ( !isArray(styles ) ) {		\n") //$NON-NLS-1$
    	.append("    		total = getStylesArray( styles );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		total = styles;		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	var styleString = \"\";		\n") //$NON-NLS-1$
    	.append("    	for ( var i = 0; i < total.length; i++ ) {		\n") //$NON-NLS-1$
    	.append("    		if ( this.TEXT_STYLES.search( total[i][0] +\":\" ) < 0 ) continue;		\n") //$NON-NLS-1$
    	.append("    		if ( total[i][0] == \"backgroundColor\" ) continue;		\n") //$NON-NLS-1$
    	.append("    		if ( total[i][0] == \"fill\" ) continue;		\n") //$NON-NLS-1$
    	.append("    		if (total[i][0] == \"color\") {		\n") //$NON-NLS-1$
    	.append("    			styleString += \"fill\"; 		\n") //$NON-NLS-1$
    	.append("    		}		\n") //$NON-NLS-1$
    	.append("    		else styleString += total[i][0];		\n") //$NON-NLS-1$
    	.append("    		styleString += \": \" + total[i][1] + \";\";		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	return styleString;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    HM.getMenuStyles = function HM_getMenuStyles( styles )		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("        var total;		\n") //$NON-NLS-1$
    	.append("    	if ( !isArray(styles ) ) {		\n") //$NON-NLS-1$
    	.append("    		total = getStylesArray( styles );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		total = styles;		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	var styleString = \"\";		\n") //$NON-NLS-1$
    	.append("    	for ( var i = 0; i < total.length; i++ ) {		\n") //$NON-NLS-1$
    	.append("    		if ( this.TEXT_STYLES.search( total[i][0] +\":\" ) >= 0 ) continue;		\n") //$NON-NLS-1$
    	.append("    		if (total[i][0] == \"color\") continue;		\n") //$NON-NLS-1$
    	.append("    		if (total[i][0] == \"backgroundColor\") {		\n") //$NON-NLS-1$
    	.append("    			styleString += \"fill\"; 		\n") //$NON-NLS-1$
    	.append("    		}		\n") //$NON-NLS-1$
    	.append("    		else styleString += total[i][0];		\n") //$NON-NLS-1$
    	.append("    		styleString += \": \" + total[i][1] + \";\";		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	return styleString;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    function getStylesArray( stylesStr )		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("    	var stylesArray = stylesStr.split(\";\");		\n") //$NON-NLS-1$
    	.append("    	var total = new Array( stylesArray.length );		\n") //$NON-NLS-1$
    	.append("    	for ( var i = 0; i < stylesArray.length; i++ ) {		\n") //$NON-NLS-1$
    	.append("    		var unit = stylesArray[i].split(\":\");		\n") //$NON-NLS-1$
    	.append("    		total[i] = new Array( 2);		\n") //$NON-NLS-1$
    	.append("    		total[i][0] = unit[0];		\n") //$NON-NLS-1$
    	.append("    		total[i][1] = unit[1];		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	return total;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    function setStyles( element, styles )		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("    	var total;		\n") //$NON-NLS-1$
    	.append("    	if ( !isArray( styles ) ) {		\n") //$NON-NLS-1$
    	.append("    		total = getStylesArray( styles );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		total = styles;		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    			\n") //$NON-NLS-1$
    	.append("    	var styleAttr = element.getAttribute( \"style\" );		\n") //$NON-NLS-1$
    	.append("    	for ( var i = 0; i < total.length; i ++ ) {		\n") //$NON-NLS-1$
    	.append("    		var key = total[i][0];		\n") //$NON-NLS-1$
    	.append("    		var value = total[i][1];		\n") //$NON-NLS-1$
    	.append("    		if ( key == \"\" || typeof value == 'undefined' ) continue;		\n") //$NON-NLS-1$
    	.append("    		styleAttr = updateStyle( styleAttr, key, value );		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	element.setAttribute( \"style\", styleAttr );		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    function updateStyle(styleStr, key, value )		\n") //$NON-NLS-1$
    	.append("    {		\n") //$NON-NLS-1$
    	.append("    	if ( !styleStr )		\n") //$NON-NLS-1$
    	.append("    		return key + \":\" + value + \";\";		\n") //$NON-NLS-1$
    	.append("    	var styleAttr = styleStr;		\n") //$NON-NLS-1$
    	.append("    	var index = styleAttr.search( \"[ ]*\" + key + \":\" );		\n") //$NON-NLS-1$
    	.append("    	if (  index >= 0 ) {		\n") //$NON-NLS-1$
    	.append("    	//	var regExpr = new RegExp( key + \":\\\\s*[\\\\S ^;]+\\\\s*;\" );		\n") //$NON-NLS-1$
    	.append("    		var index2 = styleAttr.indexOf(\";\", index);		\n") //$NON-NLS-1$
    	.append("    		var s = styleAttr.substring(index, index2 + 1 );		\n") //$NON-NLS-1$
    	.append("    		styleAttr = styleAttr.replace( s, key + \":\" + value + \";\");		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	else {		\n") //$NON-NLS-1$
    	.append("    		styleAttr = styleAttr + key + \":\" + value + \";\";		\n") //$NON-NLS-1$
    	.append("    	}		\n") //$NON-NLS-1$
    	.append("    	return styleAttr;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("    		\n") //$NON-NLS-1$
    	.append("    function isArray(arr) {		\n") //$NON-NLS-1$
    	.append("    	return !!arr && arr.constructor == Array;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    // Stop the event bubble.		\n") //$NON-NLS-1$
    	.append("    function stopBubble(e) {		\n") //$NON-NLS-1$
    	.append("    	// If the e exists, then it isn't in IE.		\n") //$NON-NLS-1$
    	.append("    	try {		\n") //$NON-NLS-1$
    	.append("    	if ( e && e.stopPropagation )		\n") //$NON-NLS-1$
    	.append("    		e.stopPropagation();		\n") //$NON-NLS-1$
    	.append("    	else		\n") //$NON-NLS-1$
    	.append("    		window.event.cancelBubble = true;		\n") //$NON-NLS-1$
    	.append("    	} catch( e ) {};		\n") //$NON-NLS-1$
    	.append("    	return false;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n") //$NON-NLS-1$
    	.append("    // Stop default action of Browser for event.		\n") //$NON-NLS-1$
    	.append("    function stopDefault( e ) {		\n") //$NON-NLS-1$
    	.append("    	// If the e exists, the it isn't in IE.		\n") //$NON-NLS-1$
    	.append("    	try {		\n") //$NON-NLS-1$
    	.append("    	if ( e && e.preventDefault )		\n") //$NON-NLS-1$
    	.append("    		e.preventDefault();		\n") //$NON-NLS-1$
    	.append("    	else		\n") //$NON-NLS-1$
    	.append("    		window.event.returnValue = false;		\n") //$NON-NLS-1$
    	.append("    	} catch( e ) {};		\n") //$NON-NLS-1$
    	.append("    	return false;		\n") //$NON-NLS-1$
    	.append("    }		\n") //$NON-NLS-1$
    	.append("		\n"); //$NON-NLS-1$
}
