/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.impl.document.util;

import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.core.DataException;

/**
 * 
 */
class ExprDataReader3 extends ExprDataReader2
{
	private int destRowIndex[];
	
	/**
	 * @param rowExprsIs
	 * @param rowLenIs
	 * @param destRowIndex
	 * @throws DataException
	 */
	ExprDataReader3( String tempDir, RAInputStream rowExprsIs, RAInputStream rowLenIs,
			int destRowIndex[], int version ) throws DataException
	{
		super( tempDir, rowExprsIs, rowLenIs, destRowIndex.length, version );

		this.destRowIndex = destRowIndex;
	}

	/*
	 * @see org.eclipse.birt.data.engine.impl.document.util.ExprDataReader2#getNextDestIndex(int)
	 */
	protected int getNextDestIndex( int currIndex )
	{
		return destRowIndex[currIndex];
	}
		
}
