/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.data.engine.olap.api.query;

import java.util.List;

/**
 * This is the basic interface of all Edge drilling definitions.
 */

public interface IBaseEdgeDrillingDefinition
{
	/**
	 * Add a parent member for the edge drilling definition. 
	 * @param level
	 * @param value
	 */
	public void addParentMember( ILevelDefinition level, Object value );

	/**
	 * Get the value associate with certain level.
	 * @param level
	 * @return
	 */
	public Object getParentMemberValue( ILevelDefinition level );

	/**
	 * Return all the levels that associated with the edge drilling definition.
	 * @return
	 */
	public List getLevels( );

}