/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.data.engine.olap.api.query;

import java.util.List;

import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.ISortDefinition;

/**
 * This is the the interface for definition of edge drilling down.
 */

public interface IEdgeDrillingDownDefinition
		extends
			IBaseEdgeDrillingDefinition
{

	/**
	 * Set the targeting level of the edge drilling down definition. The
	 * targeting level is the leaf level after the drilling down operations.
	 * 
	 * @param level
	 */
	public void setTargetLevel( ILevelDefinition level );

	/**
	 * Return the targeting level of the edge drilling down definition.
	 * 
	 * @return
	 */
	public ILevelDefinition getTargetLevel( );

	/**
	 * Add a filter to target level. If no filter is added then by default all
	 * the values of that level will be populated.
	 * 
	 * @param filter
	 */
	public void addTargetLevelFilter( IFilterDefinition filter );

	/**
	 * Return all filters defined for target level.
	 * 
	 * @return
	 */
	public List getTargetLevelFilter( );

	/**
	 * Add sort definition for target level.
	 * 
	 * @param sort
	 */
	public void addTargetLevelSort( ISortDefinition sort );

	/**
	 * Return sorts definition for the target level.
	 * 
	 * @return
	 */
	public List getTargetLevelSort( );
}
