/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;

import org.eclipse.birt.data.engine.core.security.PropertySecurity;

/**
 * 
 */

public class TempPathManager
{
	private static final String tmpPath = PropertySecurity.getSystemProperty( "java.io.tmpdir" );
	
	public static String getTempDirName( String fileNamePrefix, int objectID )
	{
		return tmpPath + File.separatorChar + fileNamePrefix + objectID;
	}

	public static String getTempFileName( String fileNamePrefix, int objectID,
			String extName )
	{
		if ( extName == null || extName.equals( "" ) )
		{
			return tmpPath + File.separatorChar + fileNamePrefix + objectID;
		}
		else
		{
			return tmpPath
					+ File.separatorChar + fileNamePrefix + objectID + "."
					+ extName;
		}
	}

	public static String getTempFileName( String dirName,
			String fileNamePrefix, int objectID, String extName )
	{
		if ( extName == null || extName.equals( "" ) )
		{
			return dirName
					+ File.separatorChar + fileNamePrefix + objectID;
		}
		else
		{
			return dirName
					+ File.separatorChar + fileNamePrefix + objectID + "."
					+ extName;
		}
	}
}
