
/*******************************************************************************
 * Copyright (c) 2004, 2005 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/
package org.eclipse.birt.data.engine.olap.impl.query;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;

/**
 * 
 */

public class DimensionDefinition extends NamedObject
		implements
			IDimensionDefinition
{
	private List hierarchies;
	
	public DimensionDefinition( String name )
	{
		super(name);
		this.hierarchies = new ArrayList();
	}
	
	public IHierarchyDefinition createHierarchy( String name )
	{
		IHierarchyDefinition hier = new HierarchyDefinition( this, name );
		this.hierarchies.add( hier );
		return hier;
	}

	public List getHierarchy( )
	{
		return this.hierarchies;
	}

}
