/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.debug.internal.ui.script.launcher;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * ScriptSWTFactory
 */
public class ScriptSWTFactory
{

	/**
	 * Create the composite
	 * 
	 * @param parent
	 * @param font
	 * @param columns
	 * @param hspan
	 * @param fill
	 * @return
	 */
	public static Composite createComposite( Composite parent, Font font,
			int columns, int hspan, int fill )
	{
		Composite g = new Composite( parent, SWT.NONE );
		g.setLayout( new GridLayout( columns, false ) );
		g.setFont( font );
		GridData gd = new GridData( fill );
		gd.horizontalSpan = hspan;
		g.setLayoutData( gd );
		return g;
	}

	/**
	 * Creates the group
	 * 
	 * @param parent
	 * @param text
	 * @param columns
	 * @param hspan
	 * @param fill
	 * @return
	 */
	public static Group createGroup( Composite parent, String text,
			int columns, int hspan, int fill )
	{
		Group g = new Group( parent, SWT.NONE );
		g.setLayout( new GridLayout( columns, false ) );
		g.setText( text );
		g.setFont( parent.getFont( ) );
		GridData gd = new GridData( fill );
		gd.horizontalSpan = hspan;
		g.setLayoutData( gd );
		return g;
	}

	/**
	 * Create the composite
	 * 
	 * @param parent
	 * @param font
	 * @param columns
	 * @param hspan
	 * @param fill
	 * @param marginwidth
	 * @param marginheight
	 * @return
	 */
	public static Composite createComposite( Composite parent, Font font,
			int columns, int hspan, int fill, int marginwidth, int marginheight )
	{
		Composite g = new Composite( parent, SWT.NONE );
		GridLayout layout = new GridLayout( columns, false );
		layout.marginWidth = marginwidth;
		layout.marginHeight = marginheight;
		g.setLayout( layout );
		g.setFont( font );
		GridData gd = new GridData( fill );
		gd.horizontalSpan = hspan;
		g.setLayoutData( gd );
		return g;
	}

	/**
	 * Create the single text.
	 * 
	 * @param parent
	 * @param hspan
	 * @return
	 */
	public static Text createSingleText( Composite parent, int hspan )
	{
		Text t = new Text( parent, SWT.SINGLE | SWT.BORDER );
		t.setFont( parent.getFont( ) );
		GridData gd = new GridData( GridData.FILL_HORIZONTAL );
		gd.horizontalSpan = hspan;
		t.setLayoutData( gd );
		return t;
	}

	/**
	 * Create the push button
	 * 
	 * @param parent
	 * @param label
	 * @param image
	 * @return
	 */
	public static Button createPushButton( Composite parent, String label,
			Image image )
	{
		Button button = new Button( parent, SWT.PUSH );
		button.setFont( parent.getFont( ) );
		if ( image != null )
		{
			button.setImage( image );
		}
		if ( label != null )
		{
			button.setText( label );
		}

		GridData gd = new GridData( );
		button.setLayoutData( gd );
		setButtonDimensionHint( button );
		return button;
	}

	public static Button createRadioButton( Composite parent, String label )
	{
		Button button = new Button( parent, SWT.RADIO );
		button.setFont( parent.getFont( ) );
		if ( label != null )
		{
			button.setText( label );
		}

		GridData gd = new GridData( );
		button.setLayoutData( gd );
		setButtonDimensionHint( button );
		return button;
	}

	public static Button createCheckBox( Composite parent, String label )
	{
		Button button = new Button( parent, SWT.CHECK );
		button.setFont( parent.getFont( ) );
		if ( label != null )
		{
			button.setText( label );
		}

		GridData gd = new GridData( );
		button.setLayoutData( gd );
		setButtonDimensionHint( button );
		return button;
	}

	/**
	 * @param button
	 */
	private static void setButtonDimensionHint( Button button )
	{
		Assert.isNotNull( button );
		Object gd = button.getLayoutData( );
		if ( gd instanceof GridData )
		{
			( (GridData) gd ).widthHint = getButtonWidthHint( button );
			( (GridData) gd ).horizontalAlignment = GridData.FILL;
		}
	}

	/**
	 * @param button
	 * @return
	 */
	private static int getButtonWidthHint( Button button )
	{
		button.setFont( JFaceResources.getDialogFont( ) );
		PixelConverter converter = new PixelConverter( button );
		int widthHint = converter.convertHorizontalDLUsToPixels( IDialogConstants.BUTTON_WIDTH );
		return Math.max( widthHint, button.computeSize( SWT.DEFAULT,
				SWT.DEFAULT,
				true ).x );
	}

	/**
	 * PixelConverter
	 */
	static class PixelConverter
	{

		private FontMetrics fFontMetrics;

		public PixelConverter( Control control )
		{
			GC gc = new GC( control );
			gc.setFont( control.getFont( ) );
			fFontMetrics = gc.getFontMetrics( );
			gc.dispose( );
		}

		/**
		 * @see DialogPage#convertHorizontalDLUsToPixels
		 */
		public int convertHorizontalDLUsToPixels( int dlus )
		{
			return Dialog.convertHorizontalDLUsToPixels( fFontMetrics, dlus );
		}

		/**
		 * @see DialogPage#convertWidthInCharsToPixels
		 */
		public int convertWidthInCharsToPixels( int chars )
		{
			return Dialog.convertWidthInCharsToPixels( fFontMetrics, chars );
		}
	}

	/**
	 * Create the label.
	 * 
	 * @param parent
	 * @param text
	 * @param font
	 * @param hspan
	 * @return
	 */
	public static Label createLabel( Composite parent, String text, Font font,
			int hspan )
	{
		Label l = new Label( parent, SWT.NONE );
		l.setFont( font );
		l.setText( text );
		GridData gd = new GridData( );
		gd.horizontalSpan = hspan;
		l.setLayoutData( gd );
		return l;
	}

	public static Combo createCombo( Composite parent, Font font, int hspan )
	{
		Combo cb = new Combo( parent, SWT.BORDER | SWT.READ_ONLY );
		cb.setFont( font );
		GridData gd = new GridData( );
		gd.horizontalSpan = hspan;
		cb.setLayoutData( gd );
		return cb;
	}

}
