/*************************************************************************************
 * Copyright (c) 2004 Actuate Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Actuate Corporation - Initial implementation.
 ************************************************************************************/

package org.eclipse.birt.report.designer.ui.preview;

import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.viewer.ViewerPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class Activator extends AbstractUIPlugin
{

	// The shared instance.
	private static Activator plugin;

	public static final String ID = "org.eclipse.birt.report.designer.ui.preview.web"; //$NON-NLS-1$

	/**
	 * The constructor.
	 */
	public Activator( )
	{
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start( BundleContext context ) throws Exception
	{
		super.start( context );

		// ensure viewer plugin already started
		ViewerPlugin dummy = ViewerPlugin.getDefault( );

		// set the URI root path to ImageManager
		String appRootPath = System.getProperty( ViewerPlugin.BIRT_VIEWER_ROOT_PATH );
		if ( appRootPath != null )
		{
			ImageManager.getInstance( ).setURIRootPath( appRootPath );
		}
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop( BundleContext context ) throws Exception
	{
		super.stop( context );
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 * 
	 * @return the shared instance.
	 */
	public static Activator getDefault( )
	{
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given plug-in
	 * relative path.
	 * 
	 * @param path
	 *            the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor( String path )
	{
		return AbstractUIPlugin.imageDescriptorFromPlugin( ID, path );
	}
}
