/*******************************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.designer.ui.internal.rcp;

import org.eclipse.birt.report.designer.ui.rcp.nls.DesignerWorkbenchMessages;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

/**
 * Class for configuring the workbench window of BIRT RCP designer.
 */

public class DesignerWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor
{

	public DesignerWorkbenchWindowAdvisor( IWorkbenchWindowConfigurer configurer )
	{
		super( configurer );
	}

	public ActionBarAdvisor createActionBarAdvisor(
			IActionBarConfigurer configurer )
	{
		return new DesignerActionBarAdvisor( configurer );
	}

	public void preWindowOpen( )
	{
		IWorkbenchWindowConfigurer configurer = getWindowConfigurer( );
		configurer.setShowCoolBar( true );
		configurer.setShowStatusLine( true );

		String title = null;
		IProduct product = Platform.getProduct( );
		if ( product != null )
		{
			title = product.getName( );
		}

		if ( title == null )
		{
			title = DesignerWorkbenchMessages.Workbench_title;
		}
		configurer.setTitle( title );
	}
}
