/*******************************************************************************
 * Copyright (c) 2008 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.designer.ui.views.attributes;

import java.util.List;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AggregateOnBindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.BindingPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.FormPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.PreviewPage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MapDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.SortingHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FormPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.HighlightPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.MapPropertyDescriptor;
import org.eclipse.swt.custom.CTabItem;

/**
 * This page generator creates the default tab content for some built-in tab
 * keys. The caller MUST ensure relevant proeprties are already available in the
 * Model. Otherwise, it should directly extend from
 * <code>AbstractPageGenerator</code> instead of this class.
 * 
 * @since 2.5
 */
abstract public class BasePageGenerator extends AbstractPageGenerator
{

	/**
	 * Creats default content for each tab.
	 * 
	 * @param tabKey
	 */
	protected TabPage buildTabContent( String tabKey )
	{
		TabPage page = null;

		if ( tabKey.equals( BINDINGTITLE ) )
		{
			if ( isSupportAggregationBinding( ) )
			{
				page = new AggregateOnBindingPage( );
			}
			else
			{
				page = new BindingPage( );
			}
		}
		else if ( tabKey.equals( SORTINGTITLE ) )
		{
			page = new FormPage( FormPropertyDescriptor.FULL_FUNCTION,
					new SortingHandleProvider( ),
					true,
					true );
		}
		else if ( tabKey.equals( FILTERTITLE ) )
		{
			page = new FormPage( FormPropertyDescriptor.FULL_FUNCTION,
					new FilterHandleProvider( ),
					true,
					true );
		}
		else if ( tabKey.equals( HIGHLIGHTSTITLE ) )
		{
			page = new PreviewPage( true );
			( (PreviewPage) page ).setPreview( new HighlightPropertyDescriptor( true ) );
			( (PreviewPage) page ).setProvider( new HighlightDescriptorProvider( ) );
		}
		else if ( tabKey.equals( MAPTITLE ) )
		{
			page = new PreviewPage( true );
			( (PreviewPage) page ).setPreview( new MapPropertyDescriptor( true ) );
			( (PreviewPage) page ).setProvider( new MapDescriptorProvider( ) );
		}

		return page;
	}

	protected void buildItemContent( CTabItem item )
	{
		if ( itemMap.containsKey( item ) && itemMap.get( item ) == null )
		{
			String title = tabFolder.getSelection( ).getText( );

			TabPage page = buildTabContent( title );

			if ( page != null )
			{
				setPageInput( page );
				refresh( tabFolder, page, true );
				item.setControl( page.getControl( ) );
				itemMap.put( item, page );
			}
		}
		else if ( itemMap.get( item ) != null )
		{
			setPageInput( itemMap.get( item ) );
			refresh( tabFolder, itemMap.get( item ), false );
		}
	}

	public void createTabItems( List input )
	{
		super.createTabItems( input );
		this.input = input;
		addSelectionListener( this );
		createTabItems( );
		if ( tabFolder.getSelection( ) != null )
		{
			buildItemContent( tabFolder.getSelection( ) );
		}
	}

	/**
	 * @return Returns if the binding page should support aggregation when
	 *         requested for creation
	 */
	protected boolean isSupportAggregationBinding( )
	{
		return false;
	}

	/**
	 * overwrite to add additional tabs.
	 */
	abstract protected void createTabItems( );
}
