/*******************************************************************************
 * Copyright (c) 2004, 2008Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.engine.emitter.excel;

import java.io.Serializable;

/**
 * This class is used to store element's span information.
 * 
 * 
 */
public class Span implements Serializable
{

	private static final long serialVersionUID = 5452053919994701546L;
	private final int colSpan, col;

	/**
	 * 
	 * @param c
	 *            curent column
	 * @param cs
	 *            column span count
	 */
	public Span( int c, int cs )
	{
		colSpan = cs;
		col = c;

	}

	public int getColSpan( )
	{
		return colSpan;
	}

	public int getCol( )
	{
		return col;
	}

	public int hashCode( )
	{
		return col + 31 * colSpan;
	}

	public boolean equals( Object o )
	{
		if ( o == this )
		{
			return true;

		}
		if ( !( o instanceof Span ) )
		{
			return false;
		}
		Span span = (Span) o;
		if ( span.col == col && span.colSpan == colSpan )
		{
			return true;
		}
		return false;
	}
}
