
package org.eclipse.birt.report.engine.emitter.excel.chart;

import org.eclipse.birt.report.engine.emitter.excel.Data;
import org.eclipse.birt.report.engine.emitter.excel.StyleBuilder;
public abstract class AbstractDataHelper implements DataHelper
{
	protected TableDataSet[] initTableColumns( int pos, int width,
			String identifier )
	{
		TableDataSet[] columns = new TableDataSet[width];

		for ( int i = 0; i < columns.length; i++ )
		{
			columns[i] = new TableDataSet( i + pos );
			columns[i].identifier = identifier;
		}

		return columns;
	}	

	public TableDataSet[] getTableDataSets( int pos, String identifier )
	{
		TableDataSet[] columns = initTableColumns( pos, getWidth( ), identifier );

		for ( int i = 0; i < datalength; i++ )
		{
			setValueToColumn( columns, i );
		}

		return columns;
	}		
	
	public boolean analyseData( Object value )
	{
		if(value != null && value instanceof Object[])
		{
			Object[] data = (Object[]) value;			
			datalength = data.length;	
			
			return true;
		}
		
		return false;		
	}
    
    public static Data createData(Object value, int type)
    {
    	 return new Data( value, StyleBuilder.createEmptyStyleEntry(), type, null );
    }
    
	protected abstract int getWidth( );	
	
	protected abstract void setValueToColumn(TableDataSet[] cols, int pos);
	
	private int datalength = 0;
}
